ORCA/M Asm65816 2.1.0

0001 6656              **********************************************************************
0002 6656              *
0003 6656              * Dialog Manager Version 3.3
0004 6656              *
0005 6656              * Copyright Apple Computer, Inc. 1986-1993
0006 6656              * All rights reserved.
0007 6656              *
0008 6656              *
0009 6656              * Originally by Jean-Charles Mourey
0010 6656              * Modified by Harry Yee
0011 6656              *
0012 6656              * The dialog manager is a tool that supports modal and modeless 
0013 6656              * dialogs.
0014 6656              *
0015 6656              * Files:
0016 6656              *    Special.Macros
0017 6656              *
0018 6656              * Modification History
0019 6656              *
0020 6656              * Version 1.3
0021 6656              *
0022 6656              * January 16, 1987                 Steven Glass
0023 6656              *
0024 6656              * The User Control DefProc was always dereferencing the control and
0025 6656              * setting the port.  Even when the RecSize message was being sent.
0026 6656              * This is not allowed.  Very bad!
0027 6656              *
0028 6656              * January 28, 1987                 Steven Glass
0029 6656              *
0030 6656              * I found that the LineEdit defproc had the same problem as above.
0031 6656              * It always set the port and origin even for the RecSize message.
0032 6656              *
0033 6656              * Jim Merrit also reported a bug in SetDAFont which seemed to be
0034 6656              * caused by the storeLONGinZP routine.  The routine was only
0035 6656              * storing the first word of the long rather than the whole thing.
0036 6656              *
0037 6656              * VERSION 2.0
0038 6656              *
0039 6656              * April 20, 1987                    Dan Hitchens
0040 6656              *
0041 6656              * A new item type, LongStatText2, was incorporated into the Dialog
0042 6656              * manager.  Its Itemtype=22 and its PartCode=15.
0043 6656              *
0044 6656              * A bug in IsDialogEvent which allowed it to claim all update and
0045 6656              * activate events was fixed. It now functions correctly by only
0046 6656              * claiming those activate and update events which occur in a dialog
0047 6656              * window.
0048 6656              *
0049 6656              * VERSION 2.X
0050 6656              *
0051 6656              * November xx,1987                   Dan Hitchens
0052 6656              *
0053 6656              * A bug in GetNewXXX with a refcon value of non-zero would cause a crash
0054 6656              * or unpredictable results was fixed.
0055 6656              *
0056 6656              * A bug with IsDialogEvent which didn't allow it to claim the following
0057 6656              * events: WInDrag, WInGrow, WInGoAway, WInZoom, WInInfo, WInVerScrl,
0058 6656              * WInHorScrl, WInFrame, WinDrop.
0059 6656              *
0060 6656              *
0061 6656              * Version 2.1       Harry Yee
0062 6656              *
0063 6656              * February 1988
0064 6656              *
0065 6656              * Code modified to build under MAX.
0066 6656              *
0067 6656              * Code modified to avoid using in line storage so it should work in 
0068 6656              * ROM.
0069 6656              *
0070 6656              * March 4, 1988
0071 6656              *
0072 6656              * Code re-formatted and entabbed.
0073 6656              *
0074 6656              * March 28, 1988    Harry Yee           v2.2d1
0075 6656              *
0076 6656              * DisableDItem/EnableDItem call, when passed an invalid ID item number, would fail because
0077 6656              * it did not clean up the stack correctly when exiting. The enable/disable flag was left
0078 6656              * on the stack.  This has been fixed 
0079 6656              *
0080 6656              * May 2, 1988       Harry Yee           v2.2d2 (for System Disk 3.2d21)
0081 6656              *
0082 6656              * HideDItem/ShowDItem, GetDItemValue, when passed an invalid ID item number, would fail
0083 6656              * because it did not clean up the stack correctly when exiting.  This has been fixed
0084 6656              *
0085 6656              * May 9, 1988       Harry Yee           v2.2d3 (for System Disk 3.2d22)
0086 6656              *
0087 6656              * Problem with using the special paramtext indicators "^0" to "^3" when they are used as 
0088 6656              * the last character on a line.  An extra garbage char. is printed out along with the
0089 6656              * string.  In the procedure InsertParamString the length byte DestLen was being incremented
0090 6656              * by one too many when the procedure exited causing _LETextBox to print out one to many
0091 6656              * characters. This has been fixed.
0092 6656              *
0093 6656              * May 16, 1988      Harry Yee           v2.2d4 (for System Disk 3.2d23)
0094 6656              *
0095 6656              * The following calls: GetDItemType, SetDItemType, SetDItemValue, when passed an
0096 6656              * invalid ID item number, would fail because it did not clean up the stack correctly
0097 6656              * when exiting. This has been fixed in the routines GetItemWord, SetItemWord, and
0098 6656              * SetDItemValue respectively.
0099 6656              *
0100 6656              * May 27, 1988      Harry Yee           v2.2d5 (for System Disk 3.2d25)
0101 6656              *
0102 6656              * Fixed DialogStatus call. After calling DialogShutDown and then calling DialogStatus, 
0103 6656              * DialogStatus would always return non-zero, meaning it was still active.
0104 6656              *
0105 6656              *
0106 6656              * 07 Jun 88         Harry and Steve     v 2.2d5 (for System Disk 3.2d26)
0107 6656              *
0108 6656              * The StatText, LongStatText LineEdit drawing routines assumed the foreground
0109 6656              * and background colors in the GrafPort were correctly set.  This was
0110 6656              * only the case if other controls in the dialog had been colored and 
0111 6656              * had been drawn first.
0112 6656              *
0113 6656              * 15 Jun 88         Harry Yee
0114 6656              *
0115 6656              * Prototype bit taken out of TheDialogVersionNum for final release.
0116 6656              *
0117 6656              * 13 Jul 88         Harry Yee           v2.3d1 (for System Disk 4.0d11)
0118 6656              *
0119 6656              * IsDialogEvent is capturing too many taskmaster events. wInContent 
0120 6656              * should be the only one that causes IsDialogEvent to return True. This 
0121 6656              * undoes the change from November xx, 1987 by Dan Hitchens.
0122 6656              *
0123 6656              * Handle for memory obtained during DialogStartup for the window parameters was
0124 6656              * being locked down until DialogShutDown was called which disposed of the handle.
0125 6656              * The handle is now created with no restrictions and locked down and dereferenced
0126 6656              * when used and then unlocked when its not (this handle is only accessed in routine
0127 6656              * NewDialog).  The UserID was also incorrect for the memory obtained. I now use
0128 6656              * what was passed to me in ProgramID.
0129 6656              *
0130 6656              * 26 Jul 88         Harry Yee           v2.3d2 (for System Disk 4.0d14)
0131 6656              *
0132 6656              * Having a paramtext string of length zero inserts two bytes of garbage in
0133 6656              * the output string. Fix was in routine InsertParamString.  When a paramtext
0134 6656              * indicator ^n was encountered we were not checking for a zero length string.
0135 6656              * Therefore we were always writing at least two bytes of garbage into the
0136 6656              * output string.
0137 6656              *
0138 6656              * 04 Aug 88         Harry Yee           v2.3d3 (for System Disk 4.0d16)
0139 6656              *
0140 6656              * Routine Long_Call did not RTL to the correct location if the address of the routine
0141 6656              * was located at the very beginning of a bank (i.e. n/0000). Long_call used to 
0142 6656              * decrement the data bank also if the low word of the address was zero. We now no
0143 6656              * longer touch the data bank, and only decrement the low word.
0144 6656              *
0145 6656              * 07 Oct 88         Steven Glass        v2.4 for v4.1d2 and RevD03
0146 6656              *
0147 6656              * The StatText, LongStatText and Icon DefProcs were always dereferencing 
0148 6656              * the control and doing other setup...  even when the RecSize message 
0149 6656              * was being sent.
0150 6656              *
0151 6656              * 02 Dec 88         Harry Yee           v2.4 for v4.1d5 disk and RevD07
0152 6656              *
0153 6656              * Fixed bug in GetNextDItem (BRC #38734). Only the low word of the handle to
0154 6656              * the next control was being used. Also was not checking for end of control list.
0155 6656              *
0156 6656              * 19 May 89         Steven Glass
0157 6656              *
0158 6656              * Change to DialogStart to ignore previous state.  Should help
0159 6656              * Mavis Beacon keep running.
0160 6656              *
0161 6656              * 9/7/89            Mensch
0162 6656              * Changed a handle allocation to allocate a fixed handle, this prevents the 
0163 6656              * dialog manager writing over someone else's memory.
0164 6656              *
0165 6656              * 11/13/89          Mensch
0166 6656              *
0167 6656              * Fixed modal dialog so that it does not suck off app events BRC#53469
0168 6656              *
0169 6656              **********************************************************************
0170 6656                       blanks off 
0171 6656                       string asis 
0172 6656
0173 6656              TheDialogVersionNum equ   $0300
0174 6656
0175 6656              ColorIcons equ   0
0176 6656
0177 6656                       include 'all.macros' 
0178 6656                       include 'special.macros' 
0179 6656
0180 6656                       longa on
0181 6656                       longi on
0182 6656
0183 6656              ; *      copy  MemEqu.asm
0184 6656              ********************************************************************************
0185 6656              *
0186 6656              *        Memory Manager Equates:
0187 6656              *
0188 6656              *              Constants and Internal Structures
0189 6656              *
0190 6656              *******************************************************************************
0191 6656              *
0192 6656              * General Constants
0193 6656              *
0194 6656              nil      equ   0                        Nil pointer value
0195 6656              true     equ   $FFFF                    Boolean true
0196 6656              false    equ   $0000                    Boolean false
0197 6656
0198 6656              ;*
0199 6656              ;* Bank E1 memory equates
0200 6656              ;* addresses $E115AA - $E11AFF are reserved for the memory manager
0201 6656              ;*
0202 6656              ;MMRam              equ $E115AA         Beginning of our ram
0203 6656              ;MMRamEnd           equ $E11AFF         Last byte of our ram
0204 6656              ;
0205 6656              ;* Pointers to segment lists
0206 6656              ;*
0207 6656              ;MemList            equ $E11600         List of used segments
0208 6656              ;PurgeList          equ $E11604         List of used but empty handles
0209 6656              ;FreeList           equ $E11608         List of free handles
0210 6656              ;Mem01              equ $E1160C         Begining of bank 1
0211 6656              ;MemE0              equ $E11610         Begining of bank E0
0212 6656              ;MemFF              equ $E11614         Last segment
0213 6656              ;
0214 6656              ;* Other stuff
0215 6656              ;*
0216 6656              ;DoMove             equ $E11618         Code that does block move
0217 6656              ;NumBanks           equ $E1161C         Number of 64K banks in machine
0218 6656              ;;                                      not counting E0, E1
0219 6656              ;HandleBuf          equ $E11700         $E11700 - $E1AFF is used for handles
0220 6656
0221 6656              *
0222 6656              * Zero page stuff
0223 6656              *
0224 6656              error    equ   1                        Error code
0225 6656              addr     equ   error+2
0226 6656              Count    equ   addr
0227 6656              attr     equ   addr+4
0228 6656              Dest     equ   attr                     Block Move Destination
0229 6656              owner    equ   attr+2
0230 6656              size     equ   owner+2
0231 6656              Source   equ   size
0232 6656              hndl1    equ   size+4
0233 6656              TempCount equ   hndl1
0234 6656              hndl2    equ   hndl1+4
0235 6656              hndl     equ   hndl2+4
0236 6656              addr1    equ   hndl+4
0237 6656              addr2    equ   addr1+4
0238 6656              ZPSize   equ   addr2+4-1                # bytes we're adding to stack
0239 6656
0240 6656              numparms equ   addr2+4
0241 6656              return   equ   numparms+2               Users 2 return addresses
0242 6656              parms    equ   return+6                 Parameters start here
0243 6656
0244 6656              * Parameters and function results
0245 6656              *
0246 6656              ParmHndl equ   parms                    Inputted handle for most calls
0247 6656              ResHndl  equ   parms+12                 Handle returned by newhandle
0248 6656              ;                                       and handle inputted by reallochandle
0249 6656
0250 6656              * End of zero page stuff
0251 6656
0252 6656              *
0253 6656              * The handle data structure
0254 6656              *
0255 6656              Hndl_Addr equ   0                       4 byte address pointed to by handle
0256 6656              Hndl_Attr equ   4                       2 byte attributes byte
0257 6656              Hndl_Owner equ   6                      2 byte segment owner ID
0258 6656              Hndl_Size equ   8                       4 byte size
0259 6656              Hndl_Prev equ   12                      4 byte pointer to previous handle
0260 6656              Hndl_Next equ   16                      4 byte pointer to next handle
0261 6656              HSize    equ   20                       Size of handle data structure
0262 6656
0263 6656              * Handle attributes bits
0264 6656              *
0265 6656              Attr_Locked equ   $8000                 1 = Locked
0266 6656              Attr_Fixed equ   $4000                  1 = Not movable
0267 6656              Attr_Purge equ   $0300                  0 = No purge 1-3 purge level
0268 6656              Attr_NoCross equ   $0010                1 = May not cross banks
0269 6656              Attr_NoSpec equ   $0008                 1 = May not use special memory
0270 6656              Attr_Page equ   $0004                   1 = Page Aligned
0271 6656              Attr_Addr equ   $0002                   1 = Fixed address
0272 6656              Attr_Bank equ   $0001                   1 = Fixed address
0273 6656
0274 6656              *
0275 6656              * Error codes
0276 6656              *
0277 6656              MFullErr equ   $0201                    Memory full error
0278 6656              NilErr   equ   $0202                    Operation on a nil handle
0279 6656              NotNilErr equ   $0203                   Operation on a non nil handle
0280 6656              LockErr  equ   $0204                    Operation on a locked block
0281 6656              PurgeErr equ   $0205                    Attempt to purge unpurgeable block
0282 6656              HandleErr equ   $0206                   Invalid handle inputted
0283 6656
0284 6656
0285 6656              ; *      copy  QdHeader.asm
0286 6656              ; QDHeader.asm
0287 6656
0288 6656                       TITLE 'QuickDraw Header'
0289 6656
0290 6656              ;++++++++++++++++++++++++++++++++++++++++++++++
0291 6656              ;
0292 6656              ; Some Structures and Equates from QuickDraw
0293 6656              ;
0294 6656              ;++++++++++++++++++++++++++++++++++++++++++++++
0295 6656              ;
0296 6656              ;
0297 6656              ;
0298 6656              ; +++ Paint Pixels parameter block ++++++++
0299 6656              ;
0300 6656              PP_SrcInfo equ   0
0301 6656              PP_DesInfo equ   PP_SrcInfo+4
0302 6656              PP_SrcRect equ   PP_DesInfo+4
0303 6656              PP_DesRect equ   PP_SrcRect+4
0304 6656              PP_Mode  equ   PP_DesRect+4
0305 6656              PP_Clip  equ   PP_Mode+2
0306 6656              ;
0307 6656              ; +++ LocInfo record +++++++++++++++++
0308 6656              ;
0309 6656              PortSCB  equ   0
0310 6656              PixelImage equ   PortSCB+2
0311 6656              Width    equ   PixelImage+4
0312 6656              PBounds  equ   Width+2
0313 6656              LOCINFO  equ   PBounds+8
0314 6656              ;
0315 6656              ; +++++ Region record +++++
0316 6656              ;
0317 6656              Rgn_Len  equ   0
0318 6656              Rgn_Bounds equ   Rgn_Len+2
0319 6656              ;
0320 6656              ;
0321 6656              ; +++++ Port record +++++
0322 6656              ;
0323 6656              GP_PortInfo equ   0
0324 6656              GP_Bounds equ   GP_PortInfo+8
0325 6656              GP_PortRect equ   GP_Bounds+8
0326 6656              GP_ClipRgn equ   GP_PortRect+8
0327 6656              GP_VisRgn equ   GP_ClipRgn+4
0328 6656              GP_BkPat equ   GP_VisRgn+4
0329 6656              ;
0330 6656              PORTSIZE equ   186
0331 6656              ;
0332 6656              ; +++++ Rectangle Structure +++++
0333 6656              ;
0334 6656              y1       equ   0
0335 6656              x1       equ   y1+2
0336 6656              y2       equ   x1+2
0337 6656              x2       equ   y2+2
0338 6656              RECTSIZE equ   x2+2
0339 6656
0340 6656              ;
0341 6656              ; *** window parameter block for _NewWindow ***
0342 6656              ;
0343 6656              templ_len equ   0
0344 6656              wind_frame equ   templ_len+2
0345 6656              wind_title equ   wind_frame+2
0346 6656              wind_ref equ   wind_title+4
0347 6656              wind_full equ   wind_ref+4
0348 6656              wind_clr equ   wind_full+8
0349 6656              wind_voff equ   wind_clr+4
0350 6656              wind_hoff equ   wind_voff+2
0351 6656              wind_datah equ   wind_hoff+2
0352 6656              wind_dataw equ   wind_datah+2
0353 6656              wind_max_h equ   wind_dataw+2
0354 6656              wind_max_w equ   wind_max_h+2
0355 6656              wind_vscrl equ   wind_max_w+2           Number of pixels to scroll vertically.
0356 6656              wind_hscrl equ   wind_vscrl+2           Number of pixels to scroll horizontally.
0357 6656              wind_vpage equ   wind_hscrl+2           Number of pixels to page vertically.
0358 6656              wind_hpage equ   wind_vpage+2           Number of pixels to page horizontally.
0359 6656              wind_infot equ   wind_hpage+2           Infomation bar text string.
0360 6656              wind_infoh equ   wind_infot+4           Height of information bar
0361 6656              wind_def equ   wind_infoh+2             DefProc.
0362 6656              wind_info equ   wind_def+4              Routine to draw info. bar.
0363 6656              wind_draw equ   wind_info+4             Routine to draw content.
0364 6656              wind_pos equ   wind_draw+4              Size/Position of content.
0365 6656              wind_plane equ   wind_pos+8             Plane to put window up in.
0366 6656              wind_rec equ   wind_plane+4             Address of memory for window record.
0367 6656
0368 6656              ;
0369 6656              ; Icon Item Template
0370 6656              ;
0371 6656              IconitemID equ   0
0372 6656              IconitemRect equ   IconitemID+2
0373 6656              IconitemType equ   IconitemRect+8
0374 6656              IconitemDescr equ   IconitemType+2
0375 6656              IconitemValue equ   IconitemDescr+4
0376 6656              IconitemFlag equ   IconitemValue+2
0377 6656              IconitemColor equ   IconitemFlag+2
0378 6656
0379 6656
0380 6656              ;
0381 6656              ; *      copy  EvHeader.asm
0382 6656              ; EvHeader.asm
0383 6656
0384 6656                       TITLE 'Event Manager Header'
0385 6656
0386 6656              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++
0387 6656              ;
0388 6656              ; Structures and Equates for the Event Manager
0389 6656              ;
0390 6656              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++
0391 6656
0392 6656              ;
0393 6656              ; +++++ Event Structure +++++
0394 6656              ;
0395 6656              what     equ   0
0396 6656              message  equ   what+2
0397 6656              when     equ   message+4
0398 6656              where    equ   when+4
0399 6656              modif    equ   where+4
0400 6656              evtsize  equ   modif+2
0401 6656
0402 6656              TaskData equ   modif+2                  when using TaskMaster
0403 6656              TaskMask equ   TaskData+4               events to be handled by TaskMaster
0404 6656
0405 6656              ;
0406 6656              ;
0407 6656              ; --- Event codes ----------------------------------------
0408 6656              ;
0409 6656              inNull   equ   $00                      No further action required.
0410 6656              inButtDwn equ   $01                     Button down event.
0411 6656              inButtUp equ   $02                      Button up event.
0412 6656              inKey    equ   $03                      Key event.
0413 6656              ;              $04                      (Not defined.)
0414 6656              inAutoKey equ   $05                     Auto-Key event.
0415 6656              inUpdate equ   $06                      Update event.
0416 6656              ;              $07                      (Not defined.)
0417 6656              inActWind equ   $08                     Activate window event.
0418 6656              inSwitch equ   $09                      Switch event.
0419 6656              inAccess equ   $0A                      Desk Accessory event.
0420 6656              inDevice equ   $0B                      Device driver event.
0421 6656              ;              $0C                      Application defined.
0422 6656              ;              $0D                      Application defined.
0423 6656              ;              $0E                      Application defined.
0424 6656              ;              $0F                      Application defined.
0425 6656              ;
0426 6656              ;
0427 6656              ; --- Modifier key flags --------------------------------
0428 6656              ;
0429 6656              K_KEYPAD equ   $2000
0430 6656              K_CTRL   equ   $1000
0431 6656              K_OPTION equ   $0800
0432 6656              K_CAPSLOCK equ   $0400
0433 6656              K_SHIFT  equ   $0200
0434 6656              K_COMMAND equ   $0100
0435 6656              K_BUTT0  equ   $0080
0436 6656              K_BUTT1  equ   $0040
0437 6656              K_CHANGE equ   $0002
0438 6656              K_ACTIVE equ   $0001
0439 6656              ;
0440 6656              ;
0441 6656              ; --- These are values returned by FindWindow and TaskMaster,    ------
0442 6656              ; --- and may mean different things depending on who returns it. ------
0443 6656              ;
0444 6656              inDesk   equ   $10                      On the desktop.
0445 6656              inSysMenu equ   $11                     In system menu bar
0446 6656              inSysWind equ   $12                     In system window (desk accessory).
0447 6656              inContent equ   $13                     In a content region.
0448 6656              inDrag   equ   $14                      In a drag region.
0449 6656              inGrow   equ   $15                      In a grow (size) region.
0450 6656              inGoAway equ   $16                      In a go-away (close box) region.
0451 6656              inZoom   equ   $17                      In a zoom (zoom box) region.
0452 6656              inInfo   equ   $18                      In the information bar.
0453 6656              inVerScrl equ   $19                     In the vertical scroll bar.
0454 6656              inHorScrl equ   $1A                     In the horizontal scroll bar.
0455 6656              inFrame  equ   $1B                      On a window frame, other than above.
0456 6656              inDrop   equ   $1C                      On a window drop shadow.
0457 6656              ;
0458 6656              ;
0459 6656
0460 6656              ; *      copy  WHeader.asm
0461 6656              ; WHEADER.ASM                      D. Oliver
0462 6656              ;
0463 6656              ; Structures and Equates for Cortland Window Manager.
0464 6656              ;
0465 6656              ;
0466 6656              ;
0467 6656              ; +++ Window structure and equates ++++++++++++++++++++++++++
0468 6656              ;
0469 6656              ;          Copyright Apple Computer, Inc.1986-88.  All Rights Reserved 
0470 6656              ;                Written by Dan Oliver
0471 6656              ;          *** C O N F I D E N T I A L ***
0472 6656              ;
0473 6656              ;
0474 6656              ;
0475 6656              wnext    equ   0                        Pointer to next window, 0=bottom.
0476 6656              wport    equ   wnext+4                  Window's port.
0477 6656              wstrucRgn equ   wport+PORTSIZE          Handle of window's entire region.
0478 6656              wcontRgn equ   wstrucRgn+4              Handle of window's content region.
0479 6656              wupdateRgn equ   wcontRgn+4             Handle of area needing to be redrawn.
0480 6656              wcontrol equ   wupdateRgn+4             Pointer to controls in window.
0481 6656              wFrameCtrl equ   wcontrol+4             Pointer to controls in frame.
0482 6656              ;
0483 6656              wframe   equ   wFrameCtrl+4             Type of window, frame flags.
0484 6656              wtitle   equ   wframe+2                 Pointer to window's title.
0485 6656              wrefCon  equ   wtitle+4                 Reserved for application.
0486 6656              wfull    equ   wrefCon+4                Size of window, used with ZoomWindow.
0487 6656              wcolor   equ   wfull+8                  Pointer to window's color table.
0488 6656              y_origin equ   wcolor+4                 Content's vertical offset.
0489 6656              x_origin equ   y_origin+2               Content's horizontal offset.
0490 6656              data_h   equ   x_origin+2               Height of total data area.
0491 6656              data_w   equ   data_h+2                 Width of total data area.
0492 6656              wmaxheight equ   data_w+2               Maximum height for grow window.
0493 6656              wmaxwidth equ   wmaxheight+2            Maximum width for grow window.
0494 6656              vscroll  equ   wmaxwidth+2              Amount to scroll vertically (arrows).
0495 6656              hscroll  equ   vscroll+2                Amount to scroll horizonally (arrows).
0496 6656              vpage    equ   hscroll+2                Amount to page vertically (page region).
0497 6656              hpage    equ   vpage+2                  Amount to page horizontally (page rgn).
0498 6656              wInfoText equ   hpage+2                 Value passed to Draw Info routine.
0499 6656              wInfoHeight equ   wInfoText+4
0500 6656              wdefProc equ   wInfoHeight+2            Window's definition procedure.
0501 6656              wInfoDraw equ   wdefProc+4              Address of routine to draw Info Bar.
0502 6656              updateDraw equ   wInfoDraw+4            Address of routine to draw content region.
0503 6656              ;
0504 6656              wtitle_w equ   updateDraw+4             Width of title in pixels.
0505 6656              woldYOrg equ   wtitle_w+2               Save y origin on full window.
0506 6656              woldXOrg equ   woldYOrg+2               Save x origin on full window.
0507 6656              worgn_mask equ   woldXOrg+2
0508 6656              WINDSIZE equ   worgn_mask+2             Total size of a standard window structure.
0509 6656              ;
0510 6656              ;
0511 6656              ;
0512 6656              ; +++++ Window coordinate offsets +++++
0513 6656              ;
0514 6656              TITLEH   equ   13                       Height of title bar.
0515 6656              TITLEL   equ   2                        Space on left and right of title bar pattern.
0516 6656              TITLET   equ   3                        Space on top and bottom of title bar pattern.
0517 6656              ;
0518 6656              CLOSEL   equ   10                       Left side of window to left side of close box.
0519 6656              CLOSET   equ   2                        Top of window to top of close box.
0520 6656              CLOSEW   equ   22                       Width of close box.
0521 6656              CLOSEH   equ   11                       Height of close box.
0522 6656              ;
0523 6656              ;
0524 6656              ; --- Flag masks for wkind ------------------------------
0525 6656              ;
0526 6656              W_SYSTEM equ   $8000                    1 = system window.
0527 6656              ;
0528 6656              ;
0529 6656              ; --- Window Frame Type Masks ----------------------
0530 6656              ;
0531 6656              F_TITLE  equ   $8000                    TRUE = title bar.
0532 6656              F_CLOSE  equ   $4000                    TRUE = close box.
0533 6656              F_ALERT  equ   $2000                    TRUE = alert frame.
0534 6656              F_RSCRL  equ   $1000                    TRUE = right scroll bar.
0535 6656              F_BSCRL  equ   $0800                    TRUE = bottom scroll bar.
0536 6656              F_GROW   equ   $0400                    TRUE = sizer box.
0537 6656              F_ZOOM   equ   $0100                    TRUE = full box.
0538 6656              F_MOVE   equ   $0080                    TRUE = allow move on title bar.
0539 6656              F_VIS    equ   $0020                    TRUE = window is visible.
0540 6656              F_INFO   equ   $0010                    TRUE = content inset from left side.
0541 6656              F_CTRL_TIE equ   $0008                  TRUE = controls not tied to window
0542 6656              F_ALLOCATE equ   $0004                  TRUE = window record allocated by me.
0543 6656              F_ZOOMED equ   $0002                    TRUE = window is currently zoomed
0544 6656              F_HILITED equ   $0001                   TRUE = frame is highlighted.
0545 6656              ;
0546 6656              ;
0547 6656              ; --- Window color table offsets -----------------------------
0548 6656              ;
0549 6656              FRAME_CLR equ   0                       Frame's outline.
0550 6656              TITLE_CLR equ   FRAME_CLR+2             Title's color.
0551 6656              BAR_CLR  equ   TITLE_CLR+2              Title bar's initerior.
0552 6656              GROW_CLR equ   BAR_CLR+2                Grow box interior.
0553 6656              INFOR_CLR equ   GROW_CLR+2              Information bar interior.
0554 6656              COLORSIZ equ   INFOR_CLR+2              Size of color table.
0555 6656              ;
0556 6656              WindToolNum equ   14
0557 6656              ;
0558 6656              ; --- Variation code, command to window definition procedure ----------
0559 6656              ;
0560 6656              wDraw    equ   0                        Draw window's frame.
0561 6656              wHit     equ   1                        Tell what region given point is in.
0562 6656              wCalcRgns equ   2                       Calculate wstrucRgn and wcontRgn.
0563 6656              wNew     equ   3                        Do any additional initialization.
0564 6656              wDispose equ   4                        Take any additional disposal actions.
0565 6656              wGrow    equ   5                        Draw window's grow image.
0566 6656              ;
0567 6656              ; --- Hit return flags -------------------------------------------------
0568 6656              ;
0569 6656              Null     equ   0
0570 6656              wInDesk  equ   $10                      On Desktop.
0571 6656              wInMenuBar equ   $11                    On System Menu Bar.
0572 6656              wInSysWindow equ   $12                  On System window.
0573 6656              winContent equ   $13                    In content region.
0574 6656              wInDrag  equ   $14                      In drag region.
0575 6656              wInGrow  equ   $15                      In grow region, active window only.
0576 6656              wInGoAway equ   $16                     In go-away region, active window only.
0577 6656              wInZoom  equ   $17                      In zoom region, active window only.
0578 6656              wInInfo  equ   $18                      In information bar.
0579 6656              wInVScroll equ   $19                    In right scroll bar.
0580 6656              wInHScroll equ   $1A                    In bottom scroll bar.
0581 6656              wInFrame equ   $1B                      In frame, but not on anything else.
0582 6656
0583 6656              ;
0584 6656              ;
0585 6656              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++
0586 6656              ;          Drawing Equates
0587 6656              ;
0588 6656              ;          Copyright 1986 Apple Computer, Inc.
0589 6656              ;                Written by Dan Oliver
0590 6656              ;          *** C O N F I D E N T I A L ***
0591 6656              ;
0592 6656              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++
0593 6656              ;
0594 6656              ;
0595 6656              BLACK    equ   $0000
0596 6656              RED      equ   $1111
0597 6656              GREEN    equ   $2222
0598 6656              BLUE     equ   $3333
0599 6656              TEAL     equ   $4444
0600 6656              COLOR5   equ   $5555
0601 6656              BROWN    equ   $6666
0602 6656              DKGRAY   equ   $7777
0603 6656              LTGRAY   equ   $8888
0604 6656              ORANGE   equ   $9999
0605 6656              COLOR10  equ   $aaaa
0606 6656              COLOR11  equ   $bbbb
0607 6656              YELLOW   equ   $cccc
0608 6656              MAGENTA  equ   $dddd
0609 6656              CYAN     equ   $eeee
0610 6656              WHITE    equ   $ffff
0611 6656              ;
0612 6656              ; +++ Pattern types +++
0613 6656              ;
0614 6656              P_SOLID  equ   $0000
0615 6656              P_DITHER equ   $0100
0616 6656              P_DOTTED equ   $0200
0617 6656              P_LINED  equ   $0300
0618 6656              ;
0619 6656
0620 6656
0621 6656              ;
0622 6656              ; *      copy  CHeader.asm
0623 6656              ; CHEADER.ASM                      D. Oliver
0624 6656              ;
0625 6656                       TITLE 'CHEADER.ASM'
0626 6656              ;
0627 6656              ; Structures and Equates for Cortland Control Manager.
0628 6656              ;
0629 6656              ;
0630 6656              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++
0631 6656              ;        Offsets for control structures.
0632 6656              ;
0633 6656              ;          Copyright 1986 Apple Computer, Inc.
0634 6656              ;                Written by Dan Oliver
0635 6656              ;          *** C O N F I D E N T I A L ***
0636 6656              ;
0637 6656              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++
0638 6656              ;
0639 6656              ;
0640 6656              ; +++ General control header +++
0641 6656              ;
0642 6656              CtrlNext equ   0
0643 6656              CtrlOwner equ   CtrlNext+4
0644 6656              CtrlRect equ   CtrlOwner+4
0645 6656              CtrlFlag equ   CtrlRect+RECTSIZE
0646 6656              CtrlHilite equ   CtrlFlag+1
0647 6656              CtrlValue equ   CtrlHilite+1
0648 6656              CtrlProc equ   CtrlValue+2
0649 6656              CtrlAction equ   CtrlProc+4
0650 6656              CtrlData equ   CtrlAction+4
0651 6656              CtrlrefCon equ   CtrlData+4
0652 6656              CtrlColor equ   CtrlrefCon+4
0653 6656              Thumb    equ   CtrlColor+4
0654 6656              PageRegion equ   Thumb+RECTSIZE
0655 6656              ;
0656 6656              ;
0657 6656              ; --- CtrlFlag bit flags --------------------
0658 6656              ;
0659 6656              C_HILITE equ   $FF00                    Hilited part, 255 = inactive.
0660 6656              UP_FLAG  equ   $0001                    Up arrow.
0661 6656              DOWN_FLAG equ   $0002                   Down arrow.
0662 6656              LEFT_FLAG equ   $0004                   Left arrow.
0663 6656              RIGHT_FLAG equ   $0008                  Right arrow.
0664 6656              DIR_SCROLL equ   $0010                  0 = vertical, 1 = horizontal scroll.
0665 6656              CTRL_INVIS equ   $0080                  1 if control is invisible.
0666 6656              FAMILY   equ   $007F                    family number for radio buttons
0667 6656              BOLD_BUTT equ   $0001                   1 if thick outline for button
0668 6656
0669 6656              NO_BOLD_BUTT equ   $FFFE                equals (not BOLD_BUTT)
0670 6656              ;
0671 6656              ;
0672 6656              ; --- Task numbers ----------------------------
0673 6656              ;
0674 6656              drawCntl equ   0                        Draw the control.
0675 6656              calcCRect equ   drawCntl+1              Compute the drag RECT.
0676 6656              testCntl equ   calcCRect+1              Perform a hit test on the control.
0677 6656              initCntl equ   testCntl+1               Perform additional initialization.
0678 6656              dispCntl equ   initCntl+1               Perform additional disposal.
0679 6656              posCntl  equ   dispCntl+1               Called when dragging complete with delta.
0680 6656              thumbCntl equ   posCntl+1               Setup for dragging.
0681 6656              dragCntl equ   thumbCntl+1              Perform dragging.
0682 6656              autoTrack equ   dragCntl+1              Called while dragging.
0683 6656              newValue equ   autoTrack+1              Called when new value is set.
0684 6656              setParams equ   newValue+1              Called when min and max are set.
0685 6656              moveCntl equ   setParams+1              Move entire control.
0686 6656              recSize  equ   moveCntl+1               Return size of control's record.
0687 6656              ;
0688 6656              ;
0689 6656              ; --- Part codes for standard controls -----------------
0690 6656              ;
0691 6656              BUTT_PART equ   2
0692 6656              CHECK_PART equ   3
0693 6656              UP_PART  equ   5
0694 6656              DOWN_PART equ   6
0695 6656              UPP_PART equ   7
0696 6656              DOWNP_PART equ   8
0697 6656              GROW_PART equ   10
0698 6656              THUMB_PART equ   129
0699 6656              ;
0700 6656              CtrlToolNum equ   16
0701 6656              ;
0702 6656              ;
0703 6656              ; --- Control icon numbers -------------------------------
0704 6656              ;
0705 6656              UP_ARROW equ   8
0706 6656              DOWN_ARROW equ   10
0707 6656              LEFT_ARROW equ   12
0708 6656              RITE_ARROW equ   14
0709 6656              GROW_ICON equ   16
0710 6656              ;
0711 6656              TITLE_SPACE equ   4                     Number of pixels added to the width of
0712 6656              ;                                       a check box or radio button to get the
0713 6656              ;                                       starting X position of the title.
0714 6656
0715 6656
0716 6656              ;
0717 6656              ; *      copy  CHeader.asm
0718 6656              ; CHEADER.ASM                      D. Oliver
0719 6656              ;
0720 6656                       TITLE 'CHEADER.ASM'
0721 6656              ;
0722 6656              ; Structures and Equates for Cortland Control Manager.
0723 6656              ;
0724 6656              ;
0725 6656              ;+++++++++++++++++++++++++++++++++++++++++++++++
0726 6656              ;        Offsets for control structures.
0727 6656              ;
0728 6656              ;          Copyright 1986 Apple Computer, Inc.
0729 6656              ;                Written by Dan Oliver
0730 6656              ;          *** C O N F I D E N T I A L ***
0731 6656              ;
0732 6656              ;+++++++++++++++++++++++++++++++++++++++++++++++
0733 6656              ;
0734 6656              ;
0735 6656              ; +++ General control header +++
0736 6656              ;
0737 6656              ; --- CtrlFlag bit flags --------------------
0738 6656              ;
0739 6656              ;
0740 6656              ; --- Task numbers ----------------------------
0741 6656              ;
0742 6656              ; --- Control icon numbers -------------------------------
0743 6656              ;
0744 6656              ;                                       a check box or radio button to get the
0745 6656              ;                                       starting X position of the title.
0746 6656
0747 6656              ;
0748 6656              ; *      copy  DHeader.asm
0749 6656              ; DHeader.asm                           Jean-Charles Mourey
0750 6656
0751 6656                       TITLE 'Dialog Manager Equates'
0752 6656
0753 6656              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
0754 6656              ;
0755 6656              ; Structure and Equates for the Cortland Dialog Manager
0756 6656              ;
0757 6656              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
0758 6656
0759 6656
0760 6656              ;=======================================================
0761 6656              ;
0762 6656              ;   * * *  P U B L I C   E Q U A T E S  * * *
0763 6656              ;
0764 6656              ;=======================================================
0765 6656
0766 6656              ;
0767 6656              ; Dialog Manager Errors
0768 6656              ;
0769 6656              DLGERR   equ   $1500                    ; Error Base
0770 6656              DlgMgrAlreadyActive equ   1
0771 6656              DlgMgrNotActive equ   2
0772 6656              BadItemType equ   10                    ; error number is DLGERR+WhichError
0773 6656              NewItemFailed equ   11
0774 6656              ItemNotFound equ   12
0775 6656              NotModalDialog equ   13                 ; Dialog is not modal
0776 6656
0777 6656              ;
0778 6656              ; Item Types
0779 6656              ;
0780 6656              ButtonItem equ   10
0781 6656              CheckItem equ   11
0782 6656              RadioItem equ   12
0783 6656              ScrollBarItem equ   13
0784 6656              UserCtlItem equ   14
0785 6656              StatText equ   15
0786 6656              LongStatText equ   16
0787 6656              EditLine equ   17
0788 6656              IconItem equ   18
0789 6656              PicItem  equ   19
0790 6656              UserItem equ   20
0791 6656              UserCtlItem2 equ   21
0792 6656              LongStatText2 equ   22                  ;DAN H. (added new item)
0793 6656
0794 6656              MinItemType equ   10
0795 6656              MaxItemType equ   22                    ;DAN H. (to reflect added item)
0796 6656
0797 6656              ;
0798 6656              ; Part Code numbers for non-standard control item
0799 6656              ;
0800 6656              inStatText equ   9
0801 6656              inEditLine equ   11
0802 6656              inUserItem equ   12
0803 6656              inLongStatText equ   13
0804 6656              inIconItem equ   14
0805 6656              inLongStatText2 equ   15
0806 6656
0807 6656              ;
0808 6656              ; To disable an item for the dialog manager, add ItemDisable to the ItemType
0809 6656              ;
0810 6656              ItemDisable equ   $8000
0811 6656
0812 6656              ;
0813 6656              ; Icon structure
0814 6656              ;
0815 6656              ;   - An Icon Handle is a handle to an Icon Record
0816 6656              ;   - The definition of an Icon Record follows:
0817 6656              ;
0818 6656              iconRect equ   0                        ; width must be multiple of 8
0819 6656              iconImage equ   iconRect+RECTSIZE       ; pixel image for the icon
0820 6656
0821 6656              ;
0822 6656              ; Command Number for the Dialog Scroll Bar Action Procedure
0823 6656              ;
0824 6656              getinitview equ   1
0825 6656              getinittotal equ   2
0826 6656              getinitvalue equ   3
0827 6656              scrolllineup equ   4
0828 6656              scrolllinedown equ   5
0829 6656              scrollpageup equ   6
0830 6656              scrollpagedown equ   7
0831 6656              scrollthumb equ   8
0832 6656
0833 6656              ;
0834 6656              ; Item Template
0835 6656              ;
0836 6656              ititemID equ   0
0837 6656              ititemRect equ   ititemID+2
0838 6656              ititemType equ   ititemRect+8
0839 6656              ititemDescr equ   ititemType+2
0840 6656              ititemValue equ   ititemDescr+4
0841 6656              ititemFlag equ   ititemValue+2
0842 6656              ititemColor equ   ititemFlag+2
0843 6656
0844 6656              ;
0845 6656              ; Modal Dialog Template
0846 6656              ;
0847 6656              dtBoundsRect equ   0
0848 6656              dtVisible equ   dtBoundsRect+8
0849 6656              dtRefCon equ   dtVisible+2
0850 6656              dtitemlist equ   dtRefCon+4
0851 6656              ;
0852 6656              ; ditemlist is a list of pointers to item templates terminated by a nil pointer
0853 6656              ;
0854 6656
0855 6656              ;
0856 6656              ; Alert Template
0857 6656              ;
0858 6656              atBoundsRect equ   0
0859 6656              atalertID equ   atBoundsRect+8
0860 6656              atstage1 equ   atalertID+2
0861 6656              atstage2 equ   atstage1+1
0862 6656              atstage3 equ   atstage2+1
0863 6656              atstage4 equ   atstage3+1
0864 6656              atitemlist equ   atstage4+1
0865 6656
0866 6656              ;
0867 6656              ; Additional Parameter Block for a UserCtlItem2
0868 6656              ;
0869 6656              DefProcParm equ   0                     ; custom control defproc
0870 6656              TitleParm equ   4                       ; control title (CtrlData)
0871 6656              ParamLong equ   8                       ; equivalent to Param1, Param2
0872 6656
0873 6656
0874 6656              ;=======================================================
0875 6656              ;
0876 6656              ;   * * *  P R I V A T E   E Q U A T E S  * * *
0877 6656              ;
0878 6656              ;=======================================================
0879 6656
0880 6656              ;
0881 6656              ; Dialog Record:
0882 6656              ;
0883 6656              dwind    equ   0                        ; dialog window
0884 6656              dlgtype  equ   dwind+WINDSIZE           ; Modal, Modeless,...
0885 6656              edittextID equ   dlgtype+2              ; editText currently being edited
0886 6656              defbutID equ   edittextID+2             ; default button
0887 6656              DLGSIZE  equ   defbutID+2               ; size of dialog record
0888 6656
0889 6656              ;
0890 6656              ; Possible Dialog Types:
0891 6656              ;
0892 6656              No_Type  equ   0
0893 6656              Modal_Type equ   1
0894 6656              Modeless_Type equ   2
0895 6656
0896 6656              ;
0897 6656              ; Standard Windows for Dialogs
0898 6656              ;
0899 6656              DocProcID equ   0                       ; standard document window
0900 6656              DlgProcID equ   1                       ; dialog (modal-type) window
0901 6656
0902 6656              ;
0903 6656              ; Dialog Manager Tool Number
0904 6656              ;
0905 6656              DLGTOOL  equ   $15                      ; Dialog Manager is Tool #21
0906 6656
0907 6656              ;
0908 6656              ; Command Number for cut/copy/paste/delete commands (in dscrap.asm)
0909 6656              ;
0910 6656              cutcmd   equ   0
0911 6656              copycmd  equ   1
0912 6656              pastecmd equ   2
0913 6656              deletecmd equ   3
0914 6656
0915 6656              ;
0916 6656              ; Icon IDs for alerts
0917 6656              ;
0918 6656              stopIcon equ   1
0919 6656              noteIcon equ   2
0920 6656              cautionIcon equ   3
0921 6656
0922 6656              ;
0923 6656              ; Icon Size in 320 and 640 mode
0924 6656              ;
0925 6656              Icon320Width equ   24
0926 6656              Icon640Width equ   40
0927 6656              IconHeight equ   18
0928 6656
0929 6656              ;
0930 6656              ; ItemStructure = Control Structure with RefCon = (ID, Type)
0931 6656              ;
0932 6656              iitemcontrol equ   0
0933 6656              iitemid  equ   CtrlRefCon
0934 6656              iitemtype equ   iitemid+2
0935 6656              STDCTRLSIZE equ   CtrlColor+4           ; Std Ctrl Size (without add. datas)
0936 6656
0937 6656              ;
0938 6656              ; Additional datas for StatText:
0939 6656              ;
0940 6656              iitemfont equ   iitemcontrol+STDCTRLSIZE
0941 6656              iitemface equ   iitemfont+4
0942 6656              StatTextSIZE equ   iitemface+2
0943 6656
0944 6656              LongStatTextSIZE equ   StatTextSIZE
0945 6656
0946 6656              ;
0947 6656              ; Additional datas for EditLine:
0948 6656              ;
0949 6656              EditLineSIZE equ   STDCTRLSIZE          ; no additional datas
0950 6656
0951 6656              ;
0952 6656              ; Additional datas for ScrollBar (in addition to the standard add. datas):
0953 6656              ;
0954 6656              iScrollBarDef equ   PageRegion+RECTSIZE ; scroll bar item defproc pointer
0955 6656              ScrollBarSIZE equ   iScrollBarDef+4
0956 6656
0957 6656              ;
0958 6656              ; Additional datas for UserItem:
0959 6656              ;
0960 6656              UserItemSIZE equ   STDCTRLSIZE
0961 6656
0962 6656              ;
0963 6656              ; Additional datas for IconItem:
0964 6656              ;
0965 6656              IconItemSIZE equ   STDCTRLSIZE
0966 6656
0967 6656              ;
0968 6656              ; Dialog Signature
0969 6656              ;
0970 6656              DlgSig   equ   $2348
0971 6656
0972 6656              ;
0973 6656              ; Zero Page (shared with Control Manager)
0974 6656              ;
0975 6656              Signature equ   128                     ; contains DlgSig if Dlg Mgr active
0976 6656              mmgrID   equ   Signature+2              ; ID to use with the Memory Manager
0977 6656              DialogFont equ   mmgrID+2               ; handle to dialog font or 0 for system
0978 6656              AlertSoundProc equ   DialogFont+4       ; pointer to custom sound procedure
0979 6656              AlertStage equ   AlertSoundProc+4       ; current alert stage
0980 6656              LastAlertID equ   AlertStage+2          ; ID of last called alert
0981 6656              ParamString0 equ   LastAlertID+2        ; Param strings for ^0 to ^3
0982 6656              ParamString1 equ   ParamString0+4
0983 6656              ParamString2 equ   ParamString1+4
0984 6656              ParamString3 equ   ParamString2+4
0985 6656              PartCodeHit equ   ParamString3+4        ; Part Code Hit
0986 6656              MemHandle equ   PartCodeHit+2
0987 6656              WindowPointer equ   MemHandle+4
0988 6656              HandStruct equ   WindowPointer+4
0989 6656              EndZeroPage equ   HandStruct+4
0990 6656
0991 6656
0992 6656              **********************************************************************
0993 6656              *
0994 6656              * Forward References
0995 6656              *
0996 6656              **********************************************************************
0997 6656                       ENTRY DialogBootInit
0998 6656                       ENTRY DialogStartup
0999 6656                       ENTRY DialogShutDown
1000 6656                       ENTRY DialogVersion
1001 6656                       ENTRY DialogReset
1002 6656                       ENTRY DialogStatus
1003 6656                       ENTRY SetDAFont
1004 6656                       ENTRY ErrorSound
1005 6656                       ENTRY NewModalDialog
1006 6656                       ENTRY NewModelessDialog
1007 6656                       ENTRY CloseDialog
1008 6656                       ENTRY NewDItem
1009 6656                       ENTRY RemoveItem
1010 6656                       ENTRY ModalDialog
1011 6656                       ENTRY IsDialogEvent
1012 6656                       ENTRY DialogSelect
1013 6656                       ENTRY DlgCut
1014 6656                       ENTRY DlgCopy
1015 6656                       ENTRY DlgPaste
1016 6656                       ENTRY DlgDelete
1017 6656                       ENTRY DrawDialog
1018 6656                       ENTRY Alert
1019 6656                       ENTRY StopAlert
1020 6656                       ENTRY NoteAlert
1021 6656                       ENTRY CautionAlert
1022 6656                       ENTRY ParamText
1023 6656                       ENTRY SetDAFont
1024 6656                       ENTRY SetItemToControl
1025 6656                       ENTRY GetControlDItem
1026 6656                       ENTRY SetIText
1027 6656                       ENTRY HideDItem
1028 6656                       ENTRY ShowDItem
1029 6656                       ENTRY FindDItem
1030 6656                       ENTRY UpdateDialog
1031 6656                       ENTRY SetItemType
1032 6656                       ENTRY GetItemBox
1033 6656                       ENTRY SetItemBox
1034 6656                       ENTRY GetFirstItem
1035 6656                       ENTRY GetNextItem
1036 6656                       ENTRY ModalDialog2
1037 6656                       ENTRY RESERVED
1038 6656                       ENTRY GetItemValue
1039 6656                       ENTRY SetItemValue
1040 6656                       ENTRY RESERVED
1041 6656                       ENTRY RESERVED
1042 6656                       ENTRY GetNewModalDialog
1043 6656                       ENTRY GetNewDItem
1044 6656                       ENTRY GetAlertStage
1045 6656                       ENTRY ResetAlertStage
1046 6656                       ENTRY DefaultFilter
1047 6656                       ENTRY GetDefButton
1048 6656                       ENTRY DisableDItem
1049 6656                       ENTRY EnableDItem
1050 6656                       ENTRY GetIText
1051 6656                       ENTRY SelIText
1052 6656                       ENTRY SetDefButton
1053 6656                       ENTRY StdFilterProc
1054 6656                       ENTRY GetItemType
1055 6656
1056 6656
1057 6656                       ENTRY InsertParamString
1058 6656                       ENTRY disposelocals
1059 6656                       ENTRY DlgScrap
1060 6656                       ENTRY dlg2handle
1061 6656                       ENTRY scroll_action
1062 6656                       ENTRY BlinkCaret
1063 6656                       ENTRY WindowIsDialog
1064 6656                       ENTRY EnableDisableItem
1065 6656                       ENTRY ShowHideDItem
1066 6656                       ENTRY quit10
1067 6656                       ENTRY quit8
1068 6656                       ENTRY FindNextEditLine
1069 6656                       ENTRY quit6
1070 6656                       ENTRY EmptyString
1071 6656                       ENTRY long_call
1072 6656                       ENTRY StdSoundProc
1073 6656                       ENTRY GeneralAlert
1074 6656                       ENTRY DialogFromTemplate
1075 6656                       ENTRY quit4
1076 6656                       ENTRY EmptyRect
1077 6656                       ENTRY getWORDfromZP
1078 6656                       ENTRY storeLONGinZP
1079 6656                       ENTRY quit2
1080 6656
1081 6656                       ENTRY NormalTextColor
1082 6656
1083 6656
1084 6656
1085 6656              ;====================================
1086 6656              ;        Install Dialog Manager
1087 6656              ;====================================
1088 6656
1089 6656                       EXPORT DialogCallTable 
1090 6656              DialogCallTable PROC 
1091 6656
1092 6656                       longa on
1093 6656                       longi on
1094 6656
1095 6656
1096 6656                       ENTRY FPT
1097 6656 3B 00 00 00  FPT      DC L:(ENDFPT-FPT)/4
1098 665A 41 67 FC 00           DC L:DialogBootInit-1 1
1099 665E 46 67 FC 00           DC L:DialogStartup-1 2
1100 6662 E4 67 FC 00           DC L:DialogShutDown-1 3
1101 6666 DA 67 FC 00           DC L:DialogVersion-1 4
1102 666A 16 68 FC 00           DC L:DialogReset-1             5
1103 666E 27 68 FC 00           DC L:DialogStatus-1            6
1104 6672 CE 67 FC 00           DC L:ErrorSound-1              7      ; should be RESERVED
1105 6676 D4 67 FC 00           DC L:SetDAFont-1               8      ; should be RESERVED
1106 667A CE 67 FC 00           DC L:ErrorSound-1              9
1107 667E FB 69 FC 00           DC L:NewModalDialog-1          10
1108 6682 67 6A FC 00           DC L:NewModelessDialog-1       11
1109 6686 CA 6A FC 00           DC L:CloseDialog-1             12
1110 668A 60 72 FC 00           DC L:NewDItem-1                13
1111 668E 8E 74 FC 00           DC L:RemoveItem-1              14
1112 6692 54 7D FC 00           DC L:ModalDialog-1             15
1113 6696 C7 83 FC 00           DC L:IsDialogEvent-1           16
1114 669A 81 84 FC 00           DC L:DialogSelect-1            17
1115 669E C8 88 FC 00           DC L:DlgCut-1                  18
1116 66A2 CD 88 FC 00           DC L:DlgCopy-1                 19
1117 66A6 D2 88 FC 00           DC L:DlgPaste-1                20
1118 66AA D7 88 FC 00           DC L:DlgDelete-1               21
1119 66AE 1A 88 FC 00           DC L:DrawDialog-1              22
1120 66B2 AE 70 FC 00           DC L:Alert-1                   23
1121 66B6 9F 70 FC 00           DC L:StopAlert-1               24
1122 66BA A4 70 FC 00           DC L:NoteAlert-1               25
1123 66BE A9 70 FC 00           DC L:CautionAlert-1            26
1124 66C2 C4 7C FC 00           DC L:ParamText-1               27
1125 66C6 D4 67 FC 00           DC L:SetDAFont-1               28
1126 66CA 62 74 FC 00           DC L:SetItemToControl-1        29
1127 66CE A0 75 FC 00           DC L:GetControlDItem-1         30
1128 66D2 30 7A FC 00           DC L:GetIText-1                31
1129 66D6 FC 7A FC 00           DC L:SetIText-1                32
1130 66DA B0 7B FC 00           DC L:SelIText-1                33
1131 66DE 4D 79 FC 00           DC L:HideDItem-1               34
1132 66E2 52 79 FC 00           DC L:ShowDItem-1               35
1133 66E6 93 79 FC 00           DC L:FindDItem-1               36
1134 66EA 36 88 FC 00           DC L:UpdateDialog-1            37
1135 66EE 7E 76 FC 00           DC L:GetItemType-1             38
1136 66F2 84 76 FC 00           DC L:SetItemType-1             39
1137 66F6 8A 76 FC 00           DC L:GetItemBox-1              40
1138 66FA EA 76 FC 00           DC L:SetItemBox-1              41
1139 66FE 64 77 FC 00           DC L:GetFirstItem-1            42
1140 6702 A5 77 FC 00           DC L:GetNextItem-1             43
1141 6706 14 7D FC 00           DC L:ModalDialog2-1            44
1142 670A 6A 93 FC 00           DC L:RESERVED-1                45
1143 670E 07 78 FC 00           DC L:GetItemValue-1            46
1144 6712 3D 78 FC 00           DC L:SetItemValue-1            47
1145 6716 6A 93 FC 00           DC L:RESERVED-1                48
1146 671A 6A 93 FC 00           DC L:RESERVED-1                49
1147 671E E6 6A FC 00           DC L:GetNewModalDialog-1       50
1148 6722 47 75 FC 00           DC L:GetNewDItem-1             51
1149 6726 1C 72 FC 00           DC L:GetAlertStage-1           52
1150 672A 22 72 FC 00           DC L:ResetAlertStage-1         53
1151 672E 89 83 FC 00           DC L:DefaultFilter-1           54
1152 6732 77 78 FC 00           DC L:GetDefButton-1            55
1153 6736 90 78 FC 00           DC L:SetDefButton-1            56
1154 673A D9 79 FC 00           DC L:DisableDItem-1            57
1155 673E DE 79 FC 00           DC L:EnableDItem-1             58
1156 6742              ENDFPT    
1157 6742
1158 6742                       ENDP 
1159 6742
1160 6742              ;
1161 6742              ;            copy  DlgInit.asm
1162 6742              ; DlgInit.asm                           Jean-Charles Mourey
1163 6742
1164 6742                       TITLE 'Dialog Manager Initialization Routines'
1165 6742
1166 6742
1167 6742              ;______________________________________________________________________________
1168 6742              ;
1169 6742              ;        DialogBootInit
1170 6742              ;
1171 6742              ;       input: none
1172 6742              ;
1173 6742              ;      output: none
1174 6742              ;______________________________________________________________________________
1175 6742
1176 6742                       ENTRY DialogBootInit
1177 6742              DialogBootInit PROC 
1178 6742
1179 6742 A9 00 00              lda   #0
1180 6745 18                    clc   
1181 6746 6B                    rtl   
1182 6747                       ENDP 
1183 6747
1184 6747
1185 6747              ;______________________________________________________________________________
1186 6747              ;
1187 6747              ;        DialogStartup
1188 6747              ;
1189 6747              ;       input: ProgramID:WORD - ID to use with the Memory Manager
1190 6747              ;
1191 6747              ;      output: none
1192 6747              ;
1193 6747              ; Change History
1194 6747              ;
1195 6747              ; 4 Mar 88          Steven Glass
1196 6747              ;
1197 6747              ; Modified code to use the WAP entry for this tool.  First, we check the
1198 6747              ; WAP to see if we are already active.  If we are already active, then we
1199 6747              ; return a new error code.  If we are not active, we get the control
1200 6747              ; manager's direct page and save it in our WAP.
1201 6747              ;
1202 6747              ; 19 May 89         Steven Glass
1203 6747              ;
1204 6747              ; Changed it again so that we don't check to see if we were already active.
1205 6747              ; The march 4 check that is in ROM, doesn't work.  Anyway, we found that 
1206 6747              ; applications were dieing if an error was returned anyway.
1207 6747              ;
1208 6747              ;______________________________________________________________________________
1209 6747
1210 6747                       ENTRY DialogStartup
1211 6747
1212 6747              DialogStartup PROC Export 
1213 6747
1214 6747 AA                    tax   
1215 6748 3B 38 E9 00           tlink 2 
1216 6751
1217 6751              ProgramID equ   input
1218 6751
1219 6751              ;
1220 6751              ; Save ProgramID on stack
1221 6751              ;
1222 6751 A5 06 48              PushWord ProgramID 
1223 6754 E0 00 00              cpx   #0
1224 6757 F0 09                 beq   NotYetActive
1225 6759 A9 01 15              lda   #DLGERR+DlgMgrAlreadyActive
1226 675C A2 00 00              ldx   #0
1227 675F 4C 60 89              jmp   quit2
1228 6762
1229 6762              NotYetActive  
1230 6762              ;
1231 6762              ; Get Dialog Manager Zero Page
1232 6762              ;
1233 6762 48                    pha   
1234 6763 A2 10 1F 22           _GetCtlDPage 
1235 676A 2B                    pld   
1236 676B
1237 676B              ;
1238 676B              ; Set Dialog Mgr's WAP
1239 676B              ;
1240 676B F4 00 00              PushWord #0 
1241 676E F4 15 00              PushWord #DlgTool 
1242 6771 F4 00 00              PushWord #0 
1243 6774 0B                    phd   
1244 6775 A2 01 0D 22           _SetWAP 
1245 677C
1246 677C              ;-----------------------------------------------------------
1247 677C              ;
1248 677C              ; Now, using our part of the zero page, lets 
1249 677C              ; init our stuff.
1250 677C              ;
1251 677C 68                    pla                            ; save memory manager ID to use
1252 677D 85 82                 sta   <mmgrID
1253 677F
1254 677F A9 48 23              lda   #DlgSig                  ; Set signature
1255 6782 85 80                 sta   <Signature
1256 6784
1257 6784 A9 00 00 A2           zero #EndZeroPage-DialogFont,<DialogFont  ; clear all other parms
1258 6790
1259 6790 48                    pha                            ; long space for result
1260 6791 48                    pha   
1261 6792 F4 00 00              pea   0                        ; get size of memory 
1262 6795 F4 62 00              pushword #98 
1263 6798 D4 82                 pei   mmgrID
1264 679A F4 00 00              pushword #0                    ; no restrictions
1265 679D 48                    pha   
1266 679E 48                    pha   
1267 679F A2 02 09 22           _NewHandle 
1268 67A6
1269 67A6 68                    pla   
1270 67A7 85 A2                 sta   <MemHandle
1271 67A9 68                    pla   
1272 67AA 85 A4                 sta   <MemHandle+2
1273 67AC
1274 67AC A7 A2                 lda   [<MemHandle]
1275 67AE 85 A6                 sta   <WindowPointer
1276 67B0 A0 02 00              ldy   #2
1277 67B3 B7 A2                 lda   [<MemHandle],y
1278 67B5 85 A8                 sta   <WindowPointer+2
1279 67B7
1280 67B7
1281 67B7 A5 A6                 lda   <WindowPointer
1282 67B9 18                    clc   
1283 67BA 69 4E 00              adc   #78
1284 67BD 85 AA                 sta   <HandStruct
1285 67BF A5 A8                 lda   <WindowPointer+2
1286 67C1 69 00 00              adc   #0
1287 67C4 85 AC                 sta   <HandStruct+2
1288 67C6
1289 67C6 A9 00 00              lda   #0000
1290 67C9
1291 67C9 A2 00 00              ldx   #0                       ; accumulator is already 0
1292 67CC 4C 60 89              jmp   quit2
1293 67CF
1294 67CF                       ENDP 
1295 67CF
1296 67CF
1297 67CF              ;_____________________________________________________________________________
1298 67CF              ;
1299 67CF              ;        ErrorSound
1300 67CF              ;
1301 67CF              ;       input: soundProc:LONG - pointer to a sound procedure
1302 67CF              ;
1303 67CF              ;      output: none
1304 67CF              ;______________________________________________________________________________
1305 67CF
1306 67CF                       ENTRY ErrorSound
1307 67CF              ErrorSound PROC 
1308 67CF
1309 67CF A0 88 00              ldy   #AlertSoundProc
1310 67D2 4C F9 89              jmp   storeLONGinZP
1311 67D5
1312 67D5                       ENDP 
1313 67D5
1314 67D5
1315 67D5              ;______________________________________________________________________________
1316 67D5              ;
1317 67D5              ;        SetDAFont
1318 67D5              ;
1319 67D5              ;       input: fontHandle:LONG - handle of font
1320 67D5              ;
1321 67D5              ;      output: none
1322 67D5              ;______________________________________________________________________________
1323 67D5
1324 67D5                       ENTRY SetDAFont
1325 67D5              SetDAFont PROC 
1326 67D5
1327 67D5 A0 84 00              ldy   #DialogFont
1328 67D8 4C F9 89              jmp   storeLONGinZP
1329 67DB
1330 67DB                       ENDP 
1331 67DB
1332 67DB              ;______________________________________________________________________________
1333 67DB              ;
1334 67DB              ;        DialogVersion
1335 67DB              ;
1336 67DB              ;       input: none
1337 67DB              ;
1338 67DB              ;      output: dVersion:WORD - Dialog Manager's version number
1339 67DB              ;______________________________________________________________________________
1340 67DB
1341 67DB                       ENTRY DialogVersion
1342 67DB              DialogVersion PROC 
1343 67DB
1344 67DB              dVersion equ   7                        ; stack relative
1345 67DB
1346 67DB A9 00 03              lda   #TheDialogVersionNum
1347 67DE 83 07                 sta   dVersion,s
1348 67E0
1349 67E0 A9 00 00              lda   #0
1350 67E3 18                    clc   
1351 67E4 6B                    rtl   
1352 67E5                       ENDP 
1353 67E5
1354 67E5
1355 67E5              ;______________________________________________________________________________
1356 67E5              ;
1357 67E5              ;        DialogShutDown
1358 67E5              ;
1359 67E5              ;       input: none
1360 67E5              ;
1361 67E5              ;      output: none
1362 67E5              ;
1363 67E5              ; Change History
1364 67E5              ;
1365 67E5              ; 4 March 88        Steven Glass
1366 67E5              ;
1367 67E5              ; Modified to use the WAP instead of calling control manager.  Sets WAP to
1368 67E5              ; zero when complete.
1369 67E5              ;
1370 67E5              ;______________________________________________________________________________
1371 67E5
1372 67E5                       ENTRY DialogShutDown
1373 67E5              DialogShutDown PROC 
1374 67E5
1375 67E5 C9 00 00              cmp   #0
1376 67E8 D0 05                 bne   YesWeAreActive
1377 67EA
1378 67EA A9 02 15              lda   #DlgErr+DlgMgrNotActive
1379 67ED 38                    sec   
1380 67EE 6B                    rtl   
1381 67EF
1382 67EF
1383 67EF              YesWeAreActive  
1384 67EF 0B                    phd   
1385 67F0 5B                    tcd   
1386 67F1
1387 67F1              ;
1388 67F1              ; Clear signature to mark the dialog manager inactive
1389 67F1              ;
1390 67F1 64 80                 stz   <Signature
1391 67F3
1392 67F3 D4 A4                 pei   <MemHandle+2
1393 67F5 D4 A2                 pei   <MemHandle
1394 67F7 A2 02 10 22           _DisposeHandle 
1395 67FE
1396 67FE F4 00 00              PushWord #0 
1397 6801 F4 15 00              PushWord #DlgTool 
1398 6804 F4 00 00 F4           PushLong #0 
1399 680A A2 01 0D 22           _SetWap 
1400 6811
1401 6811 2B                    pld   
1402 6812
1403 6812 A9 00 00              lda   #0
1404 6815 18                    clc   
1405 6816 6B                    rtl   
1406 6817                       ENDP 
1407 6817
1408 6817
1409 6817              ;______________________________________________________________________________
1410 6817              ;
1411 6817              ;        DialogReset
1412 6817              ;
1413 6817              ;       input: none
1414 6817              ;
1415 6817              ;      output: none
1416 6817              ;
1417 6817              ; Change History
1418 6817              ;
1419 6817              ; 4 March 88        Steven Glass
1420 6817              ;
1421 6817              ; Changed to check first to see if we are active.  If active, we shut down.
1422 6817              ; if not active, we do nothing.
1423 6817              ;
1424 6817              ;______________________________________________________________________________
1425 6817
1426 6817                       ENTRY DialogReset
1427 6817              DialogReset PROC 
1428 6817
1429 6817              ;
1430 6817              ; Check WAP.  Are we active?
1431 6817              ;
1432 6817 C9 00 00              cmp   #0
1433 681A F0 07                 beq   DoNothing                ; no
1434 681C
1435 681C A2 15 03 22           _DialogShutdown                ; yes
1436 6823
1437 6823 A9 00 00     DoNothing lda   #0
1438 6826 18                    clc   
1439 6827 6B                    rtl   
1440 6828                       ENDP 
1441 6828
1442 6828
1443 6828              ;_____________________________________________________________________________
1444 6828              ;
1445 6828              ;        DialogStatus
1446 6828              ;
1447 6828              ;       input: none
1448 6828              ;
1449 6828              ;      output: status:WORD - TRUE if Dialog Manager is initialized
1450 6828              ;______________________________________________________________________________
1451 6828
1452 6828                       ENTRY DialogStatus
1453 6828              DialogStatus PROC 
1454 6828                       DefineStack 
1455 6828              RTL1     block 3 
1456 6828              RTL2     block 3 
1457 6828              ActiveResult word 
1458 6828
1459 6828 C9 00 00              cmp   #0
1460 682B D0 07                 bne   AmActive
1461 682D                       EXPORT FinishActive 
1462 682D              FinishActive  
1463 682D 83 07                 sta   ActiveResult,s
1464 682F A9 00 00              lda   #0
1465 6832 18                    clc   
1466 6833 6B                    rtl   
1467 6834
1468 6834 A9 FF FF     AmActive lda   #True
1469 6837 80 F4                 bra   FinishActive
1470 6839
1471 6839
1472 6839
1473 6839              ;	ldy	#Signature
1474 6839              ;	jmp	getWORDfromZP
1475 6839
1476 6839                       ENDP 
1477 6839              ;            copy  NewDlg.asm
1478 6839              ; NewDlg.asm                            Jean-Charles Mourey
1479 6839
1480 6839                       TITLE 'New Dialog Routines'
1481 6839
1482 6839
1483 6839
1484 6839              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
1485 6839              ;
1486 6839              ;        NewDialog
1487 6839              ;
1488 6839              ;       input: DialogVariable:LONG - pointer to variable to store the dialog in
1489 6839              ;              dBoundsRect:LONG - size and position of dialog's content region
1490 6839              ;              dTitle:LONG - pointer to string for dialog's title
1491 6839              ;              dDefProc:LONG - 0 for document, 1 for dialog, or procptr.
1492 6839              ;              dBehind:LONG - pointer to window the dialog should be behind.
1493 6839              ;              dFlag:WORD - bit vector describing the dialog's frame
1494 6839              ;              dRefCon:LONG - any value you'd like to associate with the window.
1495 6839              ;              dFullSize:LONG - pointer to RECT to be used as content's zoomed.
1496 6839              ;
1497 6839              ;      output: none
1498 6839              ;
1499 6839              ;    function: Creates a new dialog. DialogVariable contains 0 if error.
1500 6839              ;
1501 6839              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
1502 6839
1503 6839                       ENTRY NewDialog
1504 6839              NewDialog PROC 
1505 6839
1506 6839              DlgRecHdl equ   0
1507 6839              DlgRecPtr equ   DlgRecHdl+4
1508 6839              theDialog equ   DlgRecPtr+4
1509 6839              Globals  equ   theDialog+4
1510 6839              TheMemHandle equ   Globals+4
1511 6839              WindParmPtr equ   TheMemHandle+4
1512 6839              SizeLocals equ   WindParmPtr+4
1513 6839
1514 6839 3B 38 E9 18           link 30,SizeLocals 
1515 6842
1516 6842              dFullSize equ   input
1517 6842              dRefCon  equ   dFullSize+4
1518 6842              dFlag    equ   dRefCon+4
1519 6842              dBehind  equ   dFlag+2
1520 6842              dDefProc equ   dBehind+4
1521 6842              dTitle   equ   dDefProc+4
1522 6842              dBoundsRect equ   dTitle+4
1523 6842              DialogVariable equ   dBoundsRect+4
1524 6842
1525 6842              ;
1526 6842              ; Create a new window for the Dialog
1527 6842              ;
1528 6842
1529 6842              ;
1530 6842              ; Get Memory Manager ID to use
1531 6842              ;
1532 6842 48                    pha   
1533 6843 A2 10 1F 22           _GetCtlDPage 
1534 684A 68                    pla   
1535 684B 85 0C                 sta   <Globals
1536 684D 64 0E                 stz   <Globals+2
1537 684F
1538 684F
1539 684F A0 A2 00              ldy   #MemHandle               ; get handle to memory obtained at startup time
1540 6852 B7 0C                 lda   [<Globals],y
1541 6854 85 10                 sta   <TheMemHandle
1542 6856 C8                    iny   
1543 6857 C8                    iny   
1544 6858 B7 0C                 lda   [<Globals],y
1545 685A 85 12                 sta   <TheMemHandle+2
1546 685C
1547 685C A0 04 00              ldy   #4                       ; lock down the handle
1548 685F B7 10                 lda   [<TheMemHandle],y
1549 6861 09 00 80              ora   #$8000
1550 6864 97 10                 sta   [<TheMemHandle],y
1551 6866 88                    dey   
1552 6867 88                    dey   
1553 6868 B7 10                 lda   [<TheMemHandle],y        ; dereference handle
1554 686A 85 16                 sta   <WindParmPtr+2
1555 686C A7 10                 lda   [<TheMemHandle]
1556 686E 85 14                 sta   <WindParmPtr
1557 6870
1558 6870 A9 00 00 A2           zero #78,[<WindParmPtr]        ; zero out space reserved for window parameters
1559 6881
1560 6881 A9 4E 00              lda   #78                      ; store total size of window parameters in templ_len
1561 6884 87 14                 sta   [<WindParmPtr]
1562 6886              ;
1563 6886              ; Allocate space for the DialogRecord
1564 6886              ;
1565 6886 48                    pha                            ; space for handle
1566 6887 48                    pha   
1567 6888 F4 00 00 F4           pushlong #DLGSIZE 
1568 688E A0 82 00              ldy   #mmgrID                  ; Memory Manager ID
1569 6891 B7 0C                 lda   [<Globals],y
1570 6893 48                    pha   
1571 6894 F4 10 40              pushword #Attr_Fixed+Attr_NoCross 
1572 6897 48                    pha                            ; no use for a Location paramter
1573 6898 48                    pha   
1574 6899 A2 02 09 22           _NewHandle 
1575 68A0 90 03 82 47           Check_Error NotAllocated 
1576 68A5 68 85 00 68           pulllong <DlgRecHdl 
1577 68AB
1578 68AB              ;
1579 68AB              ; Zero Dialog Record
1580 68AB              ;
1581 68AB A7 00 85 04           movelong [<DlgRecHdl],0,<DlgRecPtr 
1582 68B6 A9 00 00 A2           zero #DLGSIZE,[<DlgRecPtr]
1583 68C7
1584 68C7              ;
1585 68C7              ; Store the input parameters in wind_param for NewWindow
1586 68C7              ;
1587 68C7
1588 68C7
1589 68C7              ;       movelong <DlgRecPtr,>wind_rec
1590 68C7 A5 04                 lda   <DlgRecPtr
1591 68C9 A0 4A 00              ldy   #wind_rec
1592 68CC 97 14                 sta   [<WindParmPtr],y
1593 68CE A5 06                 lda   <DlgRecPtr+2
1594 68D0 C8                    iny   
1595 68D1 C8                    iny   
1596 68D2 97 14                 sta   [<WindParmPtr],y
1597 68D4
1598 68D4              ;       movelong [<dBoundsRect],0,>wind_pos
1599 68D4 A7 31                 lda   [<dBoundsRect]
1600 68D6 A0 3E 00              ldy   #wind_pos
1601 68D9 97 14                 sta   [<WindParmPtr],y
1602 68DB A0 02 00              ldy   #2
1603 68DE B7 31                 lda   [<dBoundsRect],y
1604 68E0 A0 40 00              ldy   #wind_pos+2
1605 68E3 97 14                 sta   [<WindParmPtr],y
1606 68E5
1607 68E5
1608 68E5              ;       movelong [<dBoundsRect],4,>wind_pos+4
1609 68E5 A0 04 00              ldy   #4
1610 68E8 B7 31                 lda   [<dBoundsRect],y
1611 68EA A0 42 00              ldy   #wind_pos+4
1612 68ED 97 14                 sta   [<WindParmPtr],y
1613 68EF A0 06 00              ldy   #6
1614 68F2 B7 31                 lda   [<dBoundsRect],y
1615 68F4 A0 44 00              ldy   #wind_pos+6
1616 68F7 97 14                 sta   [<WindParmPtr],y
1617 68F9
1618 68F9
1619 68F9              ;       movelong <dTitle,>wind_title
1620 68F9 A5 2D                 lda   <dTitle
1621 68FB A0 04 00              ldy   #wind_title
1622 68FE 97 14                 sta   [<WindParmPtr],y
1623 6900 A5 2F                 lda   <dTitle+2
1624 6902 C8                    iny   
1625 6903 C8                    iny   
1626 6904 97 14                 sta   [<WindParmPtr],y
1627 6906
1628 6906
1629 6906              ;       movelong <dBehind,>wind_plane
1630 6906 A5 25                 lda   <dBehind
1631 6908 A0 46 00              ldy   #wind_plane
1632 690B 97 14                 sta   [<WindParmPtr],y
1633 690D A5 27                 lda   <dBehind+2
1634 690F C8                    iny   
1635 6910 C8                    iny   
1636 6911 97 14                 sta   [<WindParmPtr],y
1637 6913
1638 6913
1639 6913 A5 23                 lda   <dFlag                   ; I allocated the space
1640 6915 09 04 00              ora   #F_ALLOCATE
1641 6918 A0 02 00              ldy   #wind_frame
1642 691B 97 14                 sta   [<WindParmPtr],y
1643 691D
1644 691D              ;       movelong <dRefCon,>wind_ref
1645 691D A5 1F                 lda   <dRefCon
1646 691F A0 08 00              ldy   #wind_ref
1647 6922 97 14                 sta   [<WindParmPtr],y
1648 6924 A5 21                 lda   <dRefCon+2
1649 6926 C8                    iny   
1650 6927 C8                    iny   
1651 6928 97 14                 sta   [<WindParmPtr],y
1652 692A
1653 692A
1654 692A              ;       movelong [<dFullSize],0,>wind_full
1655 692A A7 1B                 lda   [<dFullSize]
1656 692C A0 0C 00              ldy   #wind_full
1657 692F 97 14                 sta   [<WindParmPtr],y
1658 6931 A0 02 00              ldy   #2
1659 6934 B7 1B                 lda   [<dFullSize],y
1660 6936 A0 0E 00              ldy   #wind_full+2
1661 6939 97 14                 sta   [<WindParmPtr],y
1662 693B
1663 693B
1664 693B              ;       movelong [<dFullSize],4,>wind_full+4
1665 693B A0 04 00              ldy   #4
1666 693E B7 1B                 lda   [<dFullSize],y
1667 6940 A0 10 00              ldy   #wind_full+4
1668 6943 97 14                 sta   [<WindParmPtr],y
1669 6945 A0 06 00              ldy   #6
1670 6948 B7 1B                 lda   [<dFullSize],y
1671 694A A0 12 00              ldy   #wind_full+6
1672 694D 97 14                 sta   [<WindParmPtr],y
1673 694F
1674 694F
1675 694F              ;       movelong <dDefProc,>wind_def
1676 694F A5 29                 lda   <dDefProc
1677 6951 A0 32 00              ldy   #wind_def
1678 6954 97 14                 sta   [<WindParmPtr],y
1679 6956 A5 2B                 lda   <dDefProc+2
1680 6958 C8                    iny   
1681 6959 C8                    iny   
1682 695A 97 14                 sta   [<WindParmPtr],y
1683 695C
1684 695C
1685 695C              ;
1686 695C              ; Call NewWindow
1687 695C              ;
1688 695C 48                    pha                            ; space for window ptr
1689 695D 48                    pha   
1690 695E A5 16                 lda   <WindParmPtr+2
1691 6960 48                    pha   
1692 6961 A5 14                 lda   <WindParmPtr
1693 6963 48                    pha   
1694 6964 A2 0E 09 22           _NewWindow 
1695 696B 90 03 82 7C           Check_Error NotAllocated 
1696 6970
1697 6970 68                    pla                            ; store result in local var
1698 6971 85 08                 sta   <theDialog               ; theDialog and in input parameter
1699 6973 87 35                 sta   [<DialogVariable]        ; DialogVariable
1700 6975 68                    pla   
1701 6976 85 0A                 sta   <theDialog+2
1702 6978 A0 02 00              ldy   #2
1703 697B 97 35                 sta   [<DialogVariable],y
1704 697D
1705 697D              ;
1706 697D              ; Initialize extra fields in dialog record
1707 697D              ;
1708 697D A9 00 00              lda   #0                       ; ID of EditLine currently being edited
1709 6980 A0 14 01              ldy   #edittextID-wport
1710 6983 97 08                 sta   [<theDialog],y
1711 6985
1712 6985 A9 01 00              lda   #1                       ; default Button ID
1713 6988 A0 16 01              ldy   #defbutID-wport
1714 698B 97 08                 sta   [<theDialog],y
1715 698D
1716 698D              ;
1717 698D              ; Look if dialog font is system font or custom font
1718 698D              ;
1719 698D A0 84 00              ldy   #DialogFont              ; if DialogFont Handle is zero, system
1720 6990 B7 0C                 lda   [<Globals],y             ; font, else handle to custom font
1721 6992 D0 05                 bne   SetDialogFont
1722 6994 C8                    iny   
1723 6995 B7 0C                 lda   [<Globals],y
1724 6997 F0 2F                 beq   NoError
1725 6999
1726 6999              ;
1727 6999              ; Set the dialog font to the current dialog manager font
1728 6999              ;
1729 6999              SetDialogFont                           ; 
1730 6999 48                    pha                            ; space for port pointer
1731 699A 48                    pha   
1732 699B A2 04 1C 22           _GetPort                       ; port pointer is on stack
1733 69A2
1734 69A2 A5 0A 48 A5           pushlong theDialog 
1735 69A8 A2 04 1B 22           _SetPort 
1736 69AF
1737 69AF A0 86 00              ldy   #DialogFont+2            ; push font handle
1738 69B2 B7 0C                 lda   [<Globals],y
1739 69B4 48                    pha   
1740 69B5 88                    dey   
1741 69B6 88                    dey   
1742 69B7 B7 0C                 lda   [<Globals],y
1743 69B9 48                    pha   
1744 69BA A2 04 94 22           _SetFont 
1745 69C1
1746 69C1 A2 04 1B 22           _SetPort                       ; reset prev port (which is on stack)
1747 69C8
1748 69C8              NoError                                 ; 
1749 69C8 A9 00 00              lda   #0                       ; no error
1750 69CB
1751 69CB AA           exit     tax                            ; save error message
1752 69CC
1753 69CC A0 04 00              ldy   #4                       ; unlock TheMemHandle
1754 69CF B7 10                 lda   [<TheMemHandle],y
1755 69D1 29 FF 7F              and   #$7FFF
1756 69D4 97 10                 sta   [<TheMemHandle],y
1757 69D6
1758 69D6 8A                    txa   
1759 69D7                         
1760 69D7 2B A8 A3 1A           unlink 
1761 69EB 6B                    rtl   
1762 69EC
1763 69EC              NotAllocated                            ;	    ; Unable to allocate space
1764 69EC AA                    tax                            ; save error code
1765 69ED 68                    pla                            ; pull useless result
1766 69EE 68                    pla   
1767 69EF A9 00 00              lda   #0                       ; clear result (dialog pointer = 0)
1768 69F2 87 35                 sta   [<DialogVariable]
1769 69F4 A0 02 00              ldy   #2
1770 69F7 97 35                 sta   [<DialogVariable],y
1771 69F9 8A                    txa                            ; restore error code
1772 69FA 80 CF                 bra   exit                     ; A contains error code
1773 69FC
1774 69FC                       ENDP 
1775 69FC
1776 69FC
1777 69FC              ;______________________________________________________________________________
1778 69FC              ;
1779 69FC              ;        NewModalDialog
1780 69FC              ;
1781 69FC              ;       input: dBoundsRect:LONG - size and position of dialog's content region.
1782 69FC              ;              dVisible:WORD - TRUE if dialog is visible, FALSE if invisible.
1783 69FC              ;              dRefCon:LONG - any value you'd like to associate with the window.
1784 69FC              ;
1785 69FC              ;      output: theDialog:LONG - pointer to dialog port, zero if error.
1786 69FC              ;
1787 69FC              ;    function: Creates a dialog of type modal. The memory is allocated.
1788 69FC              ;______________________________________________________________________________
1789 69FC
1790 69FC                       ENTRY NewModalDialog
1791 69FC              NewModalDialog PROC 
1792 69FC
1793 69FC 3B 38 E9 00           tlink 10 
1794 6A05
1795 6A05              dRefCon  equ   input
1796 6A05              dVisible equ   dRefCon+4
1797 6A05              dBoundsRect equ   dVisible+2
1798 6A05
1799 6A05              theDialog equ   output
1800 6A05
1801 6A05              ;
1802 6A05              ; Call NewDialog to create the Dialog
1803 6A05              ;
1804 6A05
1805 6A05 F4 00 00 7B           pushzptr <theDialog            ; variable to store result in
1806 6A0E
1807 6A0E A5 0E 48 A5           pushlong dBoundsRect 
1808 6A14
1809 6A14 A9 00 00              lda   #0                       ; no title
1810 6A17 48                    pha                            ; (pushlong #0)
1811 6A18 48                    pha   
1812 6A19
1813 6A19 48                    pha                            ; standard window
1814 6A1A 48                    pha   
1815 6A1B
1816 6A1B 3A                    dec   a                        ; Modal Dialog is always frontmost
1817 6A1C 48                    pha                            ; visible window
1818 6A1D 48                    pha                            ; (pushlong #-1)
1819 6A1E
1820 6A1E F4 08 20              pushword #F_CTRL_TIE+F_ALERT 
1821 6A21
1822 6A21 A5 0A                 lda   <dVisible                ; set flag to visible state
1823 6A23 F0 05                 beq   pushotherparms
1824 6A25
1825 6A25 68                    pla                            ; dialog is visible
1826 6A26 09 20 00              ora   #F_VIS
1827 6A29 48                    pha   
1828 6A2A
1829 6A2A              pushotherparms  
1830 6A2A A5 08 48 A5           pushlong dRefCon 
1831 6A30 F4 FC 00 F4           pushlong #EmptyRect            ; no Full Size for a modal dialog.
1832 6A36 22 39 68 FC           jsl   NewDialog
1833 6A3A B0 0B                 bcs   exit                     ; error!, exit
1834 6A3C
1835 6A3C              ;
1836 6A3C              ; Set Type of Dialog to Modal in dialog record
1837 6A3C              ;
1838 6A3C A9 01 00              lda   #Modal_Type              ; type of dialog
1839 6A3F A0 12 01              ldy   #dlgtype-wport
1840 6A42 97 10                 sta   [<theDialog],y
1841 6A44
1842 6A44 A9 00 00              lda   #0                       ; no error
1843 6A47              exit                                    ; 
1844 6A47 2B A8 A3 05           tunlink 
1845 6A5F 6B                    rtl   
1846 6A60
1847 6A60                       ENTRY EmptyRect
1848 6A60 00 00 00 00  EmptyRect DC W:0,0,0,0
1849 6A68
1850 6A68                       ENDP 
1851 6A68
1852 6A68
1853 6A68              ;______________________________________________________________________________
1854 6A68              ;
1855 6A68              ;        NewModelessDialog
1856 6A68              ;
1857 6A68              ;       input: dBoundsRect:LONG - size and position of dialog's content region.
1858 6A68              ;              dTitle:LONG - pointer to string for dialog's title
1859 6A68              ;              dBehind:LONG - pointer to window the dialog should be behind.
1860 6A68              ;              dFlag:WORD - bit vector describing the dialog's frame
1861 6A68              ;              dRefCon:LONG - any value you'd like to associate with the window.
1862 6A68              ;              dFullSize:LONG - pointer to RECT to be used as content's zoomed.
1863 6A68              ;
1864 6A68              ;      output: theDialog:LONG - pointer to dialog port, zero if error.
1865 6A68              ;
1866 6A68              ;    function: Creates a dialog of type modal. The memory is allocated.
1867 6A68              ;______________________________________________________________________________
1868 6A68
1869 6A68                       ENTRY NewModelessDialog
1870 6A68              NewModelessDialog PROC 
1871 6A68
1872 6A68 3B 38 E9 00           tlink 22 
1873 6A71
1874 6A71              dFullSize equ   input
1875 6A71              dRefCon  equ   dFullSize+4
1876 6A71              dFlag    equ   dRefCon+4
1877 6A71              dBehind  equ   dFlag+2
1878 6A71              dTitle   equ   dBehind+4
1879 6A71              dBoundsRect equ   dTitle+4
1880 6A71
1881 6A71              theDialog equ   output
1882 6A71
1883 6A71              ;
1884 6A71              ; Call NewDialog to create the Dialog
1885 6A71              ;
1886 6A71 F4 00 00 7B           pushzptr <theDialog            ; variable to store result in
1887 6A7A A5 1A 48 A5           pushlong dBoundsRect 
1888 6A80 A5 16 48 A5           pushlong dTitle 
1889 6A86 F4 00 00 F4           pushlong #0                    ; standard window
1890 6A8C A5 12 48 A5           pushlong dBehind 
1891 6A92 A5 0E 48              pushword dFlag 
1892 6A95 A5 0C 48 A5           pushlong dRefCon 
1893 6A9B A5 08 48 A5           pushlong dFullSize 
1894 6AA1 22 39 68 FC           jsl   NewDialog
1895 6AA5 B0 0B                 bcs   exit                     ; error!, exit
1896 6AA7
1897 6AA7              ;
1898 6AA7              ; Set Type of Dialog to Modeless in dialog record
1899 6AA7              ;
1900 6AA7 A9 02 00              lda   #Modeless_Type           ; type of dialog
1901 6AAA A0 12 01              ldy   #dlgtype-wport
1902 6AAD 97 1C                 sta   [<theDialog],y
1903 6AAF
1904 6AAF A9 00 00              lda   #0                       ; no error
1905 6AB2              exit                                    ; 
1906 6AB2 2B A8 A3 05           tunlink 
1907 6ACA 6B                    rtl   
1908 6ACB
1909 6ACB                       ENDP 
1910 6ACB
1911 6ACB
1912 6ACB              ;______________________________________________________________________________
1913 6ACB              ;
1914 6ACB              ;        CloseDialog
1915 6ACB              ;
1916 6ACB              ;       input: theDialog:LONG - pointer to the dialog
1917 6ACB              ;
1918 6ACB              ;      output: none.
1919 6ACB              ;
1920 6ACB              ;    function: removes the dialog from the screen, deletes it from the window
1921 6ACB              ;              list, and releases the memory occupied by the itemlist and the
1922 6ACB              ;              dialogrecord.
1923 6ACB              ;______________________________________________________________________________
1924 6ACB
1925 6ACB                       ENTRY CloseDialog
1926 6ACB              CloseDialog PROC 
1927 6ACB
1928 6ACB 3B 38 E9 00           tlink 4 
1929 6AD4
1930 6AD4              ;
1931 6AD4              ; CloseWindow removes the window from the screen and the window list,
1932 6AD4              ; and releases the memory occupied by the controllist (ie the itemlist)
1933 6AD4              ; and by the dialog record
1934 6AD4
1935 6AD4
1936 6AD4
1937 6AD4 A5 08 48 A5           pushlong input 
1938 6ADA A2 0E 0B 22           _CloseWindow 
1939 6AE1
1940 6AE1 A2 00 00              ldx   #0                       ; no local space
1941 6AE4 4C 75 89              jmp   quit4
1942 6AE7
1943 6AE7                       ENDP 
1944 6AE7
1945 6AE7
1946 6AE7              ;______________________________________________________________________________
1947 6AE7              ;
1948 6AE7              ;        GetNewModalDialog
1949 6AE7              ;
1950 6AE7              ;       input: DialogTemplate:LONG - pointer to Dialog Template
1951 6AE7              ;
1952 6AE7              ;      output: theDialog:LONG - pointer to dialog port, zero if error
1953 6AE7              ;______________________________________________________________________________
1954 6AE7
1955 6AE7                       ENTRY GetNewModalDialog
1956 6AE7              GetNewModalDialog PROC 
1957 6AE7
1958 6AE7 3B 38 E9 00           tlink 4 
1959 6AF0
1960 6AF0              DialogTemplate equ   input
1961 6AF0
1962 6AF0              theDialog equ   output
1963 6AF0
1964 6AF0              ;
1965 6AF0              ; Call DialogFromTemplate to create dialog
1966 6AF0              ;
1967 6AF0 F4 00 00 7B           pushzptr <theDialog 
1968 6AF9
1969 6AF9 A5 08 48 A5           pushlong DialogTemplate        ; pointer to template
1970 6AFF
1971 6AFF A0 08 00              ldy   #dtVisible               ; Visible parameter
1972 6B02 B7 06                 lda   [<DialogTemplate],y
1973 6B04 48                    pha   
1974 6B05
1975 6B05 A0 0C 00 B7           pushlong [<DialogTemplate],dtRefCon  ; RefCon parameter
1976 6B11
1977 6B11 A9 0E 00              lda   #dtitemlist              ; offset to item list
1978 6B14 48                    pha   
1979 6B15
1980 6B15 22 1F 6B FC           jsl   DialogFromTemplate       ; create dialog and set error status
1981 6B19
1982 6B19 A2 00 00              ldx   #0
1983 6B1C 4C 75 89              jmp   quit4
1984 6B1F
1985 6B1F                       ENDP 
1986 6B1F
1987 6B1F
1988 6B1F              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
1989 6B1F              ;
1990 6B1F              ;        DialogFromTemplate
1991 6B1F              ;
1992 6B1F              ;       input: DialogVariable:LONG - pointer to variable to stock dialog in
1993 6B1F              ;              Template:LONG - pointer to template (dialog or alert)
1994 6B1F              ;              Visible:WORD - visible parameter
1995 6B1F              ;              RefCon:LONG - refcon parameter
1996 6B1F              ;              ItemListOffset:WORD - offset to item list in template
1997 6B1F              ;           
1998 6B1F              ;      output: none
1999 6B1F              ;
2000 6B1F              ;    function: create a modal dialog from a template (used by GetNewModalDialog
2001 6B1F              ;              and Alert) and set the error status.
2002 6B1F              ;
2003 6B1F              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
2004 6B1F
2005 6B1F                       ENTRY DialogFromTemplate
2006 6B1F              DialogFromTemplate PROC 
2007 6B1F
2008 6B1F              theDialog equ   0
2009 6B1F              ItemTemplate equ   theDialog+4
2010 6B1F              SizeLocals equ   ItemTemplate+4
2011 6B1F
2012 6B1F 3B 38 E9 08           link 16,SizeLocals 
2013 6B28
2014 6B28              ItemListOffset equ   input
2015 6B28              RefCon   equ   ItemListOffset+2
2016 6B28              Visible  equ   RefCon+4
2017 6B28              Template equ   Visible+2
2018 6B28              DialogVariable equ   Template+4
2019 6B28
2020 6B28              ;
2021 6B28              ; First, creates a modal dialog
2022 6B28              ;
2023 6B28 48                    pha                            ; space for dialog pointer
2024 6B29 48                    pha   
2025 6B2A
2026 6B2A A5 15 48 A5           pushlong Template              ; pointer to rectangle
2027 6B30 A5 11 48              pushword Visible               ; Visible parameter
2028 6B33 A5 0F 48 A5           pushlong RefCon                ; RefCon parameter
2029 6B39 A2 15 0A 22           _NewModalDialog 
2030 6B40
2031 6B40 90 03 82 62           Check_Error NotCreated 
2032 6B45
2033 6B45 68                    pla                            ; store result in local var
2034 6B46 85 00                 sta   <theDialog               ; theDialog and in input parameter
2035 6B48 87 17                 sta   [<DialogVariable]        ; DialogVariable
2036 6B4A 68                    pla   
2037 6B4B 85 02                 sta   <theDialog+2
2038 6B4D A0 02 00              ldy   #2
2039 6B50 97 17                 sta   [<DialogVariable],y
2040 6B52
2041 6B52              ;
2042 6B52              ; Compute pointer to first item template
2043 6B52              ;
2044 6B52              ; Bug fix: Non zero DRefCon caused crash because drefcon was added in. 11/5/87
2045 6B52              ;         add4  <Template,<ItemListOffset,<ItemTemplate        ;fixed DAN H.
2046 6B52 A5 13                 lda   <Template
2047 6B54 18                    clc   
2048 6B55 65 0B                 adc   <ItemListOffset
2049 6B57 85 04                 sta   <ItemTemplate
2050 6B59 A5 15                 lda   <Template+2
2051 6B5B 69 00 00              adc   #0
2052 6B5E 85 06                 sta   <ItemTemplate+2
2053 6B60
2054 6B60
2055 6B60              ;
2056 6B60              ; Then, creates the list of items
2057 6B60              ;
2058 6B60              CreateItems  
2059 6B60
2060 6B60              ;
2061 6B60              ; First check that we are not at the end of the list
2062 6B60              ;
2063 6B60 A7 04                 lda   [<ItemTemplate]
2064 6B62 D0 07                 bne   CreateOne
2065 6B64 A0 02 00              ldy   #2
2066 6B67 B7 04                 lda   [<ItemTemplate],y
2067 6B69 F0 27                 beq   exit                     ; if beq, acc is already 0 (no error)
2068 6B6B
2069 6B6B              ;
2070 6B6B              ; Create one item
2071 6B6B              ;
2072 6B6B              CreateOne  
2073 6B6B A5 02 48 A5           pushlong theDialog 
2074 6B71 A0 02 00              ldy   #2
2075 6B74 B7 04                 lda   [<ItemTemplate],y
2076 6B76 48                    pha   
2077 6B77 A7 04                 lda   [<ItemTemplate]
2078 6B79 48                    pha   
2079 6B7A A2 15 33 22           _GetNewDItem 
2080 6B81
2081 6B81              ;
2082 6B81              ; Get pointer to template of next item in the list
2083 6B81              ;
2084 6B81 A5 04 18 69           add4 <ItemTemplate,#4,<ItemTemplate
2085 6B90 80 CE                 bra   CreateItems
2086 6B92
2087 6B92              exit      
2088 6B92 2B A8 A3 0A           unlink 
2089 6BA6 6B                    rtl   
2090 6BA7
2091 6BA7              NotCreated                              ; 
2092 6BA7 AA                    tax                            ; save error code
2093 6BA8 68                    pla                            ; pull useless result
2094 6BA9 87 17                 sta   [<DialogVariable]
2095 6BAB 68                    pla   
2096 6BAC A0 02 00              ldy   #2
2097 6BAF 97 17                 sta   [<DialogVariable],y
2098 6BB1 8A                    txa                            ; restore error code
2099 6BB2 80 DE                 bra   exit
2100 6BB4
2101 6BB4                       ENDP 
2102 6BB4              ;            copy  Alert.asm
2103 6BB4              ; Alert.asm                     Jean-Charles Mourey
2104 6BB4
2105 6BB4                       TITLE 'Alert Procedures'
2106 6BB4
2107 6BB4              ;..............................................
2108 6BB4              ;
2109 6BB4              ;        Alert Icon Datas
2110 6BB4              ;
2111 6BB4              ;..............................................
2112 6BB4
2113 6BB4                       ENTRY AlertIconDatas
2114 6BB4              AlertIconDatas PROC export 
2115 6BB4
2116 6BB4              ;   ENTRY  IconHandleStruct
2117 6BB4              ;IconHandleStruct   DS.B  20                ; Fake Handle structure to icon
2118 6BB4
2119 6BB4                       export Icon320Table 
2120 6BB4 8C 6D FC 00  Icon320Table DC L:StopIcon320
2121 6BB8 CC 6B FC 00           DC L:NoteIcon320
2122 6BBC AC 6C FC 00           DC L:CautionIcon320
2123 6BC0
2124 6BC0                       export Icon640Table 
2125 6BC0 E4 6F FC 00  Icon640Table DC L:StopIcon640
2126 6BC4 6C 6E FC 00           DC L:NoteIcon640
2127 6BC8 28 6F FC 00           DC L:CautionIcon640
2128 6BCC
2129 6BCC              ;   ENTRY  Icon_Template
2130 6BCC              ;Icon_Template  DC.W    -32768                  ; item ID
2131 6BCC              ;               DC.W    5,20,23,60              ; *** subject to change
2132 6BCC              ;               DC.W    IconItem+ItemDisable
2133 6BCC              ;               DC.L    IconHandleStruct        ; icon handle
2134 6BCC              ;               DC.W    0
2135 6BCC              ;               DC.W    0
2136 6BCC              ;               DC.L    0
2137 6BCC
2138 6BCC              ;
2139 6BCC              ; NoteIcon 320 (each bit * 4 to get the quickdraw bitmap)
2140 6BCC              ;
2141 6BCC
2142 6BCC                       ENTRY NoteIcon320
2143 6BCC              NoteIcon320  
2144 6BCC
2145 6BCC 00 00 00 00           DC W:0,0,18,24
2146 6BD4
2147 6BD4 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
2148 6BE0 0F FF FF F0           DC B:$0f,$ff,$ff,$f0,$00,$00,$00,$00,$00,$00,$00,$00
2149 6BEC 0F FF FF F0           DC B:$0f,$ff,$ff,$f0,$00,$00,$00,$00,$00,$00,$00,$00
2150 6BF8 0F FF 0F F0           DC B:$0f,$ff,$0f,$f0,$00,$00,$ff,$ff,$ff,$f0,$00,$00
2151 6C04 0F FF 0F F0           DC B:$0f,$ff,$0f,$f0,$00,$0f,$ff,$ff,$ff,$ff,$00,$00
2152 6C10 0F FF FF F0           DC B:$0f,$ff,$ff,$f0,$00,$ff,$ff,$ff,$ff,$ff,$f0,$00
2153 6C1C 0F FF FF F0           DC B:$0f,$ff,$ff,$f0,$00,$ff,$00,$f0,$f0,$00,$f0,$00
2154 6C28 0F FF FF F0           DC B:$0f,$ff,$ff,$f0,$00,$ff,$ff,$ff,$ff,$ff,$f0,$00
2155 6C34 0F FF FF F0           DC B:$0f,$ff,$ff,$f0,$00,$ff,$0f,$0f,$00,$f0,$f0,$00
2156 6C40 0F FF FF F0           DC B:$0f,$ff,$ff,$f0,$00,$ff,$ff,$ff,$ff,$ff,$f0,$00
2157 6C4C 0F FF FF F0           DC B:$0f,$ff,$ff,$f0,$00,$ff,$00,$f0,$0f,$0f,$f0,$00
2158 6C58 0F FF 00 00           DC B:$0f,$ff,$00,$00,$00,$ff,$ff,$ff,$ff,$ff,$f0,$00
2159 6C64 0F FF FF 00           DC B:$0f,$ff,$ff,$00,$00,$ff,$ff,$ff,$ff,$ff,$00,$00
2160 6C70 0F FF FF 00           DC B:$0f,$ff,$ff,$00,$0f,$ff,$ff,$ff,$ff,$f0,$00,$00
2161 6C7C 0F F0 00 0F           DC B:$0f,$f0,$00,$0f,$ff,$ff,$ff,$ff,$f0,$00,$00,$00
2162 6C88 0F FF FF 00           DC B:$0f,$ff,$ff,$00,$00,$00,$00,$00,$00,$00,$00,$00
2163 6C94 0F FF FF 00           DC B:$0f,$ff,$ff,$00,$00,$00,$00,$00,$00,$00,$00,$00
2164 6CA0 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
2165 6CAC
2166 6CAC              ;
2167 6CAC              ; CautionIcon 320 (each bit * 4 to get the quickdraw bitmap)
2168 6CAC              ;
2169 6CAC
2170 6CAC                       ENTRY CautionIcon320
2171 6CAC              CautionIcon320  
2172 6CAC
2173 6CAC 00 00 00 00           DC W:0,0,18,24
2174 6CB4
2175 6CB4 FF FF FF FF           DC B:$ff,$ff,$ff,$ff,$ff,$00,$00,$ff,$ff,$ff,$ff,$ff
2176 6CC0 FF FF FF FF           DC B:$ff,$ff,$ff,$ff,$f0,$0f,$f0,$0f,$ff,$ff,$ff,$ff
2177 6CCC FF FF FF FF           DC B:$ff,$ff,$ff,$ff,$00,$ff,$ff,$00,$ff,$ff,$ff,$ff
2178 6CD8 FF FF FF FF           DC B:$ff,$ff,$ff,$ff,$00,$ff,$ff,$00,$ff,$ff,$ff,$ff
2179 6CE4 FF FF FF F0           DC B:$ff,$ff,$ff,$f0,$0f,$f0,$0f,$f0,$0f,$ff,$ff,$ff
2180 6CF0 FF FF FF 00           DC B:$ff,$ff,$ff,$00,$ff,$00,$00,$ff,$00,$ff,$ff,$ff
2181 6CFC FF FF FF 00           DC B:$ff,$ff,$ff,$00,$ff,$00,$00,$ff,$00,$ff,$ff,$ff
2182 6D08 FF FF F0 0F           DC B:$ff,$ff,$f0,$0f,$ff,$00,$00,$ff,$f0,$0f,$ff,$ff
2183 6D14 FF FF F0 0F           DC B:$ff,$ff,$f0,$0f,$ff,$00,$00,$ff,$f0,$0f,$ff,$ff
2184 6D20 FF FF 00 FF           DC B:$ff,$ff,$00,$ff,$ff,$00,$00,$ff,$ff,$00,$ff,$ff
2185 6D2C FF F0 0F FF           DC B:$ff,$f0,$0f,$ff,$ff,$f0,$0f,$ff,$ff,$f0,$0f,$ff
2186 6D38 FF F0 0F FF           DC B:$ff,$f0,$0f,$ff,$ff,$f0,$0f,$ff,$ff,$f0,$0f,$ff
2187 6D44 FF 00 FF FF           DC B:$ff,$00,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$00,$ff
2188 6D50 F0 0F FF FF           DC B:$f0,$0f,$ff,$ff,$ff,$f0,$0f,$ff,$ff,$ff,$f0,$0f
2189 6D5C F0 0F FF FF           DC B:$f0,$0f,$ff,$ff,$ff,$00,$00,$ff,$ff,$ff,$f0,$0f
2190 6D68 00 FF FF FF           DC B:$00,$ff,$ff,$ff,$ff,$f0,$0f,$ff,$ff,$ff,$ff,$00
2191 6D74 00 FF FF FF           DC B:$00,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$00
2192 6D80 F0 00 00 00           DC B:$f0,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$0f
2193 6D8C
2194 6D8C              ;
2195 6D8C              ; StopIcon 320 (each bit * 4 to get the quickdraw bitmap)
2196 6D8C              ;
2197 6D8C
2198 6D8C                       ENTRY StopIcon320
2199 6D8C              StopIcon320  
2200 6D8C
2201 6D8C 00 00 00 00           DC W:0,0,18,24
2202 6D94 FF FF FF 00           DC B:$ff,$ff,$ff,$00,$00,$00,$00,$00,$00,$ff,$ff,$ff
2203 6DA0 FF FF F0 00           DC B:$ff,$ff,$f0,$00,$00,$00,$00,$00,$00,$0f,$ff,$ff
2204 6DAC FF FF 00 00           DC B:$ff,$ff,$00,$00,$00,$00,$ff,$00,$00,$00,$ff,$ff
2205 6DB8 FF F0 00 00           DC B:$ff,$f0,$00,$00,$0f,$f0,$ff,$0f,$f0,$00,$0f,$ff
2206 6DC4 FF 00 00 FF           DC B:$ff,$00,$00,$ff,$0f,$f0,$ff,$0f,$f0,$00,$00,$ff
2207 6DD0 F0 00 00 FF           DC B:$f0,$00,$00,$ff,$0f,$f0,$ff,$0f,$f0,$00,$00,$0f
2208 6DDC F0 00 00 FF           DC B:$f0,$00,$00,$ff,$0f,$f0,$ff,$0f,$f0,$00,$00,$0f
2209 6DE8 00 00 00 FF           DC B:$00,$00,$00,$ff,$0f,$f0,$ff,$0f,$f0,$00,$00,$00
2210 6DF4 00 00 00 FF           DC B:$00,$00,$00,$ff,$ff,$ff,$ff,$ff,$f0,$0f,$f0,$00
2211 6E00 00 00 00 FF           DC B:$00,$00,$00,$ff,$ff,$ff,$ff,$ff,$0f,$ff,$f0,$00
2212 6E0C 00 00 00 FF           DC B:$00,$00,$00,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$00,$00
2213 6E18 00 00 00 FF           DC B:$00,$00,$00,$ff,$ff,$ff,$ff,$ff,$ff,$f0,$00,$00
2214 6E24 F0 00 00 FF           DC B:$f0,$00,$00,$ff,$ff,$ff,$ff,$ff,$ff,$00,$00,$0f
2215 6E30 FF 00 00 FF           DC B:$ff,$00,$00,$ff,$ff,$ff,$ff,$ff,$f0,$00,$00,$ff
2216 6E3C FF F0 00 0F           DC B:$ff,$f0,$00,$0f,$ff,$ff,$ff,$ff,$00,$00,$0f,$ff
2217 6E48 FF FF 00 00           DC B:$ff,$ff,$00,$00,$00,$00,$00,$00,$00,$00,$ff,$ff
2218 6E54 FF FF F0 00           DC B:$ff,$ff,$f0,$00,$00,$00,$00,$00,$00,$0f,$ff,$ff
2219 6E60 FF FF FF 00           DC B:$ff,$ff,$ff,$00,$00,$00,$00,$00,$00,$ff,$ff,$ff
2220 6E6C
2221 6E6C              ;
2222 6E6C              ; NoteIcon 640 (double each bit to get the quickdraw bitmap)
2223 6E6C              ;
2224 6E6C
2225 6E6C                       ENTRY NoteIcon640
2226 6E6C              NoteIcon640  
2227 6E6C
2228 6E6C 00 00 00 00           DC W:0,0,18,40
2229 6E74 00 00 00 00           DC B:%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
2230 6E7E 0F FF FF F0           DC B:%00001111,%11111111,%11111111,%11110000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
2231 6E88 0F FF FF F0           DC B:%00001111,%11111111,%11111111,%11110000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
2232 6E92 0F FF FF F0           DC B:%00001111,%11111111,%11111111,%11110000,%00000000,%00001111,%11111111,%11111111,%00000000,%00000000
2233 6E9C 0F FF 0F F0           DC B:%00001111,%11111111,%00001111,%11110000,%00000000,%11111111,%11111111,%11111111,%11110000,%00000000
2234 6EA6 0F FF 0F F0           DC B:%00001111,%11111111,%00001111,%11110000,%00000000,%11111111,%11111111,%11111111,%11110000,%00000000
2235 6EB0 0F FF FF F0           DC B:%00001111,%11111111,%11111111,%11110000,%00000011,%11110000,%00111100,%00111100,%00111100,%00000000
2236 6EBA 0F FF FF F0           DC B:%00001111,%11111111,%11111111,%11110000,%00000011,%11111111,%11111111,%11111111,%11111100,%00000000
2237 6EC4 0F FF FF F0           DC B:%00001111,%11111111,%11111111,%11110000,%00000011,%11110000,%11110000,%11110000,%00111100,%00000000
2238 6ECE 0F FF FF F0           DC B:%00001111,%11111111,%11111111,%11110000,%00000011,%11111111,%11111111,%11111111,%11111100,%00000000
2239 6ED8 0F FF FF F0           DC B:%00001111,%11111111,%11111111,%11110000,%00000011,%11110000,%00111100,%00111100,%00111100,%00000000
2240 6EE2 0F FF C0 00           DC B:%00001111,%11111111,%11000000,%00000000,%00000011,%11111111,%11111111,%11111111,%11111100,%00000000
2241 6EEC 0F FF FF C0           DC B:%00001111,%11111111,%11111111,%11000000,%00001111,%11111111,%11111111,%11111111,%11110000,%00000000
2242 6EF6 0F FF FF C0           DC B:%00001111,%11111111,%11111111,%11000000,%00111111,%11111111,%11111111,%11111111,%00000000,%00000000
2243 6F00 0F FC 00 03           DC B:%00001111,%11111100,%00000000,%00000011,%11111111,%11111111,%11111111,%11110000,%00000000,%00000000
2244 6F0A 0F FF FF C0           DC B:%00001111,%11111111,%11111111,%11000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
2245 6F14 0F FF FF C0           DC B:%00001111,%11111111,%11111111,%11000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
2246 6F1E 00 00 00 00           DC B:%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
2247 6F28
2248 6F28              ;
2249 6F28              ; CautionIcon 640 (double each bit to get the quickdraw bitmap)
2250 6F28              ;
2251 6F28
2252 6F28                       ENTRY CautionIcon640
2253 6F28              CautionIcon640  
2254 6F28
2255 6F28 00 00 00 00           DC W:0,0,18,40
2256 6F30 FF FF FF FC           DC B:%11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%00111111,%11111111,%11111111,%11111111
2257 6F3A FF FF FF C0           DC B:%11111111,%11111111,%11111111,%11000000,%00000000,%00000000,%00000011,%11111111,%11111111,%11111111
2258 6F44 FF FF FF 00           DC B:%11111111,%11111111,%11111111,%00000000,%00111111,%11111100,%00000000,%11111111,%11111111,%11111111
2259 6F4E FF FF FC 00           DC B:%11111111,%11111111,%11111100,%00000000,%11111111,%11111111,%00000000,%00111111,%11111111,%11111111
2260 6F58 FF FF F0 03           DC B:%11111111,%11111111,%11110000,%00000011,%11110000,%00001111,%11000000,%00001111,%11111111,%11111111
2261 6F62 FF FF C0 0F           DC B:%11111111,%11111111,%11000000,%00001111,%11000000,%00000011,%11110000,%00000011,%11111111,%11111111
2262 6F6C FF FF 00 3F           DC B:%11111111,%11111111,%00000000,%00111111,%11000000,%00000011,%11111100,%00000000,%11111111,%11111111
2263 6F76 FF FC 00 FF           DC B:%11111111,%11111100,%00000000,%11111111,%11000000,%00000011,%11111111,%00000000,%00111111,%11111111
2264 6F80 FF F0 03 FF           DC B:%11111111,%11110000,%00000011,%11111111,%11000000,%00000011,%11111111,%11000000,%00001111,%11111111
2265 6F8A FF C0 0F FF           DC B:%11111111,%11000000,%00001111,%11111111,%11110000,%00001111,%11111111,%11110000,%00000011,%11111111
2266 6F94 FF 00 3F FF           DC B:%11111111,%00000000,%00111111,%11111111,%11110000,%00001111,%11111111,%11111100,%00000000,%11111111
2267 6F9E FC 00 FF FF           DC B:%11111100,%00000000,%11111111,%11111111,%11111100,%00111111,%11111111,%11111111,%00000000,%00111111
2268 6FA8 F0 03 FF FF           DC B:%11110000,%00000011,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11000000,%00001111
2269 6FB2 C0 0F FF FF           DC B:%11000000,%00001111,%11111111,%11111111,%11110000,%00001111,%11111111,%11111111,%11110000,%00000011
2270 6FBC 00 3F FF FF           DC B:%00000000,%00111111,%11111111,%11111111,%11110000,%00001111,%11111111,%11111111,%11111100,%00000000
2271 6FC6 00 FF FF FF           DC B:%00000000,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%00000000
2272 6FD0 00 00 00 00           DC B:%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
2273 6FDA C0 00 00 00           DC B:%11000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000011
2274 6FE4
2275 6FE4              ;
2276 6FE4              ; StopIcon 640 (double each bit to get the Quickdraw bitmap)
2277 6FE4              ;
2278 6FE4
2279 6FE4                       ENTRY StopIcon640
2280 6FE4              StopIcon640  
2281 6FE4
2282 6FE4 00 00 00 00           DC W:0,0,18,40
2283 6FEC FF FF FF 00           DC B:%11111111,%11111111,%11111111,%00000000,%00000000,%00000000,%00000000,%11111111,%11111111,%11111111
2284 6FF6 FF FF F0 00           DC B:%11111111,%11111111,%11110000,%00000000,%00000000,%00000000,%00000000,%00001111,%11111111,%11111111
2285 7000 FF FF 00 00           DC B:%11111111,%11111111,%00000000,%00000000,%00000000,%11111100,%00000000,%00000000,%11111111,%11111111
2286 700A FF F0 00 03           DC B:%11111111,%11110000,%00000000,%00000011,%11110000,%11111100,%00111111,%00000000,%00001111,%11111111
2287 7014 FF 00 0F C3           DC B:%11111111,%00000000,%00001111,%11000011,%11110000,%11111100,%00111111,%00000000,%00000000,%11111111
2288 701E F0 00 0F C3           DC B:%11110000,%00000000,%00001111,%11000011,%11110000,%11111100,%00111111,%00000000,%00000000,%00001111
2289 7028 00 00 0F C3           DC B:%00000000,%00000000,%00001111,%11000011,%11110000,%11111100,%00111111,%00000000,%00000000,%00000000
2290 7032 00 00 0F C3           DC B:%00000000,%00000000,%00001111,%11000011,%11110000,%11111100,%00111111,%00000000,%00000000,%00000000
2291 703C 00 00 0F FF           DC B:%00000000,%00000000,%00001111,%11111111,%11111111,%11111111,%11111111,%00000000,%00000000,%00000000
2292 7046 00 00 0F FF           DC B:%00000000,%00000000,%00001111,%11111111,%11111111,%11111111,%11111111,%00000011,%11110000,%00000000
2293 7050 00 00 0F FF           DC B:%00000000,%00000000,%00001111,%11111111,%11111111,%11111111,%11111111,%11111111,%11110000,%00000000
2294 705A 00 00 0F FF           DC B:%00000000,%00000000,%00001111,%11111111,%11111111,%11111111,%11111111,%11111111,%00000000,%00000000
2295 7064 F0 00 0F FF           DC B:%11110000,%00000000,%00001111,%11111111,%11111111,%11111111,%11111111,%11110000,%00000000,%00001111
2296 706E FF 00 0F FF           DC B:%11111111,%00000000,%00001111,%11111111,%11111111,%11111111,%11111111,%00000000,%00000000,%11111111
2297 7078 FF F0 00 FF           DC B:%11111111,%11110000,%00000000,%11111111,%11111111,%11111111,%11110000,%00000000,%00001111,%11111111
2298 7082 FF FF 00 0F           DC B:%11111111,%11111111,%00000000,%00001111,%11111111,%11111111,%00000000,%00000000,%11111111,%11111111
2299 708C FF FF F0 00           DC B:%11111111,%11111111,%11110000,%00000000,%00000000,%00000000,%00000000,%00001111,%11111111,%11111111
2300 7096 FF FF FF 00           DC B:%11111111,%11111111,%11111111,%00000000,%00000000,%00000000,%00000000,%11111111,%11111111,%11111111
2301 70A0
2302 70A0                       ENDP 
2303 70A0
2304 70A0              ;____________________________________________________________________________
2305 70A0              ;
2306 70A0              ;       StopAlert
2307 70A0              ;
2308 70A0              ;      input: AlertTemplate:LONG - pointer to the alert template
2309 70A0              ;             filterProc:LONG - pointer to a filter procedure
2310 70A0              ;
2311 70A0              ;     output: itemHit:WORD - ID of item Hit
2312 70A0              ;_____________________________________________________________________________
2313 70A0
2314 70A0                       ENTRY StopAlert
2315 70A0              StopAlert PROC 
2316 70A0
2317 70A0 A2 01 00              ldx   #stopIcon
2318 70A3 80 0D                 bra   GeneralAlert
2319 70A5
2320 70A5                       ENDP 
2321 70A5
2322 70A5              ;____________________________________________________________________________
2323 70A5              ;
2324 70A5              ;       NoteAlert
2325 70A5              ;
2326 70A5              ;      input: AlertTemplate:LONG - pointer to the alert template
2327 70A5              ;             filterProc:LONG - pointer to a filter procedure
2328 70A5              ;
2329 70A5              ;     output: itemHit:WORD - ID of item Hit
2330 70A5              ;_____________________________________________________________________________
2331 70A5
2332 70A5                       ENTRY NoteAlert
2333 70A5              NoteAlert PROC 
2334 70A5
2335 70A5 A2 02 00              ldx   #noteIcon
2336 70A8 80 08                 bra   GeneralAlert
2337 70AA
2338 70AA                       ENDP 
2339 70AA
2340 70AA              ;____________________________________________________________________________
2341 70AA              ;
2342 70AA              ;       CautionAlert
2343 70AA              ;
2344 70AA              ;      input: AlertTemplate:LONG - pointer to the alert template
2345 70AA              ;             filterProc:LONG - pointer to a filter procedure
2346 70AA              ;
2347 70AA              ;     output: itemHit:WORD - ID of item Hit
2348 70AA              ;_____________________________________________________________________________
2349 70AA
2350 70AA                       ENTRY CautionAlert
2351 70AA              CautionAlert PROC 
2352 70AA
2353 70AA A2 03 00              ldx   #cautionIcon
2354 70AD 80 03                 bra   GeneralAlert
2355 70AF
2356 70AF                       ENDP 
2357 70AF
2358 70AF              ;____________________________________________________________________________
2359 70AF              ;
2360 70AF              ;       Alert
2361 70AF              ;
2362 70AF              ;      input: AlertTemplate:LONG - pointer to the alert template
2363 70AF              ;             filterProc:LONG - pointer to a filter procedure
2364 70AF              ;
2365 70AF              ;     output: itemHit:WORD - ID of item Hit
2366 70AF              ;_____________________________________________________________________________
2367 70AF
2368 70AF                       ENTRY Alert
2369 70AF              Alert    PROC 
2370 70AF
2371 70AF A2 00 00              ldx   #0
2372 70B2
2373 70B2                       ENDP 
2374 70B2
2375 70B2              ;____________________________________________________________________________
2376 70B2              ;
2377 70B2              ;       GeneralAlert
2378 70B2              ;
2379 70B2              ;      input: AlertTemplate:LONG - pointer to the alert template
2380 70B2              ;             filterProc:LONG - pointer to a filter procedure
2381 70B2              ;
2382 70B2              ;             A-reg contains the WAP from dispatcher
2383 70B2              ;             X-reg contains the icon id to use.
2384 70B2              ;
2385 70B2              ;     output: itemHit:WORD - ID of item Hit
2386 70B2              ;
2387 70B2              ; This is a general alert routine called by the specific alert routines
2388 70B2              ; that are entry points to the dialog manager.  The specific routines
2389 70B2              ; load the x-reg with the icon ID that should be used and preserve
2390 70B2              ; the WAP from the dispatcher.
2391 70B2              ;
2392 70B2              ; Change History
2393 70B2              ;
2394 70B2              ; 4 March 88        STEVEN Glass
2395 70B2              ;
2396 70B2              ; Used WAP instead of calling control manager for WAP
2397 70B2              ;_____________________________________________________________________________
2398 70B2
2399 70B2                       ENTRY GeneralAlert
2400 70B2              GeneralAlert PROC 
2401 70B2
2402 70B2              theDialog equ   0
2403 70B2              ItemTemplate equ   theDialog+4
2404 70B2              PortSave equ   ItemTemplate+4
2405 70B2              Globals  equ   PortSave+4
2406 70B2              StageVector equ   Globals+4
2407 70B2              IconID   equ   StageVector+2
2408 70B2              IconHandleStruct equ   IconID+2
2409 70B2              SizeLocals equ   IconHandleStruct+4
2410 70B2
2411 70B2
2412 70B2 A8                    tay                            ; save d-page in y
2413 70B3
2414 70B3 3B 38 E9 18           tlink 8,SizeLocals 
2415 70BC
2416 70BC              filterProc equ   input
2417 70BC              AlertTemplate equ   filterProc+4
2418 70BC
2419 70BC              itemHit  equ   output
2420 70BC
2421 70BC 86 12                 stx   <IconID                  ; save Icon ID
2422 70BE
2423 70BE              ;
2424 70BE              ; Get Dialog Manager Zero Page
2425 70BE              ;
2426 70BE 84 0C                 sty   <Globals
2427 70C0 64 0E                 stz   <Globals+2
2428 70C2
2429 70C2
2430 70C2 A0 AA 00              ldy   #HandStruct
2431 70C5 B7 0C                 lda   [<Globals],y
2432 70C7 85 14                 sta   <IconHandleStruct
2433 70C9 C8                    iny   
2434 70CA C8                    iny   
2435 70CB B7 0C                 lda   [<Globals],y
2436 70CD 85 16                 sta   <IconHandleStruct+2
2437 70CF
2438 70CF              ;
2439 70CF              ; Is it the same alert as the last alert
2440 70CF              ;
2441 70CF A0 08 00              ldy   #atalertID
2442 70D2 B7 22                 lda   [<AlertTemplate],y
2443 70D4 A0 8E 00              ldy   #LastAlertID
2444 70D7 D7 0C                 cmp   [<Globals],y
2445 70D9 F0 0A                 beq   GetStage
2446 70DB
2447 70DB              ;
2448 70DB              ; If not, set lastalertID to current alert, and reset alert stage
2449 70DB              ;
2450 70DB 97 0C                 sta   [<Globals],y             ; a = AlertID, y = #LastAlertID
2451 70DD
2452 70DD A9 00 00              lda   #0
2453 70E0 A0 8C 00              ldy   #AlertStage
2454 70E3 97 0C                 sta   [<Globals],y
2455 70E5
2456 70E5              ;
2457 70E5              ; Get the current stage of the alert
2458 70E5              ;
2459 70E5              GetStage                                ; 
2460 70E5 A0 8C 00              ldy   #AlertStage              ; calculate offset to current stage
2461 70E8 B7 0C                 lda   [<Globals],y             ; in the alert template
2462 70EA 18                    clc   
2463 70EB 69 0A 00              adc   #atstage1
2464 70EE A8                    tay   
2465 70EF B7 22                 lda   [<AlertTemplate],y
2466 70F1 29 FF 00              and   #$FF
2467 70F4 85 10                 sta   <StageVector
2468 70F6
2469 70F6              ;
2470 70F6              ; Call the Sound Procedure
2471 70F6              ;
2472 70F6 29 03 00              and   #%00000011               ; get sound number in bits 0-1
2473 70F9 48                    pha   
2474 70FA
2475 70FA A0 89 00              ldy   #AlertSoundProc+1        ; look if there is a custom sound proc
2476 70FD B7 0C                 lda   [<Globals],y             ; (X = bits 8-23)
2477 70FF 88                    dey                            ; Y = AlertSoundProc
2478 7100 AA                    tax   
2479 7101 D0 0A                 bne   CallCustomSound
2480 7103
2481 7103 B7 0C                 lda   [<Globals],y             ; test now low word
2482 7105 D0 06                 bne   CallCustomSound          ; (A = bits 0-15)
2483 7107
2484 7107 22 EB 82 FC           jsl   StdSoundProc             ; call standard sound proc
2485 710B 80 06                 bra   CheckDrawn
2486 710D
2487 710D              CallCustomSound  
2488 710D B7 0C                 lda   [<Globals],y             ; X already=bits 8-23, Y=AlertSoundProc
2489 710F 22 52 89 FC           jsl   long_call                ; and A = low byte of procedure address
2490 7113
2491 7113              ;
2492 7113              ; Look if alert box should be drawn
2493 7113              ;
2494 7113              CheckDrawn  
2495 7113 A5 10                 lda   <StageVector
2496 7115 29 80 00              and   #%10000000               ; boxdrawn is bit 7
2497 7118 D0 03                 bne   CreateDialog
2498 711A 82 D7 00              brl   IncAlertStage
2499 711D
2500 711D              ;
2501 711D              ; Creates modal dialog for alert by calling DialogFromTemplate
2502 711D              ;
2503 711D              CreateDialog  
2504 711D
2505 711D F4 00 00 7B           pushzptr <theDialog            ; variable to store dialog ptr in
2506 7126
2507 7126 A5 24 48 A5           pushlong AlertTemplate         ; pointer to template
2508 712C
2509 712C F4 01 00              pushword #1                    ; visible
2510 712F
2511 712F A9 00 00              lda   #0                       ; refcon = 0
2512 7132 48                    pha   
2513 7133 48                    pha   
2514 7134
2515 7134 A9 0E 00              lda   #atitemlist              ; offset to item list
2516 7137 48                    pha   
2517 7138
2518 7138 22 1F 6B FC           jsl   DialogFromTemplate       ; create dialog and set error status
2519 713C
2520 713C 90 03                 bcc   AddIcon                  ; error!, exit
2521 713E
2522 713E 82 C3 00              brl   exit
2523 7141
2524 7141              ;
2525 7141              ; Then add the alert icon
2526 7141              ;
2527 7141 A5 12        AddIcon  lda   <IconID
2528 7143 F0 7A                 beq   SetDef                   ; no icon
2529 7145
2530 7145 3A                    dec   a                        ; compute index to icon pointer
2531 7146 0A                    asl   a
2532 7147 0A                    asl   a
2533 7148 AA                    tax   
2534 7149
2535 7149              ;
2536 7149              ; Assume we're in 640 mode
2537 7149              ;
2538 7149 BF C0 6B FC           lda   >Icon640Table,x          ; get icon pointer from 640 table
2539 714D 87 14                 sta   [<IconHandleStruct]      ; and store in fake handle
2540 714F BF C2 6B FC           lda   >Icon640Table+2,x
2541 7153 A0 02 00              ldy   #2
2542 7156 97 14                 sta   [<IconHandleStruct],y
2543 7158
2544 7158              ;
2545 7158              ; See if we are in 320 or 640
2546 7158              ;
2547 7158 A7 00                 lda   [<theDialog]             ; get PortSCB
2548 715A 29 80 00              and   #$0080                   ; 0=320, 1=640
2549 715D D0 0F                 bne   CreateIcon
2550 715F
2551 715F BF B4 6B FC           lda   >Icon320Table,x          ; get icon pointer from 320 table
2552 7163 87 14                 sta   [<IconHandleStruct]      ; and store in fake handle
2553 7165 BF B6 6B FC           lda   >Icon320Table+2,x
2554 7169 A0 02 00              ldy   #2
2555 716C 97 14                 sta   [<IconHandleStruct],y
2556 716E
2557 716E 3B           CreateIcon tsc                          ; make room on the stack for icon template
2558 716F 38                    sec   
2559 7170 E9 18 00              sbc   #24
2560 7173 1B                    tcs   
2561 7174
2562 7174 1A                    inc   a                        ; store starting address of icon template in x
2563 7175 AA                    tax   
2564 7176
2565 7176 A9 00 80              lda   #-32768                  ; store icon ID
2566 7179 83 01                 sta   iconitemID+1,s
2567 717B A9 05 00              lda   #5                       ; store icon boundaries
2568 717E 83 03                 sta   iconitemRect+1,s
2569 7180 A9 14 00              lda   #20
2570 7183              *** From GeneralAlert to here is duplicated in the ROM 3 patch
2571 7183 83 05        @1       sta   iconitemRect+1+2,s
2572 7185 A9 17 00              lda   #23
2573 7188 83 07                 sta   iconitemRect+1+4,s
2574 718A A9 3C 00              lda   #60
2575 718D 83 09                 sta   iconitemRect+1+6,s
2576 718F A9 12 80              lda   #IconItem+ItemDisable
2577 7192 83 0B                 sta   iconitemType+1,s
2578 7194
2579 7194 A5 14                 lda   <IconHandleStruct
2580 7196 83 0D                 sta   iconitemDescr+1,s
2581 7198 A5 16                 lda   <IconHandleStruct+2
2582 719A 83 0F                 sta   iconitemDescr+1+2,s
2583 719C
2584 719C A9 00 00              lda   #0                       ; store icon item value, flag, and ptr to color table
2585 719F 83 11                 sta   iconitemValue+1,s
2586 71A1 83 13                 sta   iconitemFlag+1,s
2587 71A3 83 15                 sta   iconitemColor+1,s
2588 71A5 83 17                 sta   iconitemColor+1+2,s
2589 71A7
2590 71A7
2591 71A7 A5 02 48 A5           pushlong theDialog 
2592 71AD              ;        pushlong #Icon_Template
2593 71AD F4 00 00              pea   0000                     ; push address of icon template onto stack
2594 71B0 8A                    txa   
2595 71B1 48                    pha   
2596 71B2 A2 15 33 22           _GetNewDItem                   ; create icon
2597 71B9
2598 71B9 3B                    tsc                            ; remove icon template space from stack
2599 71BA 18                    clc   
2600 71BB 69 18 00              adc   #24
2601 71BE 1B                    tcs   
2602 71BF              ;
2603 71BF              ; Set the default button to what is specified in the alert template
2604 71BF              ;
2605 71BF              SetDef                                  ; 
2606 71BF A5 10                 lda   <StageVector
2607 71C1 29 40 00              and   #%01000000               ; default button ID minus 1 is bit 6
2608 71C4 F0 10                 beq   CallModalDialog
2609 71C6
2610 71C6              ;
2611 71C6              ; When dialog is created, default button is ID 1. If alert defbutID bit is
2612 71C6              ; set, must change dialog default button to ID 2 (Cancel).
2613 71C6              ;
2614 71C6 F4 02 00              pushword #2 
2615 71C9 A5 02 48 A5           pushlong theDialog 
2616 71CF A2 15 38 22           _SetDefButton 
2617 71D6
2618 71D6              CallModalDialog                         ; 
2619 71D6 48                    pha                            ; space for itemHit output
2620 71D7 A5 20 48 A5           pushlong filterProc 
2621 71DD A2 15 0F 22           _ModalDialog 
2622 71E4 68                    pla   
2623 71E5 85 26                 sta   <itemHit
2624 71E7
2625 71E7              ;
2626 71E7              ; And dispose of dialog
2627 71E7              ;
2628 71E7 A5 02 48 A5           pushlong theDialog 
2629 71ED A2 15 0C 22           _CloseDialog 
2630 71F4
2631 71F4              ;
2632 71F4              ; Increment Alert Stage if not already maximum (3)
2633 71F4              ;
2634 71F4              IncAlertStage  
2635 71F4 A0 8C 00              ldy   #AlertStage
2636 71F7 B7 0C                 lda   [<Globals],y
2637 71F9 C9 03 00              cmp   #3
2638 71FC B0 03                 bge   noerror
2639 71FE 1A                    inc   a
2640 71FF 97 0C                 sta   [<Globals],y
2641 7201
2642 7201 A9 00 00     noerror  lda   #0
2643 7204
2644 7204              exit      
2645 7204 2B A8 A3 1D           tunlink 
2646 721C 6B                    rtl   
2647 721D
2648 721D                       ENDP 
2649 721D
2650 721D
2651 721D              ;_____________________________________________________________________________
2652 721D              ;
2653 721D              ;        GetAlertStage
2654 721D              ;
2655 721D              ;       input: none
2656 721D              ;
2657 721D              ;      output: CurAlertStage:WORD - current stage of alert
2658 721D              ;_______________________________________________________________________________
2659 721D
2660 721D                       ENTRY GetAlertStage
2661 721D              GetAlertStage PROC 
2662 721D
2663 721D A0 8C 00              ldy   #AlertStage
2664 7220 4C 1C 8A              jmp   getWORDfromZP
2665 7223
2666 7223                       ENDP 
2667 7223
2668 7223
2669 7223              ;_____________________________________________________________________________
2670 7223              ;
2671 7223              ;        ResetAlertStage
2672 7223              ;
2673 7223              ;       input: none
2674 7223              ;
2675 7223              ;      output: none
2676 7223              ;
2677 7223              ; Change History
2678 7223              ;
2679 7223              ; 4 March 88        Steven Glass
2680 7223              ;
2681 7223              ; Changed to use the WAP instead of calling the Control manager for the 
2682 7223              ; direct page value.
2683 7223              ;______________________________________________________________________________
2684 7223
2685 7223                       ENTRY ResetAlertStage
2686 7223              ResetAlertStage PROC 
2687 7223
2688 7223              ;
2689 7223              ; Save original zero page
2690 7223              ;
2691 7223 0B                    phd   
2692 7224 5B                    tcd   
2693 7225
2694 7225 64 8C                 stz   <AlertStage
2695 7227
2696 7227              ;
2697 7227              ; Restore original zero page
2698 7227              ;
2699 7227 2B                    pld   
2700 7228
2701 7228 A9 00 00              lda   #0
2702 722B 18                    clc   
2703 722C 6B                    rtl   
2704 722D                       ENDP 
2705 722D
2706 722D
2707 722D
2708 722D              ;            copy  NewItem.asm
2709 722D              ; NewItem.asm                           Jean-Charles Mourey
2710 722D
2711 722D                       TITLE 'New Item Procedures'
2712 722D
2713 722D              ;.......................................
2714 722D              ;
2715 722D              ;        DefProc Table
2716 722D              ;.......................................
2717 722D
2718 722D                       ENTRY DefProcTable
2719 722D              DefProcTable PROC 
2720 722D 00 00 00 00           DC L:$00000000
2721 7231 00 00 00 02           DC L:$02000000
2722 7235 00 00 00 04           DC L:$04000000
2723 7239 00 00 00 06           DC L:$06000000
2724 723D 00 00 00 00           DC L:$00000000                 ; User Control Item, not used here
2725 7241                       IMPORT StatTextDefProc 
2726 7241                       IMPORT LongStatTextDefProc 
2727 7241                       IMPORT EditLineDefProc 
2728 7241                       IMPORT IconItemDefProc 
2729 7241                       IMPORT PicItemDefProc 
2730 7241                       IMPORT UserItemDefProc 
2731 7241 39 8A FC 00           DC L:StatTextDefProc
2732 7245 95 8C FC 00           DC L:LongStatTextDefProc
2733 7249 AD 8D FC 00           DC L:EditLineDefProc
2734 724D 3B 92 FC 00           DC L:IconItemDefProc
2735 7251 6C 93 FC 00           DC L:PicItemDefProc
2736 7255 78 91 FC 00           DC L:UserItemDefProc
2737 7259 00 00 00 00           DC L:$00000000                 ; User Control Item 2, not used here
2738 725D 95 8C FC 00           DC L:LongStatTextDefProc       ; DAN H. (added for LongStatText2)
2739 7261                       ENDP 
2740 7261
2741 7261              ;______________________________________________________________________________
2742 7261              ;
2743 7261              ;        NewDItem
2744 7261              ;
2745 7261              ;       input: theDialog:LONG - pointer to dialog this item belongs to.
2746 7261              ;              ItemID:WORD - item identifier for all item -related dlg mgr calls
2747 7261              ;  rect/point  ItemRect:LONG - display rectangle (or upper-left point twice)
2748 7261              ;              ItemType:WORD - Button, Check, UserCtl, EditText, Pic, UserItem.
2749 7261              ;              ItemDescr:LONG - stringptr, procptr, iconhandle or pichandle.
2750 7261              ;              ItemValue:WORD - init value, textlen, maxlen, or 0 or ...
2751 7261              ;   optional   ItemFlag:WORD - includes visible/invisible flag (0 for default)
2752 7261              ;   optional   ItemColor:LONG - pointer to item's color table (0 for default)
2753 7261              ;
2754 7261              ;      output: none.
2755 7261              ;
2756 7261              ;    function: Adds a new item to the dialog's item list and draws it if it's
2757 7261              ;              visible.
2758 7261              ; Really What Happens: Creates a Control (see _NewControl) from the parameters
2759 7261              ;              passed, the actual drawing is done later by routines such as
2760 7261              ;              _ModalDialog. (DAN H.)
2761 7261              ;
2762 7261              ;   ItemType                   ItemDescr                  ItemValue
2763 7261              ; ----------------------------------------------------------------------------
2764 7261              ;   Button, Check, RadioItem   title string               init value
2765 7261              ;   StatText                   static string              0
2766 7261              ;   LongStatText               text pointer               text length
2767 7261              ;   EditLine                   default string             max string length
2768 7261              ;   ScrollBarItem              scrollbar itemdef proc     0 or default value
2769 7261              ;   IconItem                   iconhandle                 0
2770 7261              ;   PicItem                    pichandle                  0
2771 7261              ;   UserCtlItem                control definition proc    init value
2772 7261              ;   UserItem                   item definition proc       any value you want
2773 7261              ;   UserCtlItem2               control additional parms   init value
2774 7261              ; ----------------------------------------------------------------------------
2775 7261              ;
2776 7261              ; IconHandle: handle to an icon.
2777 7261              ;
2778 7261              ; ScrollBar ItemDef Proc:
2779 7261              ;
2780 7261              ;              inputs: command (getinitview, getinittotal, getinitvalue, action)
2781 7261              ;                      ScrollBarID
2782 7261              ;
2783 7261              ;              output: result (view, total, value or none).
2784 7261              ;______________________________________________________________________________
2785 7261
2786 7261                       ENTRY NewDItem
2787 7261              NewDItem PROC 
2788 7261
2789 7261              ItemControl equ   0
2790 7261              ItemPtr  equ   ItemControl+4
2791 7261              ItemTypeNum equ   ItemPtr+4
2792 7261              defproc  equ   ItemTypeNum+2
2793 7261              PortSave equ   defproc+4
2794 7261              ScrollBarDef equ   PortSave+4
2795 7261              LongParam equ   ScrollBarDef+4
2796 7261              Title    equ   LongParam+4
2797 7261              SizeLocals equ   Title+4
2798 7261
2799 7261 3B 38 E9 1E           tlink 24,SizeLocals 
2800 726A
2801 726A              ItemColor equ   input
2802 726A              ItemFlag equ   ItemColor+4
2803 726A              ItemValue equ   ItemFlag+2
2804 726A              ItemDescr equ   ItemValue+2
2805 726A              ItemType equ   ItemDescr+4
2806 726A              ItemRect equ   ItemType+2
2807 726A              ItemID   equ   ItemRect+4
2808 726A              theDialog equ   ItemID+2
2809 726A
2810 726A              ;
2811 726A              ; Clear LongParam (Param1/Param2 for NewControl)
2812 726A              ;
2813 726A 64 16                 stz   <LongParam
2814 726C 64 18                 stz   <LongParam+2
2815 726E
2816 726E              ;
2817 726E              ; Set Current port = our dialog
2818 726E              ;
2819 726E 48                    pha                            ; space for port pointer
2820 726F 48                    pha   
2821 7270 A2 04 1C 22           _GetPort 
2822 7277 68 85 0E 68           pulllong <PortSave 
2823 727D
2824 727D A5 3A 48 A5           pushlong theDialog 
2825 7283 A2 04 1B 22           _SetPort 
2826 728A
2827 728A A9 00 00              lda   #0                       ; set origin to 0,0
2828 728D 48                    pha   
2829 728E 48                    pha   
2830 728F A2 04 23 22           _SetOrigin 
2831 7296
2832 7296              ;
2833 7296              ; Check ItemType
2834 7296              ;
2835 7296 A5 30                 lda   <ItemType
2836 7298 29 FF 7F              and   #$7FFF                   ; get rid of ItemDisable bit
2837 729B 85 08                 sta   <ItemTypeNum
2838 729D
2839 729D C9 0A 00              cmp   #ButtonItem
2840 72A0 B0 03                 bge   TestSup
2841 72A2 82 47 01              brl   badtype
2842 72A5
2843 72A5              TestSup                                 ; 
2844 72A5 C9 17 00              cmp   #MaxItemType+1
2845 72A8 90 03                 blt   TestUserCtl
2846 72AA 82 3F 01              brl   badtype
2847 72AD
2848 72AD              ;
2849 72AD              ; User Control Item is a little bit special
2850 72AD              ;
2851 72AD              TestUserCtl                             ; 
2852 72AD C9 0E 00              cmp   #UserCtlItem
2853 72B0 D0 14                 bne   isUserCtl2
2854 72B2 A5 2C 85 0A           movelong <ItemDescr,<defproc 
2855 72BA A9 61 74 85           movelong #EmptyString,<ItemDescr 
2856 72C4 80 7C                 bra   CallNewControl
2857 72C6
2858 72C6              ;
2859 72C6              ; User Control Item 2 is even more special
2860 72C6              ;
2861 72C6              isUserCtl2                              ; 
2862 72C6 C9 15 00              cmp   #UserCtlItem2
2863 72C9 D0 34                 bne   isScrollBar
2864 72CB A0 00 00 B7           movelong [<ItemDescr],DefProcParm,<defproc 
2865 72D9 A0 08 00 B7           movelong [<ItemDescr],ParamLong,<LongParam 
2866 72E7 A0 04 00 B7           movelong [<ItemDescr],TitleParm,<Title 
2867 72F5 A5 1A 85 2C           movelong <Title,<ItemDescr 
2868 72FD 80 43                 bra   CallNewControl
2869 72FF
2870 72FF              ;
2871 72FF              ; Scroll Bar item is very special
2872 72FF              ;
2873 72FF              isScrollBar                             ; 
2874 72FF C9 0D 00              cmp   #ScrollBarItem
2875 7302 D0 14                 bne   isButton
2876 7304 A5 2C 85 12           movelong <ItemDescr,<ScrollBarDef 
2877 730C A9 61 74 85           movelong #EmptyString,<ItemDescr 
2878 7316 80 15                 bra   isOther
2879 7318
2880 7318              ;
2881 7318              ; Thick outline for default button
2882 7318              ;
2883 7318              isButton                                ; 
2884 7318 C9 0A 00              cmp   #ButtonItem
2885 731B D0 10                 bne   isOther
2886 731D A0 16 01              ldy   #defbutID-wport
2887 7320 B7 38                 lda   [<theDialog],y
2888 7322 C5 36                 cmp   <ItemID
2889 7324 D0 07                 bne   isOther
2890 7326 A5 28                 lda   <ItemFlag                ; if the button is the default button
2891 7328 09 01 00              ora   #BOLD_BUTT               ; create it with a thick outline
2892 732B 85 28                 sta   <ItemFlag
2893 732D
2894 732D              isOther                                 ; 
2895 732D A5 08                 lda   <ItemTypeNum
2896 732F 38                    sec   
2897 7330 E9 0A 00              sbc   #ButtonItem
2898 7333 0A                    asl   a
2899 7334 0A                    asl   a
2900 7335 AA                    tax   
2901 7336 BF 2D 72 FC           lda   >DefProcTable,x
2902 733A 85 0A                 sta   <defproc
2903 733C BF 2F 72 FC           lda   >DefProcTable+2,x
2904 7340 85 0C                 sta   <defproc+2
2905 7342
2906 7342              CallNewControl                          ; 
2907 7342 48                    pha                            ; space for control handle
2908 7343 48                    pha   
2909 7344 A5 3A 48 A5           pushlong theDialog 
2910 734A A5 34 48 A5           pushlong ItemRect 
2911 7350 A5 2E 48 A5           pushlong ItemDescr             ; contains CtrlData or empty string
2912 7356 A5 28 48              pushword ItemFlag 
2913 7359
2914 7359 A5 08                 lda   <ItemTypeNum
2915 735B C9 0D 00              cmp   #ScrollBarItem
2916 735E F0 0C                 beq   CallScrollBarProcedure
2917 7360
2918 7360 A5 2A 48              pushword ItemValue 
2919 7363 A5 18 48 A5           pushlong LongParam             ; Param1, Param2
2920 7369 82 56 00              brl   pushotherparms
2921 736C
2922 736C
2923 736C              CallScrollBarProcedure                  ; 
2924 736C              ;
2925 736C              ; Check that ScrollBarDef is non zero before to call it
2926 736C              ;
2927 736C A5 12                 lda   <ScrollBarDef
2928 736E D0 04                 bne   CheckNotNeg
2929 7370 A5 14                 lda   <ScrollBarDef+2
2930 7372 F0 45                 beq   DefaultValues
2931 7374
2932 7374              ;
2933 7374              ; Check that ScrollBarDef is not negative before to call it (autoTrack feature)
2934 7374              ;
2935 7374              CheckNotNeg                             ; 
2936 7374 A5 14                 lda   <ScrollBarDef+2
2937 7376 30 41                 bmi   DefaultValues
2938 7378
2939 7378              ;
2940 7378              ; Get the init values for the Scroll Bar from the Scroll Bar defproc
2941 7378              ;
2942 7378              CallScrollBarDef                        ; 
2943 7378 48                    pha                            ; space for result
2944 7379 F4 03 00              pushword #getinitvalue         ; get init value
2945 737C A5 3A 48 A5           pushlong theDialog 
2946 7382 A5 36 48              pushword ItemID 
2947 7385 A5 12                 lda   <ScrollBarDef
2948 7387 A6 13                 ldx   <ScrollBarDef+1
2949 7389 22 52 89 FC           jsl   long_call                ; starting value is on stack
2950 738D
2951 738D 48                    pha                            ; space for result
2952 738E F4 01 00              pushword #getinitview          ; get init view
2953 7391 A5 3A 48 A5           pushlong theDialog 
2954 7397 A5 36 48              pushword ItemID 
2955 739A A5 12                 lda   <ScrollBarDef
2956 739C A6 13                 ldx   <ScrollBarDef+1
2957 739E 22 52 89 FC           jsl   long_call                ; view size is on stack
2958 73A2
2959 73A2 48                    pha                            ; space for result
2960 73A3 F4 02 00              pushword #getinittotal         ; get init total
2961 73A6 A5 3A 48 A5           pushlong theDialog 
2962 73AC A5 36 48              pushword ItemID 
2963 73AF A5 12                 lda   <ScrollBarDef
2964 73B1 A6 13                 ldx   <ScrollBarDef+1
2965 73B3 22 52 89 FC           jsl   long_call                ; data size is on stack
2966 73B7
2967 73B7 80 09                 bra   pushotherparms
2968 73B9
2969 73B9              ;
2970 73B9              ; If ScrollBarDef is 0 or negative, put default values in view, total and value
2971 73B9              ;
2972 73B9              DefaultValues  
2973 73B9 A5 2A 48              pushworddp <ItemValue 
2974 73BC F4 0A 00              pushword #10 
2975 73BF F4 2C 01              pushword #300 
2976 73C2
2977 73C2
2978 73C2              pushotherparms                          ; 
2979 73C2 A5 0C 48 A5           pushlong defproc               ; control defproc
2980 73C8 A5 30 48              pushword ItemType              ; Hiword RefCon = ItemType
2981 73CB A5 36 48              pushword ItemID                ; Loword RefCon = ItemID
2982 73CE A5 26 48 A5           pushlong ItemColor 
2983 73D4 A2 10 09 22           _NewControl 
2984 73DB 68 85 00 68           pulllong <ItemControl 
2985 73E1
2986 73E1 A9 00 00              lda   #0
2987 73E4 A6 00                 ldx   <ItemControl
2988 73E6 D0 09                 bne   ItemOk
2989 73E8 A6 02                 ldx   <ItemControl+2
2990 73EA D0 05                 bne   ItemOk
2991 73EC
2992 73EC              badtype                                 ; 
2993 73EC A9 0B 15              lda   #DLGERR+NewItemFailed
2994 73EF 80 48                 bra   ExitNewDItem
2995 73F1
2996 73F1              ItemOk                                  ; 
2997 73F1 A6 08                 ldx   <ItemTypeNum
2998 73F3 E0 0D 00              cpx   #ScrollBarItem
2999 73F6 D0 41                 bne   ExitNewDItem
3000 73F8
3001 73F8              ;
3002 73F8              ; Add a new field to the Scroll Bar Control Record (the ScrollBarDef procedure)
3003 73F8              ;
3004 73F8              ScrollItemOk                            ; 
3005 73F8 F4 00 00 F4           pushlong #ScrollBarSIZE        ; expand the scroll bar record
3006 73FE A5 02 48 A5           pushlong ItemControl 
3007 7404 A2 02 19 22           _SetHandleSize 
3008 740B B0 1D                 bcs   MmgrError                ; error, exit
3009 740D
3010 740D              ;
3011 740D              ; Copy the Scroll Bar description parameter into this field
3012 740D              ;
3013 740D A7 00 85 04           movelong [<ItemControl],0,<ItemPtr   ; get pointer to control
3014 7418 A5 12                 lda   <ScrollBarDef            ; put the scroll bar defproc
3015 741A A0 38 00              ldy   #iScrollBarDef           ; in the additional field.
3016 741D 97 04                 sta   [<ItemPtr],y
3017 741F A5 14                 lda   <ScrollBarDef+2
3018 7421 C8                    iny   
3019 7422 C8                    iny   
3020 7423 97 04                 sta   [<ItemPtr],y
3021 7425
3022 7425 A9 00 00              lda   #0                       ; no error
3023 7428 80 0F                 bra   ExitNewDItem
3024 742A
3025 742A              MmgrError                               ; 
3026 742A 48                    pha                            ; save Mmgr error code
3027 742B A5 02 48 A5           pushlong ItemControl 
3028 7431 A2 10 0A 22           _DisposeControl 
3029 7438 68                    pla   
3030 7439
3031 7439              ExitNewDItem                            ; 
3032 7439 48                    pha                            ; save error code
3033 743A              ;
3034 743A              ; Restore previous port
3035 743A              ;
3036 743A A5 10 48 A5           pushlong PortSave 
3037 7440 A2 04 1B 22           _SetPort 
3038 7447
3039 7447 68                    pla                            ; restore error code
3040 7448
3041 7448 2B A8 A3 23           tunlink 
3042 7460 6B                    rtl   
3043 7461
3044 7461                       ENTRY EmptyString
3045 7461 01           EmptyString DC B:1
3046 7462 20                    DC B:' '
3047 7463
3048 7463                       ENDP 
3049 7463
3050 7463              ;____________________________________________________________________________
3051 7463              ;
3052 7463              ;        SetItemToControl
3053 7463              ;
3054 7463              ;      input:  theControl:LONG
3055 7463              ;              ItemID:WORD
3056 7463              ;
3057 7463              ;    function: Given a control, make it a UserCtlItem
3058 7463              ;____________________________________________________________________________
3059 7463
3060 7463                       ENTRY SetItemToControl
3061 7463              SetItemToControl PROC 
3062 7463
3063 7463              ControlPtr equ   0
3064 7463              SizeLocals equ   ControlPtr+4
3065 7463
3066 7463 3B 38 E9 04           tlink 6,SizeLocals 
3067 746C
3068 746C              ItemID   equ   input
3069 746C              TheControl equ   ItemID+2
3070 746C
3071 746C A7 0C 85 00           movelong [<theControl],0,<ControlPtr 
3072 7477
3073 7477 A9 0E 00              lda   #UserCtlItem
3074 747A A0 22 00              ldy   #iitemtype
3075 747D 97 00                 sta   [<ControlPtr],y
3076 747F
3077 747F A5 0A                 lda   <ItemID
3078 7481 A0 20 00              ldy   #iitemid
3079 7484 97 00                 sta   [<ControlPtr],y
3080 7486
3081 7486 A9 00 00              lda   #0
3082 7489 A2 04 00              ldx   #SizeLocals
3083 748C 4C 8B 89              jmp   quit6
3084 748F
3085 748F                       ENDP 
3086 748F
3087 748F
3088 748F              ;______________________________________________________________________________
3089 748F              ;
3090 748F              ;        RemoveItem
3091 748F              ;
3092 748F              ;       input: theDialog:LONG - pointer to dialog.
3093 748F              ;              ItemID:WORD - ID of item to be removed.
3094 748F              ;
3095 748F              ;      output: none.
3096 748F              ;
3097 748F              ;    function: Erases the given item from the screen and removes it from the
3098 748F              ;              dialog's item list.
3099 748F              ;______________________________________________________________________________
3100 748F
3101 748F                       ENTRY RemoveItem
3102 748F              RemoveItem PROC 
3103 748F
3104 748F              PortSave equ   0
3105 748F              Control  equ   PortSave+4
3106 748F              SizeLocals equ   Control+4
3107 748F
3108 748F 3B 38 E9 08           tlink 6,SizeLocals 
3109 7498
3110 7498              ItemID   equ   input
3111 7498              theDialog equ   ItemID+2
3112 7498
3113 7498              ;
3114 7498              ; Get handle to control item:
3115 7498              ;
3116 7498 48                    pha                            ; space for control handle
3117 7499 48                    pha   
3118 749A A5 12 48 A5           pushlong theDialog 
3119 74A0 A5 0E 48              pushword ItemID 
3120 74A3 A2 15 1E 22           _GetControlDItem 
3121 74AA 90 03 82 95           Check_Error notFound 
3122 74AF 68 85 04 68           pulllong <Control 
3123 74B5
3124 74B5              ;
3125 74B5              ; Set Current port = our dialog
3126 74B5              ;
3127 74B5 48                    pha                            ; space for port pointer
3128 74B6 48                    pha   
3129 74B7 A2 04 1C 22           _GetPort 
3130 74BE 68 85 00 68           pulllong <PortSave 
3131 74C4
3132 74C4 A5 12 48 A5           pushlong theDialog 
3133 74CA A2 04 1B 22           _SetPort 
3134 74D1
3135 74D1 A9 00 00              lda   #0
3136 74D4 48                    pha   
3137 74D5 48                    pha   
3138 74D6 A2 04 23 22           _SetOrigin 
3139 74DD
3140 74DD              ;
3141 74DD              ; If Item to remove is current EditLine item, make the next EditLine item
3142 74DD              ; the current one. If no more EditLine item, set the current one to 0.
3143 74DD              ;
3144 74DD A0 14 01              ldy   #edittextID-wport
3145 74E0 B7 10                 lda   [<theDialog],y
3146 74E2 C5 0E                 cmp   <ItemID
3147 74E4 D0 2F                 bne   DisposeIt
3148 74E6
3149 74E6 A9 00 00              lda   #0                       ; clear it
3150 74E9 97 10                 sta   [<theDialog],y
3151 74EB
3152 74EB 48                    pha                            ; get next EditLine item
3153 74EC A5 12 48 A5           pushlong theDialog 
3154 74F2 A5 06 48 A5           pushlong Control 
3155 74F8 22 19 83 FC           jsl   FindNextEditLine
3156 74FC FA                    plx   
3157 74FD E4 0E                 cpx   <ItemID                  ; if another one, set it the current one
3158 74FF F0 14                 beq   DisposeIt
3159 7501
3160 7501 A5 12 48 A5           pushlong theDialog 
3161 7507 DA                    phx   
3162 7508 F4 00 00              pushword #0 
3163 750B F4 FF 7F              pushword #32767 
3164 750E A2 15 21 22           _SelIText 
3165 7515
3166 7515              DisposeIt                               ; 
3167 7515 A5 06 48 A5           pushlong Control               ; First hide control
3168 751B A2 10 0E 22           _HideControl 
3169 7522
3170 7522 A5 06 48 A5           pushlong Control               ; Dispose of control
3171 7528 A2 10 0A 22           _DisposeControl 
3172 752F
3173 752F 48                    pha                            ; save error code
3174 7530
3175 7530 A5 02 48 A5           pushlong PortSave 
3176 7536 A2 04 1B 22           _SetPort 
3177 753D
3178 753D 68                    pla                            ; restore error code
3179 753E
3180 753E              quickexit                               ; 
3181 753E A2 08 00              ldx   #SizeLocals
3182 7541 4C 8B 89              jmp   quit6
3183 7544
3184 7544              notFound                                ; 
3185 7544 FA                    plx   
3186 7545 FA                    plx   
3187 7546 80 F6                 bra   quickexit
3188 7548                       ENDP 
3189 7548
3190 7548
3191 7548              ;______________________________________________________________________________
3192 7548              ;
3193 7548              ;        GetNewDItem
3194 7548              ;
3195 7548              ;       input: theDialog:LONG - pointer to the dialog port
3196 7548              ;              ItemTemplate:LONG - pointer to the item template
3197 7548              ;
3198 7548              ;      output: none
3199 7548              ;______________________________________________________________________________
3200 7548
3201 7548                       ENTRY GetNewDItem
3202 7548              GetNewDItem PROC 
3203 7548
3204 7548 3B 38 E9 00           tlink 8 
3205 7551
3206 7551              ItemTemplate equ   input
3207 7551              theDialog equ   ItemTemplate+4
3208 7551
3209 7551 A5 0C 48 A5           pushlong theDialog 
3210 7557
3211 7557 A0 00 00              ldy   #ititemID                ; itemID
3212 755A B7 06                 lda   [<ItemTemplate],y
3213 755C 48                    pha   
3214 755D
3215 755D A5 06                 lda   <ItemTemplate            ; itemRect
3216 755F 18                    clc   
3217 7560 69 02 00              adc   #ititemRect
3218 7563 AA                    tax   
3219 7564 A5 08                 lda   <ItemTemplate+2
3220 7566 69 00 00              adc   #0
3221 7569 48                    pha   
3222 756A DA                    phx   
3223 756B
3224 756B A0 0A 00              ldy   #ititemType              ; itemType
3225 756E B7 06                 lda   [<ItemTemplate],y
3226 7570 48                    pha   
3227 7571
3228 7571 A0 0E 00 B7           pushlong [<ItemTemplate],ititemDescr   ; itemDescr
3229 757D
3230 757D A0 10 00              ldy   #ititemValue             ; itemValue
3231 7580 B7 06                 lda   [<ItemTemplate],y
3232 7582 48                    pha   
3233 7583
3234 7583 C8                    iny                            ; itemFlag
3235 7584 C8                    iny   
3236 7585 B7 06                 lda   [<ItemTemplate],y
3237 7587 48                    pha   
3238 7588
3239 7588 A0 16 00 B7           pushlong [<ItemTemplate],ititemColor   ; itemColor
3240 7594
3241 7594 A2 15 0D 22           _NewDItem 
3242 759B
3243 759B A2 00 00              ldx   #0
3244 759E 4C A2 89              jmp   quit8
3245 75A1
3246 75A1                       ENDP 
3247 75A1              ;            copy  GetItem.asm
3248 75A1              ; GetItem.asm                           Jean-Charles Mourey
3249 75A1
3250 75A1                       TITLE 'Get and Set Item Procedures'
3251 75A1
3252 75A1              ;_____________________________________________________________________________
3253 75A1              ;
3254 75A1              ;        GetControlDItem
3255 75A1              ;
3256 75A1              ;       input: theDialog:LONG - pointer to the dialog port.
3257 75A1              ;              itemID:WORD - ID number uniquely identifying the item.
3258 75A1              ;
3259 75A1              ;      output: item:LONG - controlhandle to the item.
3260 75A1              ;
3261 75A1              ;    function: given an item number in a dialog, returns the control handle
3262 75A1              ;              to this item.
3263 75A1              ;______________________________________________________________________________
3264 75A1
3265 75A1                       ENTRY GetControlDItem
3266 75A1              GetControlDItem PROC 
3267 75A1
3268 75A1              CurItemHdl equ   0
3269 75A1              CurItemPtr equ   CurItemHdl+4
3270 75A1              CurID    equ   CurItemPtr+4
3271 75A1              SizeLocals equ   CurID+2
3272 75A1
3273 75A1 3B 38 E9 0A           tlink 6,SizeLocals 
3274 75AA
3275 75AA              ItemID   equ   input
3276 75AA              theDialog equ   ItemID+2
3277 75AA
3278 75AA              item     equ   output
3279 75AA
3280 75AA
3281 75AA              ;
3282 75AA              ; Initializes item to NIL
3283 75AA              ;
3284 75AA 64 16                 stz   <item
3285 75AC 64 18                 stz   <item+2
3286 75AE
3287 75AE              ;
3288 75AE              ; Get First Item from Control List
3289 75AE              ;
3290 75AE A0 C6 00 B7           movelong [<theDialog],wcontrol-wport,<CurItemHdl 
3291 75BC
3292 75BC              ;
3293 75BC              ; if CurItem is NIL, exit
3294 75BC              ;
3295 75BC              NextItem                                ; 
3296 75BC A5 00                 lda   <CurItemHdl
3297 75BE D0 09                 bne   TestCurItem
3298 75C0 A5 02                 lda   <CurItemHdl+2
3299 75C2 D0 05                 bne   TestCurItem
3300 75C4 A9 0C 15              lda   #DLGERR+ItemNotFound
3301 75C7 80 2C                 bra   exit
3302 75C9              ;
3303 75C9              ; Read ID of current item, and compare it to the given ID
3304 75C9              ;
3305 75C9              TestCurItem                             ; 
3306 75C9
3307 75C9 A7 00 85 04           movelong [<CurItemHdl],0,<CurItemPtr   ; get pointer to item
3308 75D4
3309 75D4 A0 20 00              ldy   #iitemid                 ; get item ID
3310 75D7 B7 04                 lda   [<CurItemPtr],y
3311 75D9 C5 10                 cmp   <ItemID                  ; compare it to given ID
3312 75DB F0 0D                 beq   found                    ; found it
3313 75DD
3314 75DD A7 04 85 00           movelong [<CurItemPtr],0,<CurItemHdl   ; get next item handle
3315 75E8 80 D2                 bra   NextItem
3316 75EA
3317 75EA              found                                   ; 
3318 75EA A5 00 85 16           movelong <CurItemHdl,<item 
3319 75F2
3320 75F2 A9 00 00              lda   #0
3321 75F5
3322 75F5              exit                                    ; 
3323 75F5 A2 0A 00              ldx   #SizeLocals
3324 75F8 4C 8B 89              jmp   quit6
3325 75FB
3326 75FB                       ENDP 
3327 75FB
3328 75FB
3329 75FB              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
3330 75FB              ;
3331 75FB              ;        GetItemWORD
3332 75FB              ;
3333 75FB              ;       input: theDialog:LONG
3334 75FB              ;              itemID:WORD
3335 75FB              ;              Y register = which field in Control Record (offset)
3336 75FB              ;
3337 75FB              ;      output: itemResult:WORD returns content of field (size = WORD)
3338 75FB              ;
3339 75FB              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
3340 75FB
3341 75FB                       ENTRY GetItemWORD
3342 75FB              GetItemWORD PROC 
3343 75FB
3344 75FB              Control  equ   0
3345 75FB              ControlPtr equ   Control+4
3346 75FB              SizeLocals equ   ControlPtr+4
3347 75FB
3348 75FB 3B 38 E9 08           tlink 6,SizeLocals 
3349 7604
3350 7604              itemID   equ   input
3351 7604              theDialog equ   itemID+2
3352 7604
3353 7604              itemResult equ   output
3354 7604
3355 7604 5A                    phy                            ; save field offset
3356 7605
3357 7605 48                    pha                            ; space for control handle
3358 7606 48                    pha   
3359 7607 A5 12 48 A5           pushlong theDialog 
3360 760D A5 0E 48              pushword itemID 
3361 7610 A2 15 1E 22           _GetControlDItem 
3362 7617 B0 1F                 bcs   notFound
3363 7619 68 85 00 68           pulllong <Control 
3364 761F
3365 761F A7 00 85 04           movelong [<Control],0,<ControlPtr 
3366 762A
3367 762A 7A                    ply                            ; restore field offset
3368 762B
3369 762B B7 04                 lda   [<ControlPtr],y
3370 762D 85 14                 sta   <itemResult
3371 762F
3372 762F A9 00 00              lda   #0
3373 7632              exit                                    ; 
3374 7632 A2 08 00              ldx   #SizeLocals
3375 7635 4C 8B 89              jmp   quit6
3376 7638
3377 7638              notFound                                ; 
3378 7638 FA                    plx   
3379 7639 FA                    plx   
3380 763A FA                    plx                            ; get field offset off stack, 5/16/88 HY
3381 763B 80 F5                 bra   exit
3382 763D
3383 763D                       ENDP 
3384 763D
3385 763D
3386 763D              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
3387 763D              ;
3388 763D              ;        SetItemWORD
3389 763D              ;
3390 763D              ;       input: itemWORD:WORD            word value to set field to in Control
3391 763D              ;              theDialog:LONG
3392 763D              ;              itemID:WORD
3393 763D              ;              Y register = field offset in Control record
3394 763D              ;
3395 763D              ;      output: none
3396 763D              ;
3397 763D              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
3398 763D
3399 763D                       ENTRY SetItemWORD
3400 763D              SetItemWORD PROC 
3401 763D
3402 763D              Control  equ   0
3403 763D              ControlPtr equ   Control+4
3404 763D              SizeLocals equ   ControlPtr+4
3405 763D
3406 763D 3B 38 E9 08           tlink 8,SizeLocals 
3407 7646
3408 7646              itemID   equ   input
3409 7646              theDialog equ   itemID+2
3410 7646              itemWORD equ   theDialog+4
3411 7646
3412 7646 5A                    phy                            ; save field offset
3413 7647
3414 7647 48                    pha                            ; space for control record
3415 7648 48                    pha   
3416 7649 A5 12 48 A5           pushlong theDialog 
3417 764F A5 0E 48              pushword itemID 
3418 7652 A2 15 1E 22           _GetControlDItem 
3419 7659 B0 1F                 bcs   notFound
3420 765B 68 85 00 68           pulllong <Control 
3421 7661
3422 7661 A7 00 85 04           movelong [<Control],0,<ControlPtr 
3423 766C
3424 766C 7A                    ply                            ; restore field offset
3425 766D
3426 766D A5 14                 lda   <itemWORD
3427 766F 97 04                 sta   [<ControlPtr],y
3428 7671
3429 7671 A9 00 00              lda   #0
3430 7674              exit                                    ; 
3431 7674 A2 08 00              ldx   #SizeLocals
3432 7677 4C A2 89              jmp   quit8
3433 767A
3434 767A              notFound                                ; 
3435 767A FA                    plx   
3436 767B FA                    plx   
3437 767C FA                    plx                            ; get field offset off stack, 5/16/88 HY
3438 767D 80 F5                 bra   exit
3439 767F
3440 767F                       ENDP 
3441 767F
3442 767F
3443 767F              ;_____________________________________________________________________________
3444 767F              ;
3445 767F              ;        GetItemType
3446 767F              ;
3447 767F              ;       input: theDialog:LONG
3448 767F              ;              itemID:WORD
3449 767F              ;
3450 767F              ;      output: itemType:WORD - including disable bit
3451 767F              ;______________________________________________________________________________
3452 767F
3453 767F                       ENTRY GetItemType
3454 767F              GetItemType PROC 
3455 767F
3456 767F A0 22 00              ldy   #iitemtype
3457 7682 4C FB 75              jmp   GetItemWORD
3458 7685
3459 7685                       ENDP 
3460 7685
3461 7685
3462 7685              ;_____________________________________________________________________________
3463 7685              ;
3464 7685              ;        SetItemType
3465 7685              ;
3466 7685              ;       input: itemType:WORD - including disable bit
3467 7685              ;              theDialog:LONG
3468 7685              ;              itemID:WORD
3469 7685              ;
3470 7685              ;      output: none
3471 7685              ;______________________________________________________________________________
3472 7685
3473 7685                       ENTRY SetItemType
3474 7685              SetItemType PROC 
3475 7685
3476 7685 A0 22 00              ldy   #iitemtype
3477 7688 4C 3D 76              jmp   SetItemWORD
3478 768B
3479 768B                       ENDP 
3480 768B
3481 768B
3482 768B              ;_____________________________________________________________________________
3483 768B              ;
3484 768B              ;        GetItemBox
3485 768B              ;
3486 768B              ;       input: theDialog:LONG
3487 768B              ;              itemID:WORD
3488 768B              ;              itemBox:LONG - pointer to space to store the enclos. rectangle in
3489 768B              ;
3490 768B              ;      output: none
3491 768B              ;______________________________________________________________________________
3492 768B
3493 768B                       ENTRY GetItemBox
3494 768B              GetItemBox PROC 
3495 768B
3496 768B              Control  equ   0
3497 768B              ControlPtr equ   Control+4
3498 768B              SizeLocals equ   ControlPtr+4
3499 768B
3500 768B 3B 38 E9 08           tlink 10,SizeLocals 
3501 7694
3502 7694              itemBox  equ   input
3503 7694              itemID   equ   itemBox+4
3504 7694              theDialog equ   itemID+2
3505 7694
3506 7694 48                    pha                            ; space for control record
3507 7695 48                    pha   
3508 7696 A5 16 48 A5           pushlong theDialog 
3509 769C A5 12 48              pushword itemID 
3510 769F A2 15 1E 22           _GetControlDItem 
3511 76A6 B0 3F                 bcs   notFound
3512 76A8 68 85 00 68           pulllong <Control 
3513 76AE
3514 76AE A7 00 85 04           movelong [<Control],0,<ControlPtr 
3515 76B9
3516 76B9 A0 08 00              ldy   #CtrlRect
3517 76BC B7 04                 lda   [<ControlPtr],y
3518 76BE 87 0E                 sta   [<itemBox]
3519 76C0
3520 76C0 A0 0A 00              ldy   #CtrlRect+2
3521 76C3 B7 04                 lda   [<ControlPtr],y
3522 76C5 A0 02 00              ldy   #2
3523 76C8 97 0E                 sta   [<itemBox],y
3524 76CA
3525 76CA A0 0C 00              ldy   #CtrlRect+4
3526 76CD B7 04                 lda   [<ControlPtr],y
3527 76CF A0 04 00              ldy   #4
3528 76D2 97 0E                 sta   [<itemBox],y
3529 76D4
3530 76D4 A0 0E 00              ldy   #CtrlRect+6
3531 76D7 B7 04                 lda   [<ControlPtr],y
3532 76D9 A0 06 00              ldy   #6
3533 76DC 97 0E                 sta   [<itemBox],y
3534 76DE
3535 76DE A9 00 00              lda   #0
3536 76E1              exit                                    ; 
3537 76E1 A2 08 00              ldx   #SizeLocals
3538 76E4 4C BA 89              jmp   quit10
3539 76E7
3540 76E7              notFound                                ; 
3541 76E7 FA                    plx   
3542 76E8 FA                    plx   
3543 76E9 80 F6                 bra   exit
3544 76EB
3545 76EB                       ENDP 
3546 76EB
3547 76EB
3548 76EB              ;_____________________________________________________________________________
3549 76EB              ;
3550 76EB              ;        SetItemBox
3551 76EB              ;
3552 76EB              ;       input: theDialog:LONG
3553 76EB              ;              itemID:WORD
3554 76EB              ;              itemBox:LONG - pointer to the enclosing rectangle
3555 76EB              ;
3556 76EB              ;      output: none
3557 76EB              ;______________________________________________________________________________
3558 76EB
3559 76EB                       ENTRY SetItemBox
3560 76EB              SetItemBox PROC 
3561 76EB
3562 76EB              Control  equ   0
3563 76EB              ControlPtr equ   Control+4
3564 76EB              SizeLocals equ   ControlPtr+4
3565 76EB
3566 76EB 3B 38 E9 08           tlink 10,SizeLocals 
3567 76F4
3568 76F4              itemBox  equ   input
3569 76F4              itemID   equ   itemBox+4
3570 76F4              theDialog equ   itemID+2
3571 76F4
3572 76F4 48                    pha                            ; space for control handle
3573 76F5 48                    pha   
3574 76F6 A5 16 48 A5           pushlong theDialog 
3575 76FC A5 12 48              pushword itemID 
3576 76FF A2 15 1E 22           _GetControlDItem 
3577 7706 B0 59                 bcs   notFound
3578 7708 68 85 00 68           pulllong <Control 
3579 770E
3580 770E              ;
3581 770E              ; Hide control from previous location
3582 770E              ;
3583 770E A5 02 48 A5           pushlong Control 
3584 7714 A2 10 0E 22           _HideControl 
3585 771B
3586 771B              ;
3587 771B              ; Change item rectangle to new rectangle
3588 771B              ;
3589 771B A7 00 85 04           movelong [<Control],0,<ControlPtr 
3590 7726
3591 7726 A7 0E                 lda   [<itemBox]
3592 7728 A0 08 00              ldy   #CtrlRect
3593 772B 97 04                 sta   [<ControlPtr],y
3594 772D
3595 772D A0 02 00              ldy   #2
3596 7730 B7 0E                 lda   [<itemBox],y
3597 7732 A0 0A 00              ldy   #CtrlRect+2
3598 7735 97 04                 sta   [<ControlPtr],y
3599 7737
3600 7737 A0 04 00              ldy   #4
3601 773A B7 0E                 lda   [<itemBox],y
3602 773C A0 0C 00              ldy   #CtrlRect+4
3603 773F 97 04                 sta   [<ControlPtr],y
3604 7741
3605 7741 A0 06 00              ldy   #6
3606 7744 B7 0E                 lda   [<itemBox],y
3607 7746 A0 0E 00              ldy   #CtrlRect+6
3608 7749 97 04                 sta   [<ControlPtr],y
3609 774B
3610 774B              ;
3611 774B              ; Redraws control at new location
3612 774B              ;
3613 774B A5 02 48 A5           pushlong Control 
3614 7751 A2 10 0F 22           _ShowControl 
3615 7758
3616 7758              ;
3617 7758              ; Returns no error (never fails!)
3618 7758              ;
3619 7758 A9 00 00              lda   #0
3620 775B              exit                                    ; 
3621 775B A2 08 00              ldx   #SizeLocals
3622 775E 4C BA 89              jmp   quit10
3623 7761
3624 7761              notFound                                ; 
3625 7761 FA                    plx   
3626 7762 FA                    plx   
3627 7763 80 F6                 bra   exit
3628 7765
3629 7765                       ENDP 
3630 7765
3631 7765              ;_____________________________________________________________________________
3632 7765              ;
3633 7765              ;        GetFirstItem
3634 7765              ;
3635 7765              ;       input: theDialog:LONG
3636 7765              ;
3637 7765              ;      output: firstItem:WORD - ID of first item, zero if no item in dialog
3638 7765              ;______________________________________________________________________________
3639 7765
3640 7765                       ENTRY GetFirstItem
3641 7765              GetFirstItem PROC 
3642 7765
3643 7765              Control  equ   0
3644 7765              ControlPtr equ   Control+4
3645 7765              SizeLocals equ   ControlPtr+4
3646 7765
3647 7765 3B 38 E9 08           tlink 4,SizeLocals 
3648 776E
3649 776E              theDialog equ   input
3650 776E
3651 776E              firstItem equ   output
3652 776E
3653 776E
3654 776E A0 C6 00 B7           movelong [<theDialog],wcontrol-wport,<Control  ; get first control
3655 777C
3656 777C A5 00                 lda   <Control
3657 777E D0 0B                 bne   notempty
3658 7780 A5 02                 lda   <Control+2
3659 7782 D0 07                 bne   notempty
3660 7784
3661 7784 64 12                 stz   <firstItem
3662 7786 A9 0C 15              lda   #DLGERR+ItemNotFound
3663 7789 80 15                 bra   exit
3664 778B
3665 778B              notempty                                ; 
3666 778B A7 00 85 04           movelong [<Control],0,<ControlPtr  ; Get its ID
3667 7796 A0 20 00 B7           moveword [<ControlPtr],iitemID,<firstItem 
3668 779D
3669 779D A9 00 00              lda   #0
3670 77A0              exit                                    ; 
3671 77A0 A2 08 00              ldx   #SizeLocals
3672 77A3 4C 75 89              jmp   quit4
3673 77A6
3674 77A6                       ENDP 
3675 77A6
3676 77A6              ;_____________________________________________________________________________
3677 77A6              ;
3678 77A6              ;        GetNextItem
3679 77A6              ;
3680 77A6              ;       input: theDialog:LONG
3681 77A6              ;              itemID:WORD - ID of current item
3682 77A6              ;
3683 77A6              ;      output: nextItem:WORD - ID of next item, zero if last item
3684 77A6              ;______________________________________________________________________________
3685 77A6
3686 77A6                       ENTRY GetNextItem
3687 77A6              GetNextItem PROC 
3688 77A6
3689 77A6              Control  equ   0
3690 77A6              ControlPtr equ   Control+4
3691 77A6              SizeLocals equ   ControlPtr+4
3692 77A6
3693 77A6 3B 38 E9 08           tlink 6,SizeLocals 
3694 77AF
3695 77AF              itemID   equ   input
3696 77AF              theDialog equ   itemID+2
3697 77AF
3698 77AF              nextItem equ   output
3699 77AF
3700 77AF 48                    pha                            ; space for control handle
3701 77B0 48                    pha   
3702 77B1 A5 12 48 A5           pushlong theDialog 
3703 77B7 A5 0E 48              pushword itemID 
3704 77BA A2 15 1E 22           _GetControlDItem 
3705 77C1 B0 3F                 bcs   notFound
3706 77C3 68 85 00 68           pulllong <Control 
3707 77C9
3708 77C9 A7 00 85 04           movelong [<Control],0,<ControlPtr   ; dereference control 
3709 77D4
3710 77D4 A7 04 85 00           movelong [<ControlPtr],0,<Control   ; get next handle of next control
3711 77DF
3712 77DF A5 01                 lda   <Control+1               ; check if this handle is valid
3713 77E1 D0 04                 bne   notLastControl           ; if zero than last control in list
3714 77E3 85 14                 sta   <nextItem                ; return result of zero for no more items in list
3715 77E5 80 12                 bra   exit1
3716 77E7
3717 77E7 A7 00 85 04  notLastControl movelong [<Control],0,<ControlPtr   ; deref the control of item we want
3718 77F2
3719 77F2 A0 20 00 B7           moveword [<ControlPtr],iitemID,<nextItem   ; return id of control
3720 77F9
3721 77F9 A9 00 00     exit1    lda   #0
3722 77FC              exit2                                   ; 
3723 77FC A2 08 00              ldx   #SizeLocals
3724 77FF 4C 8B 89              jmp   quit6
3725 7802
3726 7802              notFound                                ; 
3727 7802 64 14                 stz   <nextItem                ; no other item in list
3728 7804 FA                    plx   
3729 7805 FA                    plx   
3730 7806 80 F4                 bra   exit2
3731 7808
3732 7808                       ENDP 
3733 7808
3734 7808
3735 7808              ;_____________________________________________________________________________
3736 7808              ;
3737 7808              ;        GetItemFlag
3738 7808              ;
3739 7808              ;       input: theDialog:LONG
3740 7808              ;              itemID:WORD
3741 7808              ;
3742 7808              ;      output: itemFlag:WORD - Flag of item in lo byte
3743 7808              ;______________________________________________________________________________
3744 7808
3745 7808              ;GetItemFlag START
3746 7808              ;         using ctrlstruct
3747 7808              ;         using dialogstruct
3748 7808              ;
3749 7808              ;Control        equ    0
3750 7808              ;ControlPtr     equ    Control+4
3751 7808              ;SizeLocals     equ    ControlPtr+4
3752 7808              ;
3753 7808              ;         tlink  8,SizeLocals
3754 7808              ;
3755 7808              ;itemID         equ    input
3756 7808              ;theDialog      equ    itemID+2
3757 7808              ;
3758 7808              ;itemFlag       equ    output
3759 7808              ;
3760 7808              ;         pha                                   ; space for control handle
3761 7808              ;         pha
3762 7808              ;         pushlong theDialog
3763 7808              ;         pushword itemID
3764 7808              ;         _GetControlDItem
3765 7808              ;         bcs   notFound
3766 7808              ;         pulllong <Control
3767 7808              ;
3768 7808              ;         movelong [<Control],0,<ControlPtr
3769 7808              ;       
3770 7808              ;         ldy   #CtrlFlag
3771 7808              ;         lda   [<ControlPtr],y
3772 7808              ;         and   #$FF                            ; get CtrlFlag byte
3773 7808              ;         sta   <itemFlag
3774 7808              ;
3775 7808              ;         lda   #0
3776 7808              ;exit     anop
3777 7808              ;         ldx   #SizeLocals
3778 7808              ;         jmp   quit8
3779 7808              ;
3780 7808              ;notFound anop
3781 7808              ;         plx
3782 7808              ;         plx
3783 7808              ;         bra   exit
3784 7808              ;
3785 7808              ;         END
3786 7808              ;
3787 7808              ;
3788 7808              ;_____________________________________________________________________________
3789 7808              ;
3790 7808              ;        SetItemFlag
3791 7808              ;
3792 7808              ;       input: itemFlag:WORD - new flag for item
3793 7808              ;              theDialog:LONG
3794 7808              ;              itemID:WORD
3795 7808              ;
3796 7808              ;      output: none
3797 7808              ;______________________________________________________________________________
3798 7808
3799 7808              ;SetItemFlag START
3800 7808              ;         using ctrlstruct
3801 7808              ;         using dialogstruct
3802 7808              ;
3803 7808              ;Control        equ    0
3804 7808              ;ControlPtr     equ    Control+4
3805 7808              ;SizeLocals     equ    ControlPtr+4
3806 7808              ;
3807 7808              ;         tlink  10,SizeLocals
3808 7808              ;
3809 7808              ;itemID         equ    input
3810 7808              ;theDialog      equ    itemID+2
3811 7808              ;itemFlag       equ    theDialog+4
3812 7808              ;
3813 7808              ;         pha                                   ; space for control handle
3814 7808              ;         pha
3815 7808              ;         pushlong theDialog
3816 7808              ;         pushword itemID
3817 7808              ;         _GetControlDItem
3818 7808              ;         bcs   notFound
3819 7808              ;         pulllong <Control
3820 7808              ;
3821 7808              ;         movelong [<Control],0,<ControlPtr
3822 7808              ;       
3823 7808              ;         ldy   #CtrlFlag
3824 7808              ;         lda   [<ControlPtr],y
3825 7808              ;         and   #$FF00                          ; preserves CtrlHilite byte
3826 7808              ;         ora   <itemFlag
3827 7808              ;         sta   [<ControlPtr],y
3828 7808              ;
3829 7808              ;         lda   #0
3830 7808              ;exit     anop
3831 7808              ;         ldx   #SizeLocals
3832 7808              ;         jmp   quit10
3833 7808              ;
3834 7808              ;notFound anop
3835 7808              ;         plx
3836 7808              ;         plx
3837 7808              ;         bra   exit
3838 7808              ;
3839 7808              ;         END
3840 7808              ;
3841 7808
3842 7808              ;_____________________________________________________________________________
3843 7808              ;
3844 7808              ;        GetItemValue  (in ToolBox Ref. call is GetDItemValue)
3845 7808              ;
3846 7808              ;       input: theDialog:LONG
3847 7808              ;              itemID:WORD
3848 7808              ;
3849 7808              ;      output: itemValue:WORD - Value of item
3850 7808              ;______________________________________________________________________________
3851 7808
3852 7808                       ENTRY GetItemValue
3853 7808              GetItemValue PROC 
3854 7808
3855 7808 3B 38 E9 00           tlink 6 
3856 7811
3857 7811              itemID   equ   input
3858 7811              theDialog equ   itemID+2
3859 7811
3860 7811              itemValue equ   output
3861 7811
3862 7811              ;
3863 7811              ; push space for GetCtlValue result
3864 7811              ;
3865 7811 48                    pha   
3866 7812
3867 7812              ;
3868 7812              ; Get Control Handle to item
3869 7812              ;
3870 7812 48                    pha                            ; space for control handle
3871 7813 48                    pha   
3872 7814 A5 0A 48 A5           pushlong theDialog 
3873 781A A5 06 48              pushword itemID 
3874 781D A2 15 1E 22           _GetControlDItem               ; control handle is on stack
3875 7824 B0 13                 bcs   notFound
3876 7826
3877 7826              ;
3878 7826              ; Get Control Value
3879 7826              ;
3880 7826 A2 10 1A 22           _GetCtlValue 
3881 782D 68 85 0C              pullword <itemValue 
3882 7830
3883 7830 A9 00 00              lda   #0
3884 7833              exit                                    ; 
3885 7833 A2 00 00              ldx   #0
3886 7836 4C 8B 89              jmp   quit6
3887 7839
3888 7839              notFound                                ;
3889 7839 FA                    plx                            ; get handle off stack from _GetControlDItem call 
3890 783A FA                    plx   
3891 783B FA                    plx                            ; pull extra word on stack initially put on stack for
3892 783C                                                      ; _GetCtlValue call (5/2/88 HY)
3893 783C 80 F5                 bra   exit
3894 783E
3895 783E                       ENDP 
3896 783E
3897 783E
3898 783E              ;_____________________________________________________________________________
3899 783E              ;
3900 783E              ;        SetItemValue
3901 783E              ;
3902 783E              ;       input: itemValue:WORD - new value for item
3903 783E              ;              theDialog:LONG
3904 783E              ;              itemID:WORD
3905 783E              ;
3906 783E              ;      output: none
3907 783E              ;______________________________________________________________________________
3908 783E
3909 783E                       ENTRY SetItemValue
3910 783E              SetItemValue PROC 
3911 783E
3912 783E              Control  equ   0
3913 783E              ControlPtr equ   Control+4
3914 783E              SizeLocals equ   ControlPtr+4
3915 783E
3916 783E 3B 38 E9 08           tlink 8,SizeLocals 
3917 7847
3918 7847              itemID   equ   input
3919 7847              theDialog equ   itemID+2
3920 7847              itemValue equ   theDialog+4
3921 7847
3922 7847 A5 14 48              pushword itemValue             ; push value for SetCtlValue
3923 784A
3924 784A 48                    pha                            ; space for control handle
3925 784B 48                    pha   
3926 784C A5 12 48 A5           pushlong theDialog 
3927 7852 A5 0E 48              pushword itemID 
3928 7855 A2 15 1E 22           _GetControlDItem               ; control handle is on stack
3929 785C B0 15                 bcs   notFound
3930 785E
3931 785E A3 01                 lda   1,s                      ; get control value but does not
3932 7860 85 00                 sta   <Control                 ; pull it from stack
3933 7862 A3 03                 lda   3,s
3934 7864 85 02                 sta   <Control+2
3935 7866
3936 7866 A2 10 19 22           _SetCtlValue                   ; redraws control (if value changed)
3937 786D
3938 786D              exit                                    ;	        ; returns SetCtlValue error
3939 786D A2 08 00              ldx   #SizeLocals
3940 7870 4C A2 89              jmp   quit8
3941 7873
3942 7873              notFound                                ; 
3943 7873 FA                    plx   
3944 7874 FA                    plx   
3945 7875 FA                    plx                            ; get value for SetCtlValue off stack
3946 7876 80 F5                 bra   exit
3947 7878
3948 7878                       ENDP 
3949 7878
3950 7878
3951 7878              ;_____________________________________________________________________________
3952 7878              ;
3953 7878              ;        GetItemColor
3954 7878              ;
3955 7878              ;       input: theDialog:LONG
3956 7878              ;              itemID:WORD
3957 7878              ;
3958 7878              ;      output: itemColor:LONG - pointer to color table
3959 7878              ;______________________________________________________________________________
3960 7878
3961 7878              ;GetItemColor START
3962 7878              ;         using ctrlstruct
3963 7878              ;         using dialogstruct
3964 7878              ;
3965 7878              ;Control        equ    0
3966 7878              ;ControlPtr     equ    Control+4
3967 7878              ;SizeLocals     equ    ControlPtr+4
3968 7878              ;
3969 7878              ;         tlink 6,SizeLocals
3970 7878              ;
3971 7878              ;itemID         equ    input
3972 7878              ;theDialog      equ    itemID+2
3973 7878              ;
3974 7878              ;itemColor      equ    output
3975 7878              ;
3976 7878              ;         pha                            ; space for control handle
3977 7878              ;         pha
3978 7878              ;         pushlong theDialog
3979 7878              ;         pushword itemID
3980 7878              ;         _GetControlDItem
3981 7878              ;         bcs   notFound
3982 7878              ;         pulllong <Control
3983 7878              ;
3984 7878              ;         movelong [<Control],0,<ControlPtr
3985 7878              ;
3986 7878              ;         movelong [<ControlPtr],CtrlColor,<itemColor
3987 7878              ;
3988 7878              ;         lda   #0
3989 7878              ;exit     anop
3990 7878              ;         ldx   #SizeLocals
3991 7878              ;         jmp   quit6
3992 7878              ;
3993 7878              ;notFound anop
3994 7878              ;         plx
3995 7878              ;         plx
3996 7878              ;         bra   exit
3997 7878              ;
3998 7878              ;         END
3999 7878              ;
4000 7878
4001 7878              ;_____________________________________________________________________________
4002 7878              ;
4003 7878              ;        SetItemColor
4004 7878              ;
4005 7878              ;       input: itemColor:LONG - pointer to new color table
4006 7878              ;              theDialog:LONG
4007 7878              ;              itemID:WORD
4008 7878              ;
4009 7878              ;      output: none
4010 7878              ;______________________________________________________________________________
4011 7878
4012 7878              ;SetItemColor START
4013 7878              ;         using ctrlstruct
4014 7878              ;         using dialogstruct
4015 7878              ;
4016 7878              ;Control        equ    0
4017 7878              ;ControlPtr     equ    Control+4
4018 7878              ;SizeLocals     equ    ControlPtr+4
4019 7878              ;
4020 7878              ;         tlink 10,SizeLocals
4021 7878              ;
4022 7878              ;itemID         equ    input
4023 7878              ;theDialog      equ    itemID+2
4024 7878              ;itemColor      equ    theDialog+4
4025 7878              ;
4026 7878              ;         pha                            ; space for control handle
4027 7878              ;         pha
4028 7878              ;         pushlong theDialog
4029 7878              ;         pushword itemID
4030 7878              ;         _GetControlDItem
4031 7878              ;         bcs   notFound
4032 7878              ;         pulllong <Control
4033 7878              ;
4034 7878              ;         movelong [<Control],0,<ControlPtr
4035 7878              ;
4036 7878              ;         lda   <itemColor
4037 7878              ;         ldy   #CtrlColor
4038 7878              ;         sta   [<ControlPtr],y
4039 7878              ;
4040 7878              ;         lda   <itemColor+2
4041 7878              ;         ldy   #CtrlColor+2
4042 7878              ;         sta   [<ControlPtr],y
4043 7878              ;
4044 7878              ;         lda   #0
4045 7878              ;exit     anop
4046 7878              ;         ldx   #SizeLocals
4047 7878              ;         jmp   quit10
4048 7878              ;
4049 7878              ;notFound anop
4050 7878              ;         plx
4051 7878              ;         plx
4052 7878              ;         bra   exit
4053 7878              ;
4054 7878              ;         END
4055 7878
4056 7878
4057 7878              ;______________________________________________________________________________
4058 7878              ;
4059 7878              ;        GetDefButton
4060 7878              ;
4061 7878              ;       input: theDialog:LONG - pointer to the dialog port
4062 7878              ;
4063 7878              ;      output: DefBut:WORD - ID of default button
4064 7878              ;______________________________________________________________________________
4065 7878
4066 7878                       ENTRY GetDefButton
4067 7878              GetDefButton PROC 
4068 7878
4069 7878 3B 38 E9 00           tlink 4 
4070 7881
4071 7881              theDialog equ   input
4072 7881
4073 7881              DefBut   equ   output
4074 7881
4075 7881 A0 16 01              ldy   #defbutID-wport
4076 7884 B7 06                 lda   [<theDialog],y
4077 7886 85 0A                 sta   <DefBut
4078 7888
4079 7888 A9 00 00              lda   #0
4080 788B A2 00 00              ldx   #0                       ; no locals
4081 788E 4C 75 89              jmp   quit4
4082 7891
4083 7891                       ENDP 
4084 7891
4085 7891
4086 7891              ;______________________________________________________________________________
4087 7891              ;
4088 7891              ;        SetDefButton
4089 7891              ;
4090 7891              ;       input: DefBut:WORD - ID of new default button
4091 7891              ;              theDialog:LONG - pointer to the dialog port
4092 7891              ;
4093 7891              ;      output: none
4094 7891              ;______________________________________________________________________________
4095 7891
4096 7891                       ENTRY SetDefButton
4097 7891              SetDefButton PROC 
4098 7891
4099 7891              OldControl equ   0                      ; old default button
4100 7891              Control  equ   OldControl+4             ; new default button
4101 7891              ControlPtr equ   Control+4
4102 7891              SizeLocals equ   ControlPtr+4
4103 7891
4104 7891 3B 38 E9 0C           tlink 6,SizeLocals 
4105 789A
4106 789A              theDialog equ   input
4107 789A              DefBut   equ   theDialog+4
4108 789A
4109 789A              ;
4110 789A              ; If there is a current default button, remove the thick-outline
4111 789A              ;
4112 789A
4113 789A              ;
4114 789A              ; Get the old default button control
4115 789A              ;
4116 789A 48                    pha                            ; space for control handle
4117 789B 48                    pha   
4118 789C A5 14 48 A5           pushlong theDialog 
4119 78A2 A0 16 01              ldy   #defbutID-wport
4120 78A5 B7 12                 lda   [<theDialog],y
4121 78A7 48                    pha   
4122 78A8 A2 15 1E 22           _GetControlDItem 
4123 78AF 68 85 00 68           pulllong <OldControl 
4124 78B5
4125 78B5              ;
4126 78B5              ; Get the new default button control. If doesn't exist, exit directly
4127 78B5              ;
4128 78B5 48                    pha                            ; space for control handle
4129 78B6 48                    pha   
4130 78B7 A5 14 48 A5           pushlong theDialog 
4131 78BD A5 16 48              pushword DefBut 
4132 78C0 A2 15 1E 22           _GetControlDItem 
4133 78C7 90 03 82 7E           Check_Error notFound 
4134 78CC 68 85 04 68           pulllong <Control 
4135 78D2
4136 78D2 A5 00                 lda   <OldControl
4137 78D4 D0 04                 bne   RemoveThick
4138 78D6 A5 02                 lda   <OldControl+2
4139 78D8 F0 2F                 beq   SetNewDefault
4140 78DA
4141 78DA              RemoveThick                             ; 
4142 78DA A7 00 85 08           movelong [<OldControl],0,<ControlPtr 
4143 78E5 A0 10 00              ldy   #CtrlFlag
4144 78E8 B7 08                 lda   [<ControlPtr],y
4145 78EA 29 FE FF              and   #NO_BOLD_BUTT            ; NO_BOLD_BUTT = not BOLD_BUTT
4146 78ED 97 08                 sta   [<ControlPtr],y
4147 78EF
4148 78EF              ;
4149 78EF              ; Redraws the control
4150 78EF              ;
4151 78EF A5 02 48 A5           pushlong OldControl 
4152 78F5 A2 10 0E 22           _HideControl 
4153 78FC
4154 78FC A5 02 48 A5           pushlong OldControl 
4155 7902 A2 10 0F 22           _ShowControl 
4156 7909
4157 7909              ;
4158 7909              ; Set new default button and make it boldly-outlined
4159 7909              ;
4160 7909              SetNewDefault                           ; 
4161 7909 A5 16                 lda   <DefBut
4162 790B A0 16 01              ldy   #defbutID-wport
4163 790E 97 12                 sta   [<theDialog],y
4164 7910
4165 7910 A7 04 85 08           movelong [<Control],0,<ControlPtr 
4166 791B A0 10 00              ldy   #CtrlFlag
4167 791E B7 08                 lda   [<ControlPtr],y
4168 7920 09 01 00              ora   #BOLD_BUTT
4169 7923 97 08                 sta   [<ControlPtr],y
4170 7925
4171 7925              ;
4172 7925              ; Redraws new default button
4173 7925              ;
4174 7925 48                    pha                            ; space for title
4175 7926 48                    pha   
4176 7927 A5 06 48 A5           pushlong Control 
4177 792D A2 10 0D 22           _GetCtlTitle                   ; title is on the stack
4178 7934
4179 7934 A5 06 48 A5           pushlong Control 
4180 793A A2 10 0C 22           _SetCtlTitle 
4181 7941
4182 7941 A9 00 00              lda   #0
4183 7944              exit                                    ; 
4184 7944 A2 0C 00              ldx   #SizeLocals
4185 7947 4C 8B 89              jmp   quit6
4186 794A
4187 794A              notFound                                ; 
4188 794A FA                    plx   
4189 794B FA                    plx   
4190 794C 80 F6                 bra   exit
4191 794E
4192 794E                       ENDP 
4193 794E
4194 794E
4195 794E              ;_____________________________________________________________________________
4196 794E              ;
4197 794E              ;        HideDItem
4198 794E              ;
4199 794E              ;       input: theDialog:LONG - pointer to the dialog port
4200 794E              ;              itemID:WORD - ID of item to hide
4201 794E              ;
4202 794E              ;      output: none
4203 794E              ;______________________________________________________________________________
4204 794E
4205 794E                       ENTRY HideDItem
4206 794E              HideDItem PROC 
4207 794E
4208 794E A2 00 00              ldx   #0
4209 7951 80 03                 bra   ShowHideDItem
4210 7953
4211 7953                       ENDP 
4212 7953
4213 7953
4214 7953              ;_____________________________________________________________________________
4215 7953              ;
4216 7953              ;        ShowDItem
4217 7953              ;
4218 7953              ;       input: theDialog:LONG - pointer to the dialog port
4219 7953              ;              itemID:WORD - ID of item to show
4220 7953              ;
4221 7953              ;      output: none
4222 7953              ;______________________________________________________________________________
4223 7953
4224 7953                       ENTRY ShowDItem
4225 7953              ShowDItem PROC 
4226 7953
4227 7953 A2 01 00              ldx   #1
4228 7956
4229 7956                       ENDP 
4230 7956
4231 7956
4232 7956              ;_____________________________________________________________________________
4233 7956              ;
4234 7956              ;        ShowHideDItem
4235 7956              ;
4236 7956              ;       input: theDialog:LONG - pointer to the dialog port
4237 7956              ;              itemID:WORD - ID of item to show/hide
4238 7956              ;              X register = TRUE if show, FALSE if hide
4239 7956              ;
4240 7956              ;      output: none
4241 7956              ;______________________________________________________________________________
4242 7956
4243 7956                       ENTRY ShowHideDItem
4244 7956              ShowHideDItem PROC 
4245 7956
4246 7956 3B 38 E9 00           tlink 6 
4247 795F
4248 795F              itemID   equ   input
4249 795F              theDialog equ   itemID+2
4250 795F
4251 795F DA                    phx                            ; save show/hide flag
4252 7960
4253 7960 48                    pha                            ; space for control handle
4254 7961 48                    pha   
4255 7962 A5 0A 48 A5           pushlong theDialog 
4256 7968 A5 06 48              pushword itemID 
4257 796B A2 15 1E 22           _GetControlDItem 
4258 7972 B0 1B                 bcs   notFound
4259 7974
4260 7974 A3 05                 lda   5,s                      ; get show/hide flag
4261 7976 F0 09                 beq   HideIt
4262 7978
4263 7978 A2 10 0F 22           _ShowControl                   ; the Control is on the stack
4264 797F              ;                                       ; return ShowControl error status
4265 797F 80 07                 bra   quitit
4266 7981
4267 7981              HideIt                                  ; 
4268 7981 A2 10 0E 22           _HideControl                   ; the Control is on the stack
4269 7988              ;                                       ; return HideControl Error Status
4270 7988
4271 7988              quitit                                  ; 
4272 7988 FA                    plx                            ; pull show/hide flag
4273 7989
4274 7989              exit                                    ; 
4275 7989 A2 00 00              ldx   #0                       ; no locals
4276 798C 4C 8B 89              jmp   quit6
4277 798F
4278 798F              notFound                                ; 
4279 798F FA                    plx                            ; get rid of handle from _GetControlDItem call that
4280 7990 FA                    plx                            ; just failed
4281 7991 FA                    plx                            ; pull show/hide flag (5/2/88 HY)
4282 7992 80 F5                 bra   exit
4283 7994
4284 7994                       ENDP 
4285 7994
4286 7994
4287 7994              ;_____________________________________________________________________________
4288 7994              ;
4289 7994              ;        FindDItem
4290 7994              ;
4291 7994              ;       input: theDialog:LONG - pointer to the dialog port
4292 7994              ;              Point:LONG - point in global coordinates (passed as long)
4293 7994              ;
4294 7994              ;      output: itemID:WORD - ID of item located at Point, zero if none
4295 7994              ;______________________________________________________________________________
4296 7994
4297 7994                       ENTRY FindDItem
4298 7994              FindDItem PROC 
4299 7994
4300 7994              Control  equ   0
4301 7994              ControlPtr equ   Control+4
4302 7994              SizeLocals equ   ControlPtr+4
4303 7994
4304 7994 3B 38 E9 08           tlink 8,SizeLocals 
4305 799D
4306 799D              Point    equ   input
4307 799D              theDialog equ   Point+4
4308 799D
4309 799D              itemID   equ   output
4310 799D
4311 799D 64 16                 stz   <itemID
4312 799F
4313 799F 48                    pha                            ; space for location result
4314 79A0 F4 00 00 7B           pushzptr Control 
4315 79A9 A5 10 48 A5           pushlong Point 
4316 79AF A5 14 48 A5           pushlong theDialog 
4317 79B5 A2 10 13 22           _FindControl 
4318 79BC 68                    pla                            ; if no item hit, return 0 in itemID
4319 79BD F0 12                 beq   exit
4320 79BF
4321 79BF A7 00 85 04           movelong [<Control],0,ControlPtr  ; else return ID of item hit
4322 79CA A0 20 00 B7           moveword [<ControlPtr],iitemid,<itemID 
4323 79D1
4324 79D1              exit                                    ; 
4325 79D1 A9 00 00              lda   #0
4326 79D4 A2 08 00              ldx   #SizeLocals
4327 79D7 4C A2 89              jmp   quit8
4328 79DA
4329 79DA                       ENDP 
4330 79DA
4331 79DA
4332 79DA              ;_____________________________________________________________________________
4333 79DA              ;
4334 79DA              ;        DisableDItem
4335 79DA              ;
4336 79DA              ;       input: theDialog:LONG - pointer to the dialog port
4337 79DA              ;              itemID:WORD - ID of item to disable
4338 79DA              ;
4339 79DA              ;      output: none
4340 79DA              ;______________________________________________________________________________
4341 79DA
4342 79DA                       ENTRY DisableDItem
4343 79DA              DisableDItem PROC 
4344 79DA
4345 79DA A2 00 00              ldx   #0
4346 79DD 80 03                 bra   EnableDisableItem
4347 79DF
4348 79DF                       ENDP 
4349 79DF
4350 79DF
4351 79DF              ;_____________________________________________________________________________
4352 79DF              ;
4353 79DF              ;        EnableDItem
4354 79DF              ;
4355 79DF              ;       input: theDialog:LONG - pointer to the dialog port
4356 79DF              ;              itemID:WORD - ID of item to enable
4357 79DF              ;
4358 79DF              ;      output: none
4359 79DF              ;______________________________________________________________________________
4360 79DF
4361 79DF                       ENTRY EnableDItem
4362 79DF              EnableDItem PROC 
4363 79DF
4364 79DF A2 01 00              ldx   #1
4365 79E2
4366 79E2                       ENDP 
4367 79E2
4368 79E2
4369 79E2              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
4370 79E2              ;
4371 79E2              ;        EnableDisableItem
4372 79E2              ;
4373 79E2              ;       input: theDialog:LONG - pointer to the dialog port
4374 79E2              ;              itemID:WORD - ID of item to enable/disable
4375 79E2              ;              X register = TRUE if enable, FALSE if disable
4376 79E2              ;
4377 79E2              ;      output: none
4378 79E2              ;
4379 79E2              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
4380 79E2
4381 79E2                       ENTRY EnableDisableItem
4382 79E2              EnableDisableItem PROC 
4383 79E2
4384 79E2              Control  equ   0
4385 79E2              ControlPtr equ   Control+4
4386 79E2              SizeLocals equ   ControlPtr+4
4387 79E2
4388 79E2 3B 38 E9 08           tlink 6,SizeLocals 
4389 79EB
4390 79EB              itemID   equ   input
4391 79EB              theDialog equ   itemID+2
4392 79EB
4393 79EB DA                    phx                            ; save disable/enable flag
4394 79EC
4395 79EC 48                    pha                            ; space for control handle
4396 79ED 48                    pha   
4397 79EE A5 12 48 A5           pushlong theDialog 
4398 79F4 A5 0E 48              pushword itemID 
4399 79F7 A2 15 1E 22           _GetControlDItem 
4400 79FE B0 2C                 bcs   notFound
4401 7A00 68 85 00 68           pulllong <Control 
4402 7A06
4403 7A06 A7 00 85 04           movelong [<Control],0,<ControlPtr 
4404 7A11
4405 7A11 A0 22 00              ldy   #iitemtype               ; read item type
4406 7A14 B7 04                 lda   [<ControlPtr],y
4407 7A16
4408 7A16 FA                    plx                            ; get disable/enable flag
4409 7A17 F0 05                 beq   DisableIt
4410 7A19
4411 7A19 29 FF 7F              and   #$7FFF                   ; enable it
4412 7A1C
4413 7A1C 80 03                 bra   storeitback
4414 7A1E
4415 7A1E              DisableIt                               ; 
4416 7A1E 09 00 80              ora   #ItemDisable             ; disable it
4417 7A21
4418 7A21              storeitback                             ; 
4419 7A21 97 04                 sta   [<ControlPtr],y
4420 7A23
4421 7A23 A9 00 00              lda   #0
4422 7A26
4423 7A26              exit                                    ; 
4424 7A26 A2 08 00              ldx   #SizeLocals
4425 7A29 4C 8B 89              jmp   quit6
4426 7A2C
4427 7A2C              notFound                                ; 
4428 7A2C FA                    plx                            ; first get handle from _GetControlDItem call off stack
4429 7A2D FA                    plx   
4430 7A2E FA                    plx                            ; get rid of disable/enable flag
4431 7A2F 80 F5                 bra   exit
4432 7A31
4433 7A31                       ENDP 
4434 7A31              ;            copy  DText.asm
4435 7A31              ; DText.asm                             Jean-Charles Mourey
4436 7A31
4437 7A31                       TITLE 'Get and Set Text procedures'
4438 7A31
4439 7A31              ;____________________________________________________________________________
4440 7A31              ;
4441 7A31              ;        GetIText
4442 7A31              ;
4443 7A31              ;       input: theDialog:LONG - pointer to the dialog
4444 7A31              ;              itemID:WORD - ID of item in dialog
4445 7A31              ;              theString:LONG - pointer to a string to put the text in
4446 7A31              ;
4447 7A31              ;      output: none
4448 7A31              ;____________________________________________________________________________
4449 7A31
4450 7A31                       ENTRY GetIText
4451 7A31              GetIText PROC 
4452 7A31
4453 7A31              Control  equ   0
4454 7A31              ControlPtr equ   Control+4
4455 7A31              SourceString equ   ControlPtr+4
4456 7A31              hLE      equ   SourceString+4
4457 7A31              ptrLE    equ   hLE+4
4458 7A31              TextHandle equ   ptrLE+4
4459 7A31              TextPtr  equ   TextHandle+4
4460 7A31              SizeLocals equ   TextPtr+4
4461 7A31
4462 7A31 3B 38 E9 1C           tlink 10,SizeLocals 
4463 7A3A
4464 7A3A              theString equ   input
4465 7A3A              itemID   equ   theString+4
4466 7A3A              theDialog equ   itemID+2
4467 7A3A
4468 7A3A 48                    pha                            ; space for control
4469 7A3B 48                    pha   
4470 7A3C A5 2A 48 A5           pushlong theDialog 
4471 7A42 A5 26 48              pushword itemID 
4472 7A45 A2 15 1E 22           _GetControlDItem 
4473 7A4C 90 03 82 A8           Check_Error notFound 
4474 7A51 68 85 00 68           pulllong <Control 
4475 7A57
4476 7A57 A7 00 85 04           movelong [<Control],0,<ControlPtr 
4477 7A62
4478 7A62 A0 22 00              ldy   #iitemtype
4479 7A65 B7 04                 lda   [<ControlPtr],y
4480 7A67 29 FF 7F              and   #$7FFF                   ; get rid of ItemDisable Bit
4481 7A6A C9 11 00              cmp   #EditLine
4482 7A6D F0 38                 beq   GetEditText
4483 7A6F C9 0F 00              cmp   #StatText
4484 7A72 F0 0B                 beq   GetStatText
4485 7A74
4486 7A74 A9 00 00              lda   #0                       ; not EditLine or StatText
4487 7A77 87 22                 sta   [<theString]             ; clear theString
4488 7A79 A9 0A 15              lda   #DLGERR+BadItemType      ; return error message
4489 7A7C 82 74 00              brl   exit
4490 7A7F
4491 7A7F              GetStatText                             ; 
4492 7A7F A0 1C 00 B7           movelong [<ControlPtr],CtrlData,<SourceString 
4493 7A8D A7 08                 lda   [<SourceString]
4494 7A8F F0 0D                 beq   StatTextEmpty
4495 7A91 29 FF 00              and   #$FF
4496 7A94 A8                    tay   
4497 7A95
4498 7A95 E2 20                 sep   #$20                     ; switch to 8 bit m
4499 7A97                       longa off
4500 7A97              charloop1                               ; 
4501 7A97 B7 08                 lda   [<SourceString],y
4502 7A99 97 22                 sta   [<theString],y
4503 7A9B 88                    dey   
4504 7A9C 10 F9                 bpl   charloop1
4505 7A9E
4506 7A9E              StatTextEmpty                           ; 
4507 7A9E A7 08                 lda   [<SourceString]
4508 7AA0 87 22                 sta   [<theString]
4509 7AA2
4510 7AA2 C2 20                 rep   #$20                     ; back to 16 bit m
4511 7AA4                       longa on
4512 7AA4
4513 7AA4 82 49 00              brl   noErrExit
4514 7AA7
4515 7AA7              GetEditText                             ; 
4516 7AA7 A0 1C 00 B7           movelong [<ControlPtr],CtrlData,<hLE 
4517 7AB5 A7 0C 85 10           movelong [<hLE],0,<ptrLE 
4518 7AC0 A7 10 85 14           movelong [<ptrLE],0,<TextHandle 
4519 7ACB A7 14 85 18           movelong [<TextHandle],0,<TextPtr 
4520 7AD6
4521 7AD6 A0 04 00              ldy   #4                       ; length field
4522 7AD9 B7 10                 lda   [<ptrLE],y
4523 7ADB
4524 7ADB E2 20                 sep   #$20                     ; switch to 8 bit mode
4525 7ADD                       longa off
4526 7ADD
4527 7ADD F0 0D                 beq   EditTextEmpty
4528 7ADF
4529 7ADF A8                    tay   
4530 7AE0 AA                    tax                            ; get a copy of the length in X
4531 7AE1 88                    dey                            ; y equals the length of the string minus the length byte
4532 7AE2
4533 7AE2              charloop2                               ; 
4534 7AE2 B7 18                 lda   [<TextPtr],y             ; load accumulator with the yth character
4535 7AE4 C8                    iny                            ; increment y to allow for length byte
4536 7AE5 97 22                 sta   [<theString],y
4537 7AE7 88                    dey   
4538 7AE8 88                    dey   
4539 7AE9 10 F7                 bpl   charloop2
4540 7AEB
4541 7AEB 8A                    txa                            ; copy length in theString
4542 7AEC
4543 7AEC              EditTextEmpty                           ; 
4544 7AEC 87 22                 sta   [<theString]
4545 7AEE C2 20                 rep   #$20                     ; back to 16 bit m
4546 7AF0                       longa on
4547 7AF0
4548 7AF0              noErrExit                               ; 
4549 7AF0 A9 00 00              lda   #0
4550 7AF3
4551 7AF3              exit                                    ; 
4552 7AF3 A2 1C 00              ldx   #SizeLocals
4553 7AF6 4C BA 89              jmp   quit10
4554 7AF9
4555 7AF9              notFound                                ; 
4556 7AF9 FA                    plx   
4557 7AFA FA                    plx   
4558 7AFB 80 F6                 bra   exit
4559 7AFD
4560 7AFD                       ENDP 
4561 7AFD
4562 7AFD
4563 7AFD              ;______________________________________________________________________________
4564 7AFD              ;
4565 7AFD              ;        SetIText
4566 7AFD              ;
4567 7AFD              ;       input: theDialog:LONG - dialog port pointer
4568 7AFD              ;              itemID:WORD - ID of item in dialog
4569 7AFD              ;              theString:LONG - pointer to the string
4570 7AFD              ;
4571 7AFD              ;      output: none
4572 7AFD              ;______________________________________________________________________________
4573 7AFD
4574 7AFD                       ENTRY SetIText
4575 7AFD              SetIText PROC 
4576 7AFD
4577 7AFD              Control  equ   0
4578 7AFD              ControlPtr equ   Control+4
4579 7AFD              hLE      equ   ControlPtr+4
4580 7AFD              TextPtr  equ   hLE+4
4581 7AFD              SizeLocals equ   TextPtr+4
4582 7AFD
4583 7AFD 3B 38 E9 10           tlink 10,SizeLocals 
4584 7B06
4585 7B06              theString equ   input
4586 7B06              itemID   equ   theString+4
4587 7B06              theDialog equ   itemID+2
4588 7B06
4589 7B06 48                    pha                            ; space for control
4590 7B07 48                    pha   
4591 7B08 A5 1E 48 A5           pushlong theDialog 
4592 7B0E A5 1A 48              pushword itemID 
4593 7B11 A2 15 1E 22           _GetControlDItem 
4594 7B18 90 03 82 90           Check_Error notFound 
4595 7B1D 68 85 00 68           pulllong <Control 
4596 7B23
4597 7B23 A7 00 85 04           movelong [<Control],0,<ControlPtr 
4598 7B2E
4599 7B2E A0 22 00              ldy   #iitemtype
4600 7B31 B7 04                 lda   [<ControlPtr],y
4601 7B33 29 FF 7F              and   #$7FFF                   ; get rid of ItemDisable Bit
4602 7B36 C9 11 00              cmp   #EditLine
4603 7B39 F0 21                 beq   SetEditText
4604 7B3B C9 0F 00              cmp   #StatText
4605 7B3E F0 06                 beq   SetStatText
4606 7B40
4607 7B40 A9 0A 15              lda   #DLGERR+BadItemType      ; return error message
4608 7B43 82 61 00              brl   exit                     ; not Text Type item, exit
4609 7B46
4610 7B46              SetStatText                             ; text of stattext = title of control
4611 7B46 A5 18 48 A5           pushlong theString 
4612 7B4C A5 02 48 A5           pushlong Control 
4613 7B52 A2 10 0C 22           _SetCtlTitle 
4614 7B59
4615 7B59 82 4B 00              brl   exit
4616 7B5C
4617 7B5C              SetEditText                             ; 
4618 7B5C
4619 7B5C              ;
4620 7B5C              ; Get Line Edit Record Handle
4621 7B5C              ;
4622 7B5C A0 1C 00 B7           movelong [<ControlPtr],CtrlData,<hLE 
4623 7B6A
4624 7B6A              ;
4625 7B6A              ; Call LESetSelect, and redraws the item if no error
4626 7B6A              ;
4627 7B6A A5 16 18 69           add4 <theString,#1,<TextPtr    ; TextPtr
4628 7B79 A5 0E 48 A5           pushlong TextPtr 
4629 7B7F
4630 7B7F A7 16                 lda   [<theString]             ; Length
4631 7B81 29 FF 00              and   #$FF
4632 7B84 48                    pha   
4633 7B85
4634 7B85 A5 0A 48 A5           pushlong hLE 
4635 7B8B
4636 7B8B A2 14 0B 22           _LESetText                     ; LESetText does not redraw
4637 7B92
4638 7B92 B0 13                 bcs   exit                     ; exit if error
4639 7B94
4640 7B94 A5 0A 48 A5           pushlong hLE                   ; redraws the control
4641 7B9A A5 02 48 A5           pushlong Control 
4642 7BA0 A2 10 0C 22           _SetCtlTitle                   ; returns SetCtlTitle error status
4643 7BA7
4644 7BA7              exit                                    ; 
4645 7BA7 A2 10 00              ldx   #SizeLocals
4646 7BAA 4C BA 89              jmp   quit10
4647 7BAD
4648 7BAD              notFound                                ; 
4649 7BAD FA                    plx   
4650 7BAE FA                    plx   
4651 7BAF 80 F6                 bra   exit
4652 7BB1
4653 7BB1                       ENDP 
4654 7BB1
4655 7BB1              ;_____________________________________________________________________________
4656 7BB1              ;
4657 7BB1              ;        SelIText
4658 7BB1              ;
4659 7BB1              ;       input: theDialog:LONG - pointer to the dialog port
4660 7BB1              ;              itemID:WORD - ID of item in dialog
4661 7BB1              ;              startSel:WORD - start of selection
4662 7BB1              ;              endSel:WORD - end of selection
4663 7BB1              ;
4664 7BB1              ;      output: none
4665 7BB1              ;______________________________________________________________________________
4666 7BB1
4667 7BB1                       ENTRY SelIText
4668 7BB1              SelIText PROC 
4669 7BB1
4670 7BB1              oldEditLine equ   0
4671 7BB1              Control  equ   oldEditLine+4
4672 7BB1              ControlPtr equ   Control+4
4673 7BB1              hLE      equ   ControlPtr+4             ; Line Edit Record for selected Item
4674 7BB1              SizeLocals equ   hLE+4
4675 7BB1
4676 7BB1 3B 38 E9 10           tlink 10,SizeLocals 
4677 7BBA
4678 7BBA              endSel   equ   input
4679 7BBA              startSel equ   endSel+2
4680 7BBA              itemID   equ   startSel+2
4681 7BBA              theDialog equ   itemID+2
4682 7BBA
4683 7BBA              ;
4684 7BBA              ; Get handle to item
4685 7BBA              ;
4686 7BBA 48                    pha                            ; space for control
4687 7BBB 48                    pha   
4688 7BBC A5 1E 48 A5           pushlong theDialog 
4689 7BC2 A5 1A 48              pushword itemID 
4690 7BC5 A2 15 1E 22           _GetControlDItem 
4691 7BCC 90 03 82 F0           Check_Error notFound 
4692 7BD1 68 85 04 68           pulllong <Control 
4693 7BD7
4694 7BD7 A7 04 85 08           movelong [<Control],0,<ControlPtr 
4695 7BE2 A0 22 00              ldy   #iitemtype
4696 7BE5 B7 08                 lda   [<ControlPtr],y
4697 7BE7 29 FF 7F              and   #$7FFF
4698 7BEA C9 11 00              cmp   #EditLine
4699 7BED F0 06                 beq   SelIt
4700 7BEF A9 0A 15              lda   #DLGERR+BadItemType
4701 7BF2 82 C6 00              brl   quickexit
4702 7BF5
4703 7BF5              ;
4704 7BF5              ; Set the port to our dialog
4705 7BF5              ;
4706 7BF5              SelIt                                   ; 
4707 7BF5 48                    pha                            ; space for port pointer
4708 7BF6 48                    pha   
4709 7BF7 A2 04 1C 22           _GetPort                       ; saved port is on stack
4710 7BFE
4711 7BFE A5 1E 48 A5           pushlong theDialog 
4712 7C04 A2 04 1B 22           _SetPort 
4713 7C0B
4714 7C0B A9 00 00              lda   #0
4715 7C0E 48                    pha   
4716 7C0F 48                    pha   
4717 7C10 A2 04 23 22           _SetOrigin 
4718 7C17
4719 7C17              ;
4720 7C17              ; Call LESetSelect to highlight selection
4721 7C17              ;
4722 7C17 A7 04 85 08           movelong [<Control],0,<ControlPtr 
4723 7C22 A0 1C 00 B7           movelong [<ControlPtr],CtrlData,<hLE   ; get Line Edit Handle
4724 7C30
4725 7C30 A5 18 48              pushword startSel 
4726 7C33 A5 16 48              pushword endSel 
4727 7C36 A5 0E 48 A5           pushlong hLE 
4728 7C3C A2 14 0E 22           _LESetSelect 
4729 7C43
4730 7C43              ;
4731 7C43              ; Check if the highlighted EditLine item is the currently active or not
4732 7C43              ;
4733 7C43 A0 14 01              ldy   #edittextID-wport
4734 7C46 B7 1C                 lda   [<theDialog],y
4735 7C48 C5 1A                 cmp   <itemID
4736 7C4A D0 03                 bne   IsNotActive
4737 7C4C 82 62 00              brl   exit
4738 7C4F
4739 7C4F              IsNotActive  
4740 7C4F AA                    tax   
4741 7C50
4742 7C50              ;
4743 7C50              ; If not active, deactivate old (if there is one), and activate new
4744 7C50              ;
4745 7C50 48                    pha                            ; space for control
4746 7C51 48                    pha   
4747 7C52 A5 1E 48 A5           pushlong theDialog 
4748 7C58 DA                    phx   
4749 7C59 A2 15 1E 22           _GetControlDItem 
4750 7C60 B0 26                 bcs   noOldEditLine
4751 7C62 68 85 00 68           pulllong <oldEditLine 
4752 7C68
4753 7C68              DeactivateOld                           ; 
4754 7C68 A7 00 85 08           movelong [<oldEditLine],0,<ControlPtr 
4755 7C73 A0 1E 00 B7           pushlong [<ControlPtr],CtrlData 
4756 7C7F A2 14 10 22           _LEDeactivate 
4757 7C86 80 02                 bra   ActivateNew
4758 7C88
4759 7C88              noOldEditLine                           ; 
4760 7C88 FA                    plx                            ; pull useless result of GetControlDItem
4761 7C89 FA                    plx   
4762 7C8A
4763 7C8A              ActivateNew                             ; 
4764 7C8A              ;
4765 7C8A              ; First test if window is active or not. If not active, does not activate item
4766 7C8A              ;
4767 7C8A 48                    pha                            ; space for window port
4768 7C8B 48                    pha   
4769 7C8C A2 0E 15 22           _FrontWindow 
4770 7C93
4771 7C93 68                    pla                            ; compare front window to our dialog
4772 7C94 FA                    plx   
4773 7C95 C5 1C                 cmp   <theDialog
4774 7C97 D0 11                 bne   SetEditID
4775 7C99 E4 1E                 cpx   <theDialog+2
4776 7C9B D0 0D                 bne   SetEditID
4777 7C9D
4778 7C9D A5 0E 48 A5           pushlong hLE 
4779 7CA3 A2 14 0F 22           _LEActivate 
4780 7CAA
4781 7CAA              SetEditID                               ; 
4782 7CAA A5 1A                 lda   <itemID                  ; store the ID of the new active LE item
4783 7CAC A0 14 01              ldy   #edittextID-wport
4784 7CAF 97 1C                 sta   [<theDialog],y
4785 7CB1
4786 7CB1              exit                                    ; 
4787 7CB1
4788 7CB1 A2 04 1B 22           _SetPort                       ; port is on stack
4789 7CB8
4790 7CB8 A9 00 00              lda   #0
4791 7CBB
4792 7CBB              quickexit                               ; 
4793 7CBB A2 10 00              ldx   #SizeLocals
4794 7CBE 4C BA 89              jmp   quit10
4795 7CC1
4796 7CC1              notFound                                ; 
4797 7CC1 FA                    plx   
4798 7CC2 FA                    plx   
4799 7CC3 80 F6                 bra   quickexit
4800 7CC5
4801 7CC5                       ENDP 
4802 7CC5
4803 7CC5
4804 7CC5              ;______________________________________________________________________________
4805 7CC5              ;
4806 7CC5              ;        ParamText
4807 7CC5              ;
4808 7CC5              ;       input: param0:LONG - pointer to string ^0 (zero=no change)
4809 7CC5              ;              param1:LONG - pointer to string ^1 (zero=no change)
4810 7CC5              ;              param2:LONG - pointer to string ^1 (zero=no change)
4811 7CC5              ;              param3:LONG - pointer to string ^1 (zero=no change)
4812 7CC5              ;
4813 7CC5              ;      output: none
4814 7CC5              ;
4815 7CC5              ; Change History
4816 7CC5              ;
4817 7CC5              ; 4 March 88        STEVEN Glass
4818 7CC5              ;
4819 7CC5              ; Uses the incoming WAP instead of calling the control manager for the 
4820 7CC5              ; value of its direct page.
4821 7CC5              ;______________________________________________________________________________
4822 7CC5
4823 7CC5                       ENTRY ParamText
4824 7CC5              ParamText PROC 
4825 7CC5
4826 7CC5              Globals  equ   0
4827 7CC5              SizeLocals equ   Globals+4
4828 7CC5
4829 7CC5 A8                    tay                            ; save the incoming WAP
4830 7CC6 3B 38 E9 04           tlink 16,SizeLocals 
4831 7CCF
4832 7CCF              paramstart equ   input
4833 7CCF
4834 7CCF              ;
4835 7CCF              ; Get Dialog Manager Zero Page
4836 7CCF              ;
4837 7CCF 84 00                 sty   <Globals
4838 7CD1 64 02                 stz   <Globals+2
4839 7CD3
4840 7CD3 A2 0C 00              ldx   #12                      ; start with param0
4841 7CD6 A0 90 00              ldy   #ParamString0
4842 7CD9
4843 7CD9              NextParam                               ; 
4844 7CD9 B5 0A                 lda   <paramstart,x
4845 7CDB D0 04                 bne   ChangeIt
4846 7CDD B5 0C                 lda   <paramstart+2,x
4847 7CDF F0 0E                 beq   XYOffsets
4848 7CE1
4849 7CE1              ;
4850 7CE1              ; If param is not zero, change paramstring
4851 7CE1              ;
4852 7CE1              ChangeIt                                ; 
4853 7CE1 B5 0A                 lda   <paramstart,x
4854 7CE3 97 00                 sta   [<Globals],y
4855 7CE5 C8                    iny   
4856 7CE6 C8                    iny   
4857 7CE7 B5 0C                 lda   <paramstart+2,x
4858 7CE9 97 00                 sta   [<Globals],y
4859 7CEB C8                    iny   
4860 7CEC C8                    iny   
4861 7CED 80 04                 bra   XOffset
4862 7CEF
4863 7CEF              XYOffsets                               ; 
4864 7CEF C8                    iny   
4865 7CF0 C8                    iny   
4866 7CF1 C8                    iny   
4867 7CF2 C8                    iny   
4868 7CF3
4869 7CF3              XOffset                                 ; 
4870 7CF3 CA                    dex   
4871 7CF4 CA                    dex   
4872 7CF5 CA                    dex   
4873 7CF6 CA                    dex   
4874 7CF7 10 E0                 bpl   NextParam                ; down to param3
4875 7CF9
4876 7CF9 A9 00 00              lda   #0
4877 7CFC 2B A8 A3 09           tunlink 
4878 7D14 6B                    rtl   
4879 7D15                       ENDP 
4880 7D15              ;            copy  Modal.asm
4881 7D15              ; Modal.asm                             Jean-Charles Mourey
4882 7D15
4883 7D15                       TITLE 'Modal Dialog Procedure'
4884 7D15
4885 7D15              ;_____________________________________________________________________________
4886 7D15              ;
4887 7D15              ;        ModalDialog2
4888 7D15              ;
4889 7D15              ;       input: filterProc:LONG - procedure to be called repeatdly by ModalDialog
4890 7D15              ;
4891 7D15              ;      output: itemHitInfo:LONG - LoWord = ID of item Hit, HiWord = PartCode Hit
4892 7D15              ;
4893 7D15              ;    function: ModalDialog2 is an extension of ModalDialog. In addition to
4894 7D15              ;              returning the ID of the item Hit, it returns as well the Part
4895 7D15              ;              Code Hit.
4896 7D15              ;
4897 7D15              ; Change History
4898 7D15              ;
4899 7D15              ; 4 March 88        STEVEN Glass
4900 7D15              ;
4901 7D15              ; Uses the incoming WAP instead of calling the control manager for the 
4902 7D15              ; value of its direct page.
4903 7D15              ;______________________________________________________________________________
4904 7D15
4905 7D15                       ENTRY ModalDialog2
4906 7D15              ModalDialog2 PROC 
4907 7D15
4908 7D15              Globals  equ   0
4909 7D15              SizeLocals equ   Globals+4
4910 7D15
4911 7D15
4912 7D15 A8                    tay                            ; save incoming WAP
4913 7D16 3B 38 E9 04           tlink 4,SizeLocals 
4914 7D1F
4915 7D1F              filterProc equ   input
4916 7D1F
4917 7D1F              itemHitInfo equ   output
4918 7D1F
4919 7D1F              ;
4920 7D1F              ; Clears result
4921 7D1F              ;
4922 7D1F 64 0E                 stz   <itemHitInfo
4923 7D21 64 10                 stz   <itemHitInfo+2
4924 7D23
4925 7D23              ;
4926 7D23              ; Get Globals Page
4927 7D23              ;
4928 7D23 84 00                 sty   <Globals
4929 7D25 64 02                 stz   <Globals+2
4930 7D27
4931 7D27              ;
4932 7D27              ; Clears PartCode Hit in global page
4933 7D27              ;
4934 7D27 A9 00 00              lda   #0
4935 7D2A A0 A0 00              ldy   #PartCodeHit
4936 7D2D 97 00                 sta   [<Globals],y
4937 7D2F
4938 7D2F              ;
4939 7D2F              ; Call ModalDialog
4940 7D2F              ;
4941 7D2F 48                    pha                            ; space for itemHit
4942 7D30 A5 0C 48 A5           pushlong filterProc 
4943 7D36 A2 15 0F 22           _ModalDialog 
4944 7D3D B0 13                 bcs   thiserror
4945 7D3F 68                    pla   
4946 7D40 85 0E                 sta   <itemHitInfo
4947 7D42
4948 7D42              ;
4949 7D42              ; Get PartCode from global page and store it in result
4950 7D42              ;
4951 7D42 A0 A0 00              ldy   #PartCodeHit
4952 7D45 B7 00                 lda   [<Globals],y
4953 7D47 85 10                 sta   <itemHitInfo+2
4954 7D49
4955 7D49              ;
4956 7D49              ; exit, no error
4957 7D49              ;
4958 7D49 A9 00 00              lda   #0                       ; no error
4959 7D4C
4960 7D4C              ;
4961 7D4C              ; common exit
4962 7D4C              ;
4963 7D4C              exit      
4964 7D4C A2 04 00              ldx   #SizeLocals
4965 7D4F 4C 75 89              jmp   quit4
4966 7D52
4967 7D52              ;
4968 7D52              ; error
4969 7D52              ;
4970 7D52              thiserror  
4971 7D52 FA                    plx                            ; get rid of result
4972 7D53 80 F7                 bra   exit
4973 7D55
4974 7D55                       ENDP 
4975 7D55
4976 7D55
4977 7D55              ;_____________________________________________________________________________
4978 7D55              ;
4979 7D55              ;        ModalDialog
4980 7D55              ;
4981 7D55              ;       input: filterProc:LONG - procedure to be called repeatdly by ModalDialog
4982 7D55              ;
4983 7D55              ;      output: itemHit:WORD - ID of item Hit.
4984 7D55              ;
4985 7D55              ;    function: if the frontwindow is a modal dialog, ModalDialog repeatdly gets
4986 7D55              ;              and handles events in the dialog's window; after handling an
4987 7D55              ;              event involving an enabled dialog item, it returns with the item
4988 7D55              ;              ID in itemHit.
4989 7D55              ;
4990 7D55              ;    filterProc: if  is NULL, Standard Filter Called
4991 7D55              ;                if not NULL, filterProc called
4992 7D55              ;                     then: if bit 31 of filterProc is set, call Standard
4993 7D55              ;                           Filter also.
4994 7D55              ;
4995 7D55              ; Change History
4996 7D55              ;
4997 7D55              ; 4 March 88        STEVEN Glass
4998 7D55              ;
4999 7D55              ; Uses the incoming WAP instead of calling the control manager for the 
5000 7D55              ; value of its direct page.  Changed order of when Globals pointer was set
5001 7D55              ; to do it while y-reg still valid.
5002 7D55              ;
5003 7D55              ; 5-Mar-91          Dave Lyons
5004 7D55              ;
5005 7D55              ; Defining bit 30 of the filter proc pointer = do I-Beam cursors.  See top of
5006 7D55              ; file.
5007 7D55              ;
5008 7D55              ;______________________________________________________________________________
5009 7D55
5010 7D55                       ENTRY ModalDialog
5011 7D55              ModalDialog PROC 
5012 7D55
5013 7D55              Event    equ   0                        ;MUST BE ZERO! 17-Sep-90 DAL
5014 7D55              Window   equ   Event+EVTSIZE
5015 7D55              Dialog   equ   Window+4
5016 7D55              Location equ   Dialog+4
5017 7D55              Control  equ   Location+2
5018 7D55              ControlPtr equ   Control+4
5019 7D55              PartCode equ   ControlPtr+4
5020 7D55              Globals  equ   PartCode+2
5021 7D55              PortSave equ   Globals+4
5022 7D55              SizeLocals equ   PortSave+4
5023 7D55
5024 7D55
5025 7D55 A8                    tay                            ; save incoming WAP
5026 7D56 3B 38 E9 2C           tlink 4,SizeLocals 
5027 7D5F
5028 7D5F              filterProc equ   input
5029 7D5F
5030 7D5F              itemHit  equ   output
5031 7D5F
5032 7D5F              ;
5033 7D5F              ; Get pointer to Globals Variables
5034 7D5F              ;
5035 7D5F 84 24                 sty   <Globals
5036 7D61 64 26                 stz   <Globals+2
5037 7D63              ;
5038 7D63              ; For the moment, no item Hit
5039 7D63              ;
5040 7D63 64 36                 stz   <itemHit
5041 7D65 64 22                 stz   <PartCode
5042 7D67
5043 7D67              ;
5044 7D67              ; Check that the front window is a modal dialog
5045 7D67              ;
5046 7D67 48                    pha                            ; get dialog port
5047 7D68 48                    pha   
5048 7D69 A2 0E 15 22           _FrontWindow 
5049 7D70
5050 7D70 A3 01                 lda   1,s                      ; get dialog port without pulling it
5051 7D72 85 14                 sta   <Dialog
5052 7D74 A3 03                 lda   3,s
5053 7D76 85 16                 sta   <Dialog+2
5054 7D78
5055 7D78 F4 01 00              pushword #Modal_Type           ; dialog is still on stack
5056 7D7B 22 04 81 FC           jsl   WindowIsDialog
5057 7D7F 90 06                 bcc   DialogOk
5058 7D81 A9 0D 15              lda   #DLGERR+NotModalDialog
5059 7D84 82 E9 00              brl   quickexit
5060 7D87
5061 7D87 48           DialogOk pha                            ; space for port pointer
5062 7D88 48                    pha   
5063 7D89 A2 04 1C 22           _GetPort 
5064 7D90 68 85 28 68           pulllong <PortSave 
5065 7D96
5066 7D96 A5 16 48 A5           pushlong Dialog                ; set current port = the dialog
5067 7D9C A2 04 1B 22           _SetPort 
5068 7DA3
5069 7DA3 A9 00 00              lda   #0
5070 7DA6 48                    pha   
5071 7DA7 48                    pha   
5072 7DA8 A2 04 23 22           _SetOrigin 
5073 7DAF
5074 7DAF              EventLoop  
5075 7DAF              ;
5076 7DAF              ; Call the Desk Manager procedure SystemTask
5077 7DAF              ; If the Desk Manager if not there, SystemTask will just return
5078 7DAF              ;
5079 7DAF A2 05 19 22           _SystemTask 
5080 7DB6
5081 7DB6              ;
5082 7DB6              ; Blink the caret if there is an Edit Line item in the dialog
5083 7DB6              ;
5084 7DB6 A5 16 48 A5           pushlong Dialog 
5085 7DBC 22 60 81 FC           jsl   BlinkCaret
5086 7DC0
5087 7DC0              ;
5088 7DC0              ; Get next Event:
5089 7DC0              ;
5090 7DC0              GetEvent                                ; 
5091 7DC0 48                    pha                            ; space for boolean result
5092 7DC1 F4 FF FF              pushword #$FFFF                ; all events
5093 7DC4 F4 00 00 7B           pushzptr Event 
5094 7DCD A2 06 0A 22           _GetNextEvent 
5095 7DD4 68                    pla                            ; if FALSE, event is null event
5096 7DD5
5097 7DD5              ;
5098 7DD5              ; See if there is a user filter procedure to call
5099 7DD5              ;
5100 7DD5 A5 32                 lda   <filterProc
5101 7DD7 D0 04                 bne   UserFilter
5102 7DD9 A5 33                 lda   <filterProc+1
5103 7DDB F0 2B                 beq   StdFilter
5104 7DDD
5105 7DDD              UserFilter                              ; 
5106 7DDD 48                    pha                            ; space for filter result
5107 7DDE A5 16 48 A5           pushlong Dialog 
5108 7DE4 F4 00 00 7B           pushzptr Event 
5109 7DED F4 00 00 7B           pushzptr itemHit 
5110 7DF6 A5 32                 lda   <filterProc
5111 7DF8 A6 33                 ldx   <filterProc+1
5112 7DFA 22 52 89 FC           jsl   long_call
5113 7DFE 68                    pla                            ; if TRUE, returns
5114 7DFF D0 58                 bne   exit
5115 7E01
5116 7E01              ;
5117 7E01              ; If Bit 31 of filterProc is set, call StdFilter anyway
5118 7E01              ;
5119 7E01 A5 34                 lda   <filterProc+2
5120 7E03 29 00 80              and   #$8000
5121 7E06 F0 20                 beq   DispEvent
5122 7E08
5123 7E08              ;
5124 7E08              ; Call standard filter procedure
5125 7E08              ;
5126 7E08              StdFilter                               ; 
5127 7E08 48                    pha                            ; space for filter result
5128 7E09 A5 16 48 A5           pushlong Dialog 
5129 7E0F F4 00 00 7B           pushzptr Event 
5130 7E18 F4 00 00 7B           pushzptr itemHit 
5131 7E21 22 C0 81 FC           jsl   StdFilterProc
5132 7E25 68                    pla                            ; if TRUE, returns
5133 7E26 D0 31                 bne   exit
5134 7E28
5135 7E28              ;
5136 7E28              ; Dispatch Event
5137 7E28              ;
5138 7E28              DispEvent  
5139 7E28 A5 00                 lda   <Event+what
5140 7E2A 0A                    asl   a
5141 7E2B AA                    tax   
5142 7E2C BF 32 7E FC           lda   >EventTable,x
5143 7E30 48                    pha   
5144 7E31 60                    rts   
5145 7E32
5146 7E32              EventTable  
5147 7E32 AE 7D                 DC W:EventLoop-1               ; inNull
5148 7E34 75 7E                 DC W:MouseDownEvent-1          ; inButtDwn
5149 7E36 AE 7D                 DC W:EventLoop-1               ; inButtUp
5150 7E38 AD 7F                 DC W:KeyDownEvent-1            ; inKey
5151 7E3A AE 7D                 DC W:EventLoop-1
5152 7E3C AD 7F                 DC W:KeyDownEvent-1            ; inAutoKey
5153 7E3E 57 80                 DC W:UpdateEvent-1             ; inUpdate
5154 7E40 AE 7D                 DC W:EventLoop-1
5155 7E42 85 80                 DC W:ActivateEvent-1           ; inActWind
5156 7E44 AE 7D                 DC W:EventLoop-1               ; inSwitch
5157 7E46 AE 7D                 DC W:EventLoop-1               ; inAccess
5158 7E48 AE 7D                 DC W:EventLoop-1               ; inDevice
5159 7E4A AE 7D                 DC W:EventLoop-1               ; inApp1
5160 7E4C AE 7D                 DC W:EventLoop-1               ; inApp2
5161 7E4E AE 7D                 DC W:EventLoop-1               ; inApp3
5162 7E50 AE 7D                 DC W:EventLoop-1               ; inApp4
5163 7E52
5164 7E52
5165 7E52              nextModalEvent  
5166 7E52 A5 36                 lda   <itemHit                 ; if itemHit <> 0, returns
5167 7E54 D0 03                 bne   exit
5168 7E56 82 56 FF              brl   EventLoop
5169 7E59
5170 7E59              exit      
5171 7E59 A5 2A 48 A5           pushlong PortSave 
5172 7E5F A2 04 1B 22           _SetPort                       ; port is on stack
5173 7E66
5174 7E66              ;
5175 7E66              ; Store PartCode Hit in Dialog Globals
5176 7E66              ;
5177 7E66 A5 22                 lda   <PartCode
5178 7E68 A0 A0 00              ldy   #PartCodeHit
5179 7E6B 97 24                 sta   [<Globals],y
5180 7E6D
5181 7E6D A9 00 00              lda   #0                       ; no error
5182 7E70
5183 7E70              quickexit  
5184 7E70 A2 2C 00              ldx   #SizeLocals
5185 7E73 4C 75 89              jmp   quit4
5186 7E76
5187 7E76
5188 7E76              ;______________________________________________________________________________
5189 7E76              ;
5190 7E76              ;        MouseDownEvent
5191 7E76              ;______________________________________________________________________________
5192 7E76
5193 7E76              MouseDownEvent  
5194 7E76
5195 7E76              ;
5196 7E76              ; Find window where the mouse-down occurred and where in the window
5197 7E76              ;
5198 7E76 48                    pha                            ; space for location
5199 7E77 F4 00 00 7B           pushzptr Window 
5200 7E80 A5 0C 48 A5           pushlong Event+where 
5201 7E86 A2 0E 17 22           _FindWindow 
5202 7E8D 68                    pla   
5203 7E8E 29 FF 7F              and   #$7FFF                   ; get rid of InSysWindow bit
5204 7E91 85 18                 sta   <Location
5205 7E93
5206 7E93              ;
5207 7E93              ; If not in our dialog, beep
5208 7E93              ;
5209 7E93 A5 10                 lda   <Window
5210 7E95 C5 14                 cmp   <Dialog
5211 7E97 D0 06                 bne   GotoBeep
5212 7E99 A5 12                 lda   <Window+2
5213 7E9B C5 16                 cmp   <Dialog+2
5214 7E9D F0 03                 beq   TestLocation
5215 7E9F
5216 7E9F 82 E6 00     GotoBeep brl   Beep
5217 7EA2
5218 7EA2              ;
5219 7EA2              ; if not in the content region, no item hit -> exit
5220 7EA2              ;
5221 7EA2 A5 18        TestLocation lda   <Location
5222 7EA4 C9 13 00              cmp   #winContent
5223 7EA7 F0 03                 beq   FindWhere
5224 7EA9 82 FB 00              brl   MDnoitem
5225 7EAC
5226 7EAC              ;
5227 7EAC              ; Find which item has been clicked in
5228 7EAC              ;
5229 7EAC 48           FindWhere pha                           ; space for partcode
5230 7EAD F4 00 00 7B           pushzptr Control 
5231 7EB6 A5 0C 48 A5           pushlong Event+where 
5232 7EBC A5 16 48 A5           pushlong Dialog 
5233 7EC2 A2 10 13 22           _FindControl 
5234 7EC9 68 85 22              pullword <PartCode             ; if PartCode=0, no item hit
5235 7ECC D0 03                 bne   CheckID
5236 7ECE 82 D6 00              brl   MDnoitem
5237 7ED1
5238 7ED1              ;
5239 7ED1              ; If ID is zero, does not handle item (non item controls)
5240 7ED1              ;
5241 7ED1              CheckID   
5242 7ED1 A7 1A 85 1E           movelong [<Control],0,<ControlPtr 
5243 7EDC A0 20 00              ldy   #iitemid
5244 7EDF B7 1E                 lda   [<ControlPtr],y
5245 7EE1 D0 03                 bne   CheckEditLine
5246 7EE3 82 C1 00              brl   MDnoitem
5247 7EE6
5248 7EE6              ;
5249 7EE6              ; If PartCode is inEditLine, call LEClick on the EditLine record
5250 7EE6              ;
5251 7EE6 A5 22        CheckEditLine lda   <PartCode
5252 7EE8 C9 0B 00              cmp   #inEditLine
5253 7EEB D0 1F                 bne   CheckNoTrack
5254 7EED
5255 7EED F4 00 00 7B           pushzptr Event 
5256 7EF6 A0 1E 00 B7           pushlong [<ControlPtr],CtrlData   ; hLE is in CtrlData field
5257 7F02 A2 14 0D 22           _LEClick 
5258 7F09
5259 7F09 82 D3 01              brl   EnableTest               ; don't track an EditLine item
5260 7F0C
5261 7F0C              ;
5262 7F0C              ; If PartCode is inStatText or inUserItem, does not call TrackControl
5263 7F0C              ;
5264 7F0C A5 22        CheckNoTrack lda   <PartCode
5265 7F0E C9 09 00              cmp   #inStatText
5266 7F11 F0 14                 beq   NoTrack
5267 7F13 C9 0C 00              cmp   #inUserItem
5268 7F16 F0 0F                 beq   NoTrack
5269 7F18 C9 0D 00              cmp   #inLongStatText
5270 7F1B F0 0A                 beq   NoTrack
5271 7F1D C9 0F 00              cmp   #inLongStatText2         ; DAN H. (for LongStatText2)
5272 7F20 F0 05                 beq   NoTrack                  ; DAN H.
5273 7F22 C9 0E 00              cmp   #inIconItem
5274 7F25 D0 03                 bne   CheckScroll
5275 7F27
5276 7F27 82 B5 01     NoTrack  brl   EnableTest
5277 7F2A
5278 7F2A              ;
5279 7F2A              ; If PartCode is in up/down arrow or page up/down or thumb, special track
5280 7F2A              ;
5281 7F2A A5 22        CheckScroll lda   <PartCode
5282 7F2C C9 05 00              cmp   #UP_PART
5283 7F2F F0 35                 beq   ScrollTrack
5284 7F31 C9 06 00              cmp   #DOWN_PART
5285 7F34 F0 30                 beq   ScrollTrack
5286 7F36 C9 07 00              cmp   #UPP_PART
5287 7F39 F0 2B                 beq   ScrollTrack
5288 7F3B C9 08 00              cmp   #DOWNP_PART
5289 7F3E F0 26                 beq   ScrollTrack
5290 7F40 C9 81 00              cmp   #THUMB_PART
5291 7F43 F0 21                 beq   ScrollTrack
5292 7F45
5293 7F45              ;
5294 7F45              ; Call TrackControl
5295 7F45              ;
5296 7F45 48           StdTrack pha                            ; space for partcode
5297 7F46 A5 0C 48 A5           pushlong Event+where 
5298 7F4C A9 FF FF              lda   #-1                      ; use control action procedure
5299 7F4F 48                    pha   
5300 7F50 48                    pha   
5301 7F51 A5 1C 48 A5           pushlong Control 
5302 7F57 A2 10 15 22           _TrackControl 
5303 7F5E 68 85 22              pullword <PartCode             ; if PartCode=0, mouse released outside
5304 7F61 F0 44                 beq   MDnoitem                 ; of item, so no item hit.
5305 7F63
5306 7F63              ;
5307 7F63              ; If an item has been hit, call EnableTest to see if should return or not.
5308 7F63              ;
5309 7F63 82 79 01              brl   EnableTest
5310 7F66
5311 7F66              ;
5312 7F66              ; Call a special action procedure for scroll bar items
5313 7F66              ;
5314 7F66
5315 7F66 48           ScrollTrack pha                         ; space for partcode
5316 7F67 A5 0C 48 A5           pushlong Event+where 
5317 7F6D F4 FC 00 F4           pushlong #scroll_action 
5318 7F73 A5 1C 48 A5           pushlong Control 
5319 7F79 A2 10 15 22           _TrackControl 
5320 7F80 68 85 22              pullword <PartCode 
5321 7F83 F0 22                 beq   MDnoitem
5322 7F85
5323 7F85 82 57 01              brl   EnableTest
5324 7F88
5325 7F88              ;
5326 7F88              ; Call the Sound Procedure with the sound number 1
5327 7F88              ;
5328 7F88 F4 01 00     Beep     pushword #1 
5329 7F8B
5330 7F8B A0 89 00              ldy   #AlertSoundProc+1        ; look if there is a custom sound
5331 7F8E B7 24                 lda   [<Globals],y             ; (X = bits 8-23)
5332 7F90 88                    dey                            ; Y = AlertSoundProc
5333 7F91 AA                    tax   
5334 7F92 D0 0B                 bne   CallCustomSound
5335 7F94
5336 7F94 88                    dey                            ; test now low byte
5337 7F95 B7 24                 lda   [<Globals],y
5338 7F97 D0 06                 bne   CallCustomSound
5339 7F99
5340 7F99 22 EB 82 FC           jsl   StdSoundProc             ; call standard sound proc
5341 7F9D 80 0C                 bra   MDexit
5342 7F9F
5343 7F9F              CallCustomSound  
5344 7F9F B7 24                 lda   [<Globals],y             ; X already=bits 8-23, Y=AlertSoundProc
5345 7FA1 22 52 89 FC           jsl   long_call                ; and A = low byte of procedure address
5346 7FA5 80 04                 bra   MDexit
5347 7FA7
5348 7FA7              MDnoitem  
5349 7FA7 64 36                 stz   <itemHit
5350 7FA9 64 22                 stz   <PartCode
5351 7FAB
5352 7FAB              MDexit    
5353 7FAB 82 A4 FE              brl   NextModalEvent
5354 7FAE
5355 7FAE              ;______________________________________________________________________________
5356 7FAE              ;
5357 7FAE              ;        KeyDownEvent
5358 7FAE              ;______________________________________________________________________________
5359 7FAE
5360 7FAE              KeyDownEvent  
5361 7FAE
5362 7FAE              ;
5363 7FAE              ; Check if there is an active editLine item
5364 7FAE              ;
5365 7FAE A0 14 01              ldy   #edittextID-wport
5366 7FB1 B7 14                 lda   [<Dialog],y
5367 7FB3 D0 03                 bne   editok                   ; if current edit item ID = 0, no item
5368 7FB5 82 99 00              brl   KDnoitem
5369 7FB8
5370 7FB8 AA           editok   tax   
5371 7FB9
5372 7FB9              ;
5373 7FB9              ; If there is one, get the control handle to it.
5374 7FB9              ;
5375 7FB9 48                    pha                            ; space for control
5376 7FBA 48                    pha   
5377 7FBB A5 16 48 A5           pushlong Dialog 
5378 7FC1 DA                    phx   
5379 7FC2 A2 15 1E 22           _GetControlDItem 
5380 7FC9 90 03 82 81           Check_Error KDnotFound 
5381 7FCE 68 85 1A 68           pulllong <Control 
5382 7FD4
5383 7FD4              ;
5384 7FD4              ; If the typed character is a tab character, change the active EditLine item
5385 7FD4              ;
5386 7FD4 A5 02        CheckTab lda   <Event+message           ; char in lo order byte (check doc.)
5387 7FD6 29 FF 00              and   #$FF                     ;DAN H. FIX (changed from 7F)
5388 7FD9 C9 09 00              cmp   #9                       ; TAB = ASCII 9
5389 7FDC D0 29                 bne   CheckAppleKey
5390 7FDE
5391 7FDE              ;
5392 7FDE              ; Find next EditLine item in dialog
5393 7FDE              ;
5394 7FDE 48                    pha                            ; space for result
5395 7FDF A5 16 48 A5           pushlong Dialog 
5396 7FE5 A5 1C 48 A5           pushlong Control 
5397 7FEB 22 19 83 FC           jsl   FindNextEditLine
5398 7FEF FA                    plx   
5399 7FF0
5400 7FF0              ;
5401 7FF0              ; Make it the new active EditLine item and select the line
5402 7FF0              ;
5403 7FF0 A5 16 48 A5           pushlong Dialog 
5404 7FF6 DA                    phx   
5405 7FF7 F4 00 00              pushword #0 
5406 7FFA F4 FF 7F              pushword #32767 
5407 7FFD A2 15 21 22           _SelIText 
5408 8004
5409 8004 82 4A 00              brl   KDnoitem
5410 8007
5411 8007              ;
5412 8007              ; If Apple Key is down, does not pass the character to LineEdit (except arrows)
5413 8007              ; but report that the item has been hit
5414 8007              ;
5415 8007 A5 0E        CheckAppleKey lda   <Event+modif
5416 8009 29 00 01              and   #$0100                   ; Test AppleKey modifier bit
5417 800C F0 12                 beq   CallLineEdit
5418 800E A5 02                 lda   <Event+message           ; char in lo order byte (check doc.)
5419 8010 29 FF 00              and   #$FF                     ;DAN H. FIX (changed from 7f)
5420 8013 C9 08 00              cmp   #8                       ; left arrow
5421 8016 F0 08                 beq   CallLineEdit
5422 8018 C9 15 00              cmp   #21                      ; right arrow
5423 801B F0 03                 beq   CallLineEdit
5424 801D 82 BF 00              brl   EnableTest
5425 8020
5426 8020              ;
5427 8020              ; Pass the typed character to Line Edit
5428 8020              ;
5429 8020 A7 1A 85 1E  CallLineEdit movelong [<Control],0,<ControlPtr 
5430 802B
5431 802B A5 02                 lda   <Event+message           ; char in lo order byte (check doc.)
5432 802D 29 FF 00              and   #$FF
5433 8030 48                    pha   
5434 8031 A5 0E 48              pushword Event+modif 
5435 8034 A0 1E 00 B7           pushlong [<ControlPtr],CtrlData   ; LEHandle in CtrlData
5436 8040 A2 14 11 22           _LEKey 
5437 8047
5438 8047              ;
5439 8047              ; Item involved is an EditLine item, PartCode is inEditLine
5440 8047              ;
5441 8047 A9 0B 00              lda   #inEditLine
5442 804A 85 22                 sta   <PartCode
5443 804C
5444 804C              ;
5445 804C              ; Call EnableTest to see if editText item is enabled or not.
5446 804C              ;
5447 804C 82 90 00              brl   EnableTest
5448 804F
5449 804F              ;
5450 804F              ; Goes here if could not find current EditLine item
5451 804F              ;
5452 804F FA           KDnotFound plx   
5453 8050 FA                    plx   
5454 8051
5455 8051 64 36        KDnoitem stz   <itemHit
5456 8053 64 22                 stz   <PartCode
5457 8055
5458 8055 82 FA FD     KDexit   brl   NextModalEvent
5459 8058
5460 8058
5461 8058              ;______________________________________________________________________________
5462 8058              ;
5463 8058              ;        UpdateEvent
5464 8058              ;
5465 8058              ; Note: The update event may or may not be for our window.  In case we're
5466 8058              ;       stuck attempting to handle somebody else's update events, we'll do
5467 8058              ;       the I-beam cursor polling during Update as well as Null events.
5468 8058              ;
5469 8058              ;______________________________________________________________________________
5470 8058
5471 8058              UpdateEvent  
5472 8058              ;
5473 8058              ; Redraws the dialog's content
5474 8058              ;
5475 8058 A5 16 48 A5           pushlong Dialog 
5476 805E A2 0E 1E 22           _BeginUpdate 
5477 8065
5478 8065 A5 16 48 A5           pushlong Dialog 
5479 806B A2 15 16 22           _DrawDialog 
5480 8072
5481 8072 A5 16 48 A5           pushlong Dialog 
5482 8078 A2 0E 1F 22           _EndUpdate 
5483 807F
5484 807F 64 36                 stz   <itemHit
5485 8081 64 22                 stz   <PartCode
5486 8083
5487 8083 82 CC FD              brl   NextModalEvent
5488 8086
5489 8086
5490 8086              ;_____________________________________________________________________________
5491 8086              ;
5492 8086              ;        ActivateEvent
5493 8086              ;______________________________________________________________________________
5494 8086
5495 8086              ActivateEvent  
5496 8086              ;
5497 8086              ; Activate the current EditLine item
5498 8086              ;
5499 8086 A0 14 01              ldy   #edittextID-wport
5500 8089 B7 14                 lda   [<Dialog],y
5501 808B F0 47                 beq   Actexit
5502 808D AA                    tax   
5503 808E
5504 808E 48                    pha                            ; space for control
5505 808F 48                    pha   
5506 8090 A5 16 48 A5           pushlong Dialog 
5507 8096 DA                    phx   
5508 8097 A2 15 1E 22           _GetControlDItem 
5509 809E B0 3B                 bcs   ActNotFound
5510 80A0 68 85 1A 68           pulllong <Control 
5511 80A6
5512 80A6 A7 1A 85 1E           movelong [<Control],0,<ControlPtr 
5513 80B1 A0 1E 00 B7           pushlong [<ControlPtr],CtrlData 
5514 80BD
5515 80BD              ;
5516 80BD              ; If dialog is now active, activate EditLine item, otherwise deactivate it
5517 80BD              ;
5518 80BD A5 0E                 lda   <Event+modif
5519 80BF 29 01 00              and   #$0001                   ; get active flag
5520 80C2 D0 09                 bne   ActivateIt
5521 80C4
5522 80C4 A2 14 10 22           _LEDeactivate 
5523 80CB
5524 80CB 80 07                 bra   Actexit
5525 80CD
5526 80CD              ActivateIt                              ; 
5527 80CD A2 14 0F 22           _LEActivate 
5528 80D4
5529 80D4              Actexit                                 ; 
5530 80D4 64 36                 stz   <itemHit
5531 80D6 64 22                 stz   <PartCode
5532 80D8
5533 80D8 82 77 FD              brl   NextModalEvent
5534 80DB
5535 80DB              ;
5536 80DB              ; Goes here if could not find current EditLine item
5537 80DB              ;
5538 80DB              ActNotFound                             ; 
5539 80DB FA                    plx   
5540 80DC FA                    plx   
5541 80DD 80 F5                 bra   Actexit
5542 80DF
5543 80DF
5544 80DF              ;______________________________________________________________________________
5545 80DF              ;
5546 80DF              ;        EnableTest
5547 80DF              ;
5548 80DF              ;       input: control handle to item hit is in the local "Control".
5549 80DF              ;
5550 80DF              ;      function: go there if an item hit. Returns itemHit if item enabled.
5551 80DF              ;                Returns 0 if item disabled.
5552 80DF              ;______________________________________________________________________________
5553 80DF
5554 80DF              EnableTest                              ; 
5555 80DF
5556 80DF              ;
5557 80DF              ; If item hit, look if item is enabled or not
5558 80DF              ;
5559 80DF A7 1A 85 1E           movelong [<Control],0,<ControlPtr 
5560 80EA A0 22 00              ldy   #iitemtype
5561 80ED B7 1E                 lda   [<ControlPtr],y
5562 80EF 29 00 80              and   #ItemDisable             ; if itemdisable, does not return
5563 80F2 D0 09                 bne   ETnoitem
5564 80F4
5565 80F4              ;
5566 80F4              ; If item enabled, returns item ID
5567 80F4              ;
5568 80F4 A0 20 00 B7           moveword [<ControlPtr],iitemid,<itemHit 
5569 80FB 80 04                 bra   ETexit
5570 80FD
5571 80FD              ETnoitem                                ; 
5572 80FD 64 36                 stz   <itemHit
5573 80FF 64 22                 stz   <PartCode
5574 8101
5575 8101              ETexit                                  ; 
5576 8101 82 4E FD              brl   NextModalEvent
5577 8104
5578 8104                       ENDP 
5579 8104
5580 8104
5581 8104              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
5582 8104              ;
5583 8104              ;        WindowIsDialog
5584 8104              ;
5585 8104              ;       input: theDialog:LONG - pointer to the (supposedly) dialog port
5586 8104              ;              DialogType:WORD - type of dialog (Modal or Modeless)
5587 8104              ;
5588 8104              ;      output: carry set if Window is not specified kind of dialog
5589 8104              ;
5590 8104              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
5591 8104
5592 8104                       ENTRY WindowIsDialog
5593 8104              WindowIsDialog PROC 
5594 8104
5595 8104              DialogHdl equ   0
5596 8104              SizeLocals equ   DialogHdl+4
5597 8104
5598 8104 3B 38 E9 04           link 6,SizeLocals 
5599 810D
5600 810D              DialogType equ   input
5601 810D              theDialog equ   DialogType+2
5602 810D
5603 810D
5604 810D A5 09 A4 0B           lday <theDialog
5605 8111 20 39 89              jsr   dlg2handle               ; try to convert dialog to handle
5606 8114
5607 8114 C9 00 00              cmp   #0                       ; if the handle doesnt exist, the front
5608 8117 D0 0A                 bne   frontisalloc             ; window cant be a dialog
5609 8119 C0 00 00              cpy   #0
5610 811C D0 05                 bne   frontisalloc
5611 811E A9 01 00              lda   #1                       ; make unlink set the carry
5612 8121 80 28                 bra   exit
5613 8123
5614 8123              frontisalloc                            ; 
5615 8123 48                    pha                            ; get size of handle
5616 8124 48                    pha                            ; (space for result)
5617 8125 5A 48                 pushay 
5618 8127 A2 02 18 22           _GetHandleSize 
5619 812E 68 7A                 pullay 
5620 8130
5621 8130 C9 1C 01              cmp   #DLGSIZE                 ; if Handle Size is not the size
5622 8133 D0 05                 bne   notDialog                ; of a dialog record, cant be a dialog
5623 8135 C0 00 00              cpy   #0
5624 8138 F0 05                 beq   righthdlsize
5625 813A
5626 813A              notDialog                               ; 
5627 813A A9 01 00              lda   #1                       ; make unlink set the carry
5628 813D 80 0C                 bra   exit
5629 813F
5630 813F              righthdlsize                            ; 
5631 813F A0 12 01              ldy   #dlgtype-wport           ; if DialogRec->dlgtype = DialogType,
5632 8142 B7 09                 lda   [<theDialog],y           ; it is the correct kind of dialog
5633 8144 C5 07                 cmp   <DialogType
5634 8146 D0 F2                 bne   notDialog
5635 8148
5636 8148 A9 00 00              lda   #0                       ; make unlink clear the carry
5637 814B
5638 814B              exit                                    ; 
5639 814B 2B A8 A3 06           unlink 
5640 815F 6B                    rtl   
5641 8160
5642 8160                       ENDP 
5643 8160
5644 8160
5645 8160              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
5646 8160              ;
5647 8160              ;        BlinkCaret
5648 8160              ;
5649 8160              ;       input: theDialog:LONG - pointer to the dialog port
5650 8160              ;
5651 8160              ;      output: none
5652 8160              ;
5653 8160              ;    function: Blink the caret if there is an EditLine item in theDialog
5654 8160              ;
5655 8160              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
5656 8160
5657 8160                       ENTRY BlinkCaret
5658 8160              BlinkCaret PROC 
5659 8160
5660 8160              Control  equ   0
5661 8160              ControlPtr equ   Control+4
5662 8160              SizeLocals equ   ControlPtr+4
5663 8160
5664 8160 3B 38 E9 08           link 4,SizeLocals 
5665 8169
5666 8169              theDialog equ   input
5667 8169
5668 8169              ;
5669 8169              ; Call LEIdle on the current active Edit Line Item (if there is one)
5670 8169              ;
5671 8169              ;
5672 8169 A0 14 01              ldy   #edittextID-wport
5673 816C B7 0B                 lda   [<theDialog],y
5674 816E F0 37                 beq   exit
5675 8170 AA                    tax   
5676 8171
5677 8171 48                    pha                            ; space for control
5678 8172 48                    pha   
5679 8173 A5 0D 48 A5           pushlong theDialog 
5680 8179 DA                    phx   
5681 817A A2 15 1E 22           _GetControlDItem 
5682 8181 B0 39                 bcs   notFound
5683 8183 68 85 00 68           pulllong <Control 
5684 8189
5685 8189 A7 00 85 04           movelong [<Control],0,<ControlPtr 
5686 8194 A0 1E 00 B7           pushlong [<ControlPtr],CtrlData 
5687 81A0 A2 14 0C 22           _LEIdle                        ; returns Line Edit Error Status
5688 81A7
5689 81A7              exit                                    ; 
5690 81A7 2B A8 A3 0A           unlink 
5691 81BB 6B                    rtl   
5692 81BC
5693 81BC              notFound                                ; 
5694 81BC FA                    plx   
5695 81BD FA                    plx   
5696 81BE 80 E7                 bra   exit
5697 81C0
5698 81C0                       ENDP 
5699 81C0
5700 81C0
5701 81C0              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
5702 81C0              ;
5703 81C0              ;        StdFilterProc
5704 81C0              ;
5705 81C0              ;       input: theDialog:LONG - pointer to the dialog port
5706 81C0              ;              theEvent:LONG - pointer to the Event.
5707 81C0              ;              itemHit:LONG - pointer to itemHit.
5708 81C0              ;
5709 81C0              ;      output: result:WORD - TRUE if must return.
5710 81C0              ;
5711 81C0              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
5712 81C0
5713 81C0                       ENTRY StdFilterProc
5714 81C0              StdFilterProc PROC 
5715 81C0
5716 81C0              Control  equ   0
5717 81C0              ControlPtr equ   Control+4
5718 81C0              SizeLocals equ   ControlPtr+4
5719 81C0
5720 81C0 3B 38 E9 08           link 12,SizeLocals 
5721 81C9
5722 81C9              itemHit  equ   input
5723 81C9              theEvent equ   itemHit+4
5724 81C9              theDialog equ   theEvent+4
5725 81C9
5726 81C9              result   equ   output
5727 81C9
5728 81C9              ;
5729 81C9              ; Assume we won't want to bypass modaldialog
5730 81C9              ;
5731 81C9 64 17                 stz   <result
5732 81CB
5733 81CB              ;
5734 81CB              ; Filters only KeyDown and AutoKey event
5735 81CB              ;
5736 81CB A0 00 00              ldy   #what
5737 81CE B7 0F                 lda   [<theEvent],y
5738 81D0 C9 03 00              cmp   #inKey
5739 81D3 F0 08                 beq   FilterIt
5740 81D5
5741 81D5 C9 05 00              cmp   #inAutoKey
5742 81D8 F0 03                 beq   FilterIt
5743 81DA 82 F5 00              brl   exit
5744 81DD
5745 81DD              ;
5746 81DD              ; Apple-X, Apple-C, Apple-V handled as Cut/Copy/Paste
5747 81DD              ;
5748 81DD              FilterIt  
5749 81DD A0 0E 00              ldy   #modif
5750 81E0 B7 0F                 lda   [<theEvent],y
5751 81E2 29 00 01              and   #$0100                   ; Test AppleKey modifier bit
5752 81E5 F0 4A                 beq   TestReturn
5753 81E7
5754 81E7 A0 02 00              ldy   #message
5755 81EA B7 0F                 lda   [<theEvent],y
5756 81EC 29 FF 00              and   #$FF                     ;DAN H. FIX get character in lo byte
5757 81EF 09 20 00              ora   #'a'-'A'                 ; convert it to lower case
5758 81F2
5759 81F2 C9 78 00              cmp   #'x'
5760 81F5 D0 10                 bne   isCopy
5761 81F7 A5 15 48 A5           pushlong theDialog 
5762 81FD A2 15 12 22           _DlgCut 
5763 8204 82 CB 00              brl   exit
5764 8207
5765 8207              isCopy    
5766 8207 C9 63 00              cmp   #'c'
5767 820A D0 10                 bne   isPaste
5768 820C A5 15 48 A5           pushlong theDialog 
5769 8212 A2 15 13 22           _DlgCopy 
5770 8219 82 B6 00              brl   exit
5771 821C
5772 821C              isPaste   
5773 821C C9 76 00              cmp   #'v'
5774 821F D0 10                 bne   TestReturn
5775 8221 A5 15 48 A5           pushlong theDialog 
5776 8227 A2 15 14 22           _DlgPaste 
5777 822E 82 A1 00              brl   exit
5778 8231
5779 8231              ;
5780 8231              ; Handles a Return as mouse down in default button
5781 8231              ;
5782 8231              TestReturn  
5783 8231 A0 02 00              ldy   #message
5784 8234 B7 0F                 lda   [<theEvent],y
5785 8236 29 FF 00              and   #$FF                     ;DAN H. FIX get character in lo byte
5786 8239 C9 0D 00              cmp   #13
5787 823C F0 03                 beq   *+5
5788 823E 82 91 00              brl   exit
5789 8241
5790 8241              ;
5791 8241              ; Get a handle to the default item
5792 8241              ;
5793 8241 48                    pha                            ; space for control
5794 8242 48                    pha   
5795 8243 A5 15 48 A5           pushlong theDialog 
5796 8249 A0 16 01              ldy   #defbutID-wport
5797 824C B7 13                 lda   [<theDialog],y
5798 824E 48                    pha   
5799 824F A2 15 1E 22           _GetControlDItem 
5800 8256 90 03 82 8C           Check_Error notFound 
5801 825B 68 85 00 68           pulllong <Control 
5802 8261
5803 8261              ;
5804 8261              ; Check that default item is a button
5805 8261              ;
5806 8261 A7 00 85 04           movelong [<Control],0,<ControlPtr 
5807 826C A0 22 00              ldy   #iitemtype
5808 826F B7 04                 lda   [<ControlPtr],y
5809 8271 29 FF 7F              and   #$7FFF                   ; get rid of item disable bit
5810 8274 C9 0A 00              cmp   #ButtonItem
5811 8277 F0 03                 beq   *+5
5812 8279 82 56 00              brl   exit                     ; if not button, exit
5813 827C
5814 827C              ;
5815 827C              ; Check that the default button is visible and active
5816 827C              ;
5817 827C A0 10 00              ldy   #CtrlFlag
5818 827F B7 04                 lda   [<ControlPtr],y
5819 8281 AA                    tax   
5820 8282 29 80 00              and   #CTRL_INVIS              ; invisible?
5821 8285 D0 4B                 bne   exit
5822 8287
5823 8287 8A                    txa   
5824 8288 29 00 FF              and   #C_HILITE
5825 828B EB                    xba                            ; C_Hilite Flag is in high byte
5826 828C C9 FF 00              cmp   #255                     ; inactive?
5827 828F F0 41                 beq   exit
5828 8291
5829 8291              ;
5830 8291              ; Hilite the default button and unhilite it
5831 8291              ;
5832 8291 F4 02 00              pushword #2 
5833 8294 A5 02 48 A5           pushlong Control 
5834 829A A2 10 11 22           _HiliteControl 
5835 82A1
5836 82A1 F4 00 00              pushword #0 
5837 82A4 A5 02 48 A5           pushlong Control 
5838 82AA A2 10 11 22           _HiliteControl 
5839 82B1
5840 82B1              ;
5841 82B1              ; Returns with itemHit = default button if not disabled (shouldn't be)
5842 82B1              ;
5843 82B1 A7 00 85 04           movelong [<Control],0,<ControlPtr 
5844 82BC A0 22 00              ldy   #iitemtype
5845 82BF B7 04                 lda   [<ControlPtr],y
5846 82C1 29 00 80              and   #ItemDisable             ; if itemdisable, does not return TRUE
5847 82C4 D0 0C                 bne   exit
5848 82C6
5849 82C6              ;
5850 82C6              ; If item enabled, returns item ID
5851 82C6              ;
5852 82C6 A0 16 01 B7           moveword [<theDialog],defbutID-wport,[<itemHit] 
5853 82CD A9 01 00              lda   #1                       ; returns directly to application
5854 82D0 85 17                 sta   <result
5855 82D2
5856 82D2              exit      
5857 82D2 2B A8 A3 0A           unlink 
5858 82E6 6B                    rtl   
5859 82E7
5860 82E7              notFound  
5861 82E7 FA                    plx   
5862 82E8 FA                    plx   
5863 82E9 80 E7                 bra   exit
5864 82EB
5865 82EB                       ENDP 
5866 82EB
5867 82EB
5868 82EB              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
5869 82EB              ;
5870 82EB              ;        StdSoundProc
5871 82EB              ;
5872 82EB              ;       input: SoundNum:WORD - number of the sound.
5873 82EB              ;              Carry flag set if they clicked outside window (24-Sep-90 DAL)
5874 82EB              ;
5875 82EB              ;      output: none.
5876 82EB              ;
5877 82EB              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
5878 82EB
5879 82EB                       ENTRY StdSoundProc
5880 82EB              StdSoundProc PROC 
5881 82EB
5882 82EB 3B 38 E9 00           link 2 
5883 82F4
5884 82F4              SoundNum equ   input
5885 82F4              ;
5886 82F4              ; Call the BEEP routine
5887 82F4              ;
5888 82F4              CallBELL  
5889 82F4 C6 03                 dec   <SoundNum
5890 82F6 30 09                 bmi   exit
5891 82F8
5892 82F8 A2 03 2C 22           _SysBeep 
5893 82FF 80 F3                 bra   CallBELL
5894 8301
5895 8301              exit      
5896 8301 A9 00 00              lda   #0
5897 8304 2B A8 A3 02           unlink 
5898 8318 6B                    rtl   
5899 8319
5900 8319                       ENDP 
5901 8319
5902 8319
5903 8319              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
5904 8319              ;
5905 8319              ;        FindNextEditLine
5906 8319              ;
5907 8319              ;       input: theDialog:LONG - pointer to dialog port
5908 8319              ;              PrevLEControl:LONG - control handle of previous EditLine item
5909 8319              ;
5910 8319              ;      output: NextLEID:WORD - ID of next EditLine item
5911 8319              ;
5912 8319              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
5913 8319
5914 8319                       ENTRY FindNextEditLine
5915 8319              FindNextEditLine PROC 
5916 8319
5917 8319              ControlPtr equ   0
5918 8319              SizeLocals equ   ControlPtr+4
5919 8319
5920 8319 3B 38 E9 04           link 8,SizeLocals 
5921 8322
5922 8322              PrevLEControl equ   input
5923 8322              theDialog equ   PrevLEControl+4
5924 8322
5925 8322              NextLEID equ   output
5926 8322
5927 8322              ;
5928 8322              ; Get Next item in dialog
5929 8322              ;
5930 8322              nextItem  
5931 8322 A7 07 85 00           movelong [PrevLEControl],0,<ControlPtr 
5932 832D A0 00 00 B7           movelong [<ControlPtr],CtrlNext,<PrevLEControl 
5933 833B
5934 833B A5 07                 lda   <PrevLEControl
5935 833D D0 04                 bne   CheckEditLine
5936 833F A5 09                 lda   <PrevLEControl+2
5937 8341 F0 37                 beq   RestartFromBeginning     ; if end of list, go to beginning
5938 8343
5939 8343              ;
5940 8343              ; Check if this item is an EditLine item
5941 8343              ;
5942 8343              CheckEditLine  
5943 8343 A7 07 85 00           movelong [PrevLEControl],0,<ControlPtr 
5944 834E A0 22 00              ldy   #iitemtype
5945 8351 B7 00                 lda   [<ControlPtr],y
5946 8353 29 FF 7F              and   #$7FFF                   ; get rid of item disable bit
5947 8356 C9 11 00              cmp   #EditLine
5948 8359 D0 C7                 bne   NextItem                 ; if not, next item
5949 835B
5950 835B A0 20 00              ldy   #iitemid
5951 835E B7 00                 lda   [<ControlPtr],y
5952 8360 85 0F                 sta   <NextLEID
5953 8362
5954 8362 A9 00 00              lda   #0
5955 8365 2B A8 A3 06           unlink 
5956 8379 6B                    rtl   
5957 837A
5958 837A              ;
5959 837A              ; If end of list reached, wraparound until we find (at least) the Prev EditLine
5960 837A              ;
5961 837A              RestartFromBeginning                    ; get first item in dialog
5962 837A A0 C6 00 B7           movelong [<theDialog],wcontrol-wport,<PrevLEControl 
5963 8388 80 B9                 bra   CheckEditLine
5964 838A
5965 838A                       ENDP 
5966 838A
5967 838A
5968 838A              ;_____________________________________________________________________________
5969 838A              ;
5970 838A              ;        DefaultFilter
5971 838A              ;
5972 838A              ;       input: theDialog:LONG - pointer to the dialog port
5973 838A              ;              theEvent:LONG - pointer to the Event.
5974 838A              ;              itemHit:LONG - pointer to itemHit.
5975 838A              ;
5976 838A              ;      output: result:WORD - TRUE if event filtered
5977 838A              ;_____________________________________________________________________________
5978 838A
5979 838A                       ENTRY DefaultFilter
5980 838A              DefaultFilter PROC 
5981 838A
5982 838A 3B 38 E9 00           tlink 12 
5983 8393
5984 8393              itemHit  equ   input
5985 8393              theEvent equ   itemHit+4
5986 8393              theDialog equ   theEvent+4
5987 8393
5988 8393              result   equ   output
5989 8393
5990 8393 A5 10 48 A5           pushlong theDialog 
5991 8399 A5 0C 48 A5           pushlong theEvent 
5992 839F A5 08 48 A5           pushlong itemHit 
5993 83A5 22 C0 81 FC           jsl   StdFilterProc
5994 83A9 68 85 12              pullword <result 
5995 83AC
5996 83AC A9 00 00              lda   #0
5997 83AF 2B A8 A3 05           tunlink 
5998 83C7 6B                    rtl   
5999 83C8                       ENDP 
6000 83C8
6001 83C8
6002 83C8              ;            copy  Modeless.asm
6003 83C8              ; Modeless.asm                          Jean-Charles Mourey
6004 83C8
6005 83C8                       TITLE 'Modeless Dialog Routine'
6006 83C8
6007 83C8
6008 83C8              ;____________________________________________________________________________
6009 83C8              ;
6010 83C8              ;        IsDialogEvent
6011 83C8              ;
6012 83C8              ;       input: theEvent:LONG - pointer to the Event Record
6013 83C8              ;
6014 83C8              ;      output: result:WORD - TRUE if it is a dialog event
6015 83C8              ;
6016 83C8              ;_____________________________________________________________________________
6017 83C8
6018 83C8                       ENTRY IsDialogEvent
6019 83C8              IsDialogEvent PROC 
6020 83C8
6021 83C8              Window   equ   0                        ;MUST BE ZERO 17-Sep-90 DAL
6022 83C8              Dialog   equ   Window+4
6023 83C8              SizeLocals equ   Dialog+4
6024 83C8
6025 83C8 3B 38 E9 08           tlink 4,SizeLocals 
6026 83D1
6027 83D1              theEvent equ   input
6028 83D1
6029 83D1              result   equ   output
6030 83D1
6031 83D1              ;
6032 83D1              ; Initialize result to FALSE
6033 83D1              ;
6034 83D1 64 12                 stz   <result
6035 83D3
6036 83D3              ;
6037 83D3              ; Test if front window is a modeless dialog
6038 83D3              ;
6039 83D3 48                    pha                            ; space for window pointer
6040 83D4 48                    pha   
6041 83D5 A2 0E 15 22           _FrontWindow 
6042 83DC
6043 83DC A3 01                 lda   1,s                      ; get dialog pointer without pulling it
6044 83DE 85 04                 sta   <Dialog
6045 83E0 A3 03                 lda   3,s
6046 83E2 85 06                 sta   <Dialog+2
6047 83E4
6048 83E4 F4 02 00              pushword #Modeless_Type        ; dialog is still on stack
6049 83E7 22 04 81 FC           jsl   WindowIsDialog
6050 83EB B0 53                 bcs   FrontNotModeless
6051 83ED
6052 83ED              ;
6053 83ED              ; Is it a mouse down event in the content region of the active dialog
6054 83ED              ;
6055 83ED A0 00 00              ldy   #what
6056 83F0 B7 0E                 lda   [<theEvent],y
6057 83F2 C9 09 00              cmp   #9                       ; is it a switch event or higher?
6058 83F5 B0 47                 bcs   bnoerror                 ; don't claim them
6059 83F7 C9 08 00              cmp   #inActWind
6060 83FA F0 53                 beq   TestForDialog
6061 83FC C9 06 00              cmp   #inUpdate
6062 83FF F0 4E                 beq   TestForDialog
6063 8401
6064 8401 C9 01 00              cmp   #inButtDwn               ; if other than mouse down, it is
6065 8404 D0 33                 bne   ReturnTrue
6066 8406
6067 8406              ;
6068 8406              ; Find window and location in window of mouse down event
6069 8406              ;
6070 8406 48                    pha                            ; space for location
6071 8407 F4 00 00 7B           pushzptr Window 
6072 8410 A0 0C 00 B7           pushlong [<theEvent],where 
6073 841C A2 0E 17 22           _FindWindow 
6074 8423 68                    pla   
6075 8424 29 FF 7F              and   #$7FFF                   ; get rid of InSysWindow bit
6076 8427 AA                    tax                            ; X contains location
6077 8428
6078 8428              ;
6079 8428              ; If not in our dialog, not dialog event
6080 8428              ;
6081 8428 A5 00                 lda   <Window
6082 842A C5 04                 cmp   <Dialog
6083 842C D0 4B                 bne   noerror
6084 842E A5 02                 lda   <Window+2
6085 8430 C5 06                 cmp   <Dialog+2
6086 8432 D0 45                 bne   noerror
6087 8434
6088 8434              ;
6089 8434              ; Test that location is in the content region
6090 8434              ;
6091 8434 E0 13 00              cpx   #winContent              ; only return true of wincontent, HY 7/13/88
6092 8437 D0 40                 bne   noerror                  ; if not mouse down in content
6093 8439                                                      ; of modeless dialog then handle
6094 8439                                                      ; taskmaster event as normal
6095 8439                         
6096 8439 A9 01 00     returnTRUE lda   #1
6097 843C 85 12                 sta   <result
6098 843E
6099 843E 80 39        bnoerror bra   noerror
6100 8440
6101 8440              ;
6102 8440              ; If front window is not a modeless dialog, is it an activate/update event in
6103 8440              ; a dialog ?
6104 8440              ;
6105 8440              FrontNotModeless  
6106 8440 A0 00 00              ldy   #what
6107 8443 B7 0E                 lda   [<theEvent],y
6108 8445 C9 08 00              cmp   #inActWind
6109 8448 F0 05                 beq   TestForDialog
6110 844A C9 06 00              cmp   #inUpdate
6111 844D D0 2A                 bne   noerror                  ; not activate nor update, so exit
6112 844F
6113 844F              TestForDialog  
6114 844F A0 04 00 B7           pushlong [<theEvent],message 
6115 845B F4 02 00              pushword #Modeless_Type        ; DAN H. (changed from Modeless_type)
6116 845E 22 04 81 FC           jsl   WindowIsDialog
6117 8462 90 D5                 bcc   returnTRUE               ; DAN H. (branch if modal or modeless)
6118 8464
6119 8464 A0 04 00 B7           pushlong [<theEvent],message 
6120 8470 F4 01 00              pushword #Modal_Type           ; DAN H. (changed from Modeless_type)
6121 8473 22 04 81 FC           jsl   WindowIsDialog
6122 8477 90 C0                 bcc   returnTRUE               ; DAN H. (branch if modal or modeless)
6123 8479
6124 8479 A9 00 00     noerror  lda   #0
6125 847C
6126 847C A2 08 00     exit     ldx   #SizeLocals
6127 847F 4C 75 89              jmp   quit4
6128 8482
6129 8482                       ENDP 
6130 8482
6131 8482
6132 8482              ;_____________________________________________________________________________
6133 8482              ;
6134 8482              ;        DialogSelect
6135 8482              ;
6136 8482              ;       input: theEvent:LONG - pointer to the Event Record
6137 8482              ;              theDialogPtr:LONG - pointer to the dialog pointer
6138 8482              ;              itemHitPtr:LONG - pointer to the itemHit
6139 8482              ;
6140 8482              ;      output: result:WORD - TRUE if event handled by DialogSelect
6141 8482              ;______________________________________________________________________________
6142 8482
6143 8482                       ENTRY DialogSelect
6144 8482              DialogSelect PROC 
6145 8482
6146 8482              Dialog   equ   0
6147 8482              FrontModeless equ   Dialog+4
6148 8482              Control  equ   FrontModeless+2
6149 8482              ControlPtr equ   Control+4
6150 8482              PartCode equ   ControlPtr+4
6151 8482              PortSave equ   PartCode+2
6152 8482              SizeLocals equ   PortSave+4
6153 8482
6154 8482 3B 38 E9 14           tlink 12,SizeLocals 
6155 848B
6156 848B              itemHitPtr equ   input
6157 848B              theDialogPtr equ   itemHitPtr+4
6158 848B              theEvent equ   theDialogPtr+4
6159 848B
6160 848B              result   equ   output
6161 848B
6162 848B              ;
6163 848B              ; Initialize ouputs and flag to zero
6164 848B              ;
6165 848B A9 00 00              lda   #0
6166 848E 85 26                 sta   <result
6167 8490 87 1A                 sta   [<itemHitPtr]
6168 8492
6169 8492 85 04                 sta   <FrontModeless
6170 8494
6171 8494              ;
6172 8494              ; Get the current port
6173 8494              ;
6174 8494 48                    pha                            ; space for port pointer
6175 8495 48                    pha   
6176 8496 A2 04 1C 22           _GetPort 
6177 849D 68 85 10 68           pulllong <PortSave 
6178 84A3
6179 84A3              ;
6180 84A3              ; Blink the caret on the front window if it is a modeless dialog
6181 84A3              ;
6182 84A3 48                    pha                            ; space for window pointer
6183 84A4 48                    pha   
6184 84A5 A2 0E 15 22           _FrontWindow 
6185 84AC
6186 84AC A3 01                 lda   1,s                      ; get dialog pointer without pulling it
6187 84AE 85 00                 sta   <Dialog
6188 84B0 87 1E                 sta   [<theDialogPtr]
6189 84B2 A3 03                 lda   3,s
6190 84B4 85 02                 sta   <Dialog+2
6191 84B6 A0 02 00              ldy   #2
6192 84B9 97 1E                 sta   [<theDialogPtr],y
6193 84BB
6194 84BB F4 02 00              pushword #Modeless_Type        ; dialog is still on stack
6195 84BE 22 04 81 FC           jsl   WindowIsDialog
6196 84C2 B0 46                 bcs   DispEvent
6197 84C4
6198 84C4 A9 01 00              lda   #1                       ; set FrontModeless flag to TRUE
6199 84C7 85 04                 sta   <FrontModeless
6200 84C9
6201 84C9 A5 02 48 A5           pushlong Dialog                ; set current port = the dialog
6202 84CF A2 04 1B 22           _SetPort                       ; only if it is the front window
6203 84D6
6204 84D6 A9 00 00              lda   #0
6205 84D9 48                    pha   
6206 84DA 48                    pha   
6207 84DB A2 04 23 22           _SetOrigin 
6208 84E2
6209 84E2 A5 02 48 A5           pushlong Dialog 
6210 84E8 22 60 81 FC           jsl   BlinkCaret
6211 84EC
6212 84EC              ;
6213 84EC              ; Call standard filter
6214 84EC              ;
6215 84EC 48                    pha                            ; space for filter result
6216 84ED A5 02 48 A5           pushlong Dialog 
6217 84F3 A5 24 48 A5           pushlong theEvent 
6218 84F9 A5 1C 48 A5           pushlong itemHitPtr 
6219 84FF 22 C0 81 FC           jsl   StdFilterProc
6220 8503 68                    pla   
6221 8504 F0 04                 beq   DispEvent
6222 8506
6223 8506 85 26                 sta   <result
6224 8508
6225 8508 80 2D                 bra   exit
6226 850A
6227 850A              ;
6228 850A              ; Dispatch Event
6229 850A              ;
6230 850A A0 00 00     DispEvent ldy   #what
6231 850D B7 22                 lda   [<theEvent],y
6232 850F 0A                    asl   a
6233 8510 AA                    tax   
6234 8511 BF 17 85 FC           lda   >EventTable,x
6235 8515 48                    pha   
6236 8516 60                    rts   
6237 8517
6238 8517              EventTable  
6239 8517 36 85                 DC W:exit-1                    ; inNull
6240 8519 5F 85                 DC W:MouseDownEvent-1          ; inButtDwn
6241 851B 36 85                 DC W:exit-1                    ; inButtUp
6242 851D 87 86                 DC W:KeyDownEvent-1            ; inKey
6243 851F 36 85                 DC W:exit-1
6244 8521 87 86                 DC W:KeyDownEvent-1            ; inAutoKey
6245 8523 42 87                 DC W:UpdateEvent-1             ; inUpdate
6246 8525 36 85                 DC W:exit-1
6247 8527 7A 87                 DC W:ActivateEvent-1           ; inActWind
6248 8529 36 85                 DC W:exit-1                    ; inSwitch
6249 852B 36 85                 DC W:exit-1                    ; inAccess
6250 852D 36 85                 DC W:exit-1                    ; inDevice
6251 852F 36 85                 DC W:exit-1                    ; inApp1
6252 8531 36 85                 DC W:exit-1                    ; inApp2
6253 8533 36 85                 DC W:exit-1                    ; inApp3
6254 8535 36 85                 DC W:exit-1                    ; inApp4
6255 8537
6256 8537 A5 12 48 A5  exit     pushlong PortSave 
6257 853D A2 04 1B 22           _SetPort 
6258 8544
6259 8544 A9 00 00              lda   #0
6260 8547 2B A8 A3 19           tunlink 
6261 855F 6B                    rtl   
6262 8560
6263 8560              ;____________________________________________________________________________
6264 8560              ;
6265 8560              ;        MouseDownEvent
6266 8560              ;_____________________________________________________________________________
6267 8560
6268 8560              MouseDownEvent  
6269 8560
6270 8560              ;
6271 8560              ; If front window is not a modeless dialog, exit
6272 8560              ;
6273 8560 A5 04                 lda   <FrontModeless
6274 8562 F0 D3                 beq   exit
6275 8564
6276 8564              ;
6277 8564              ; Find window where the mouse-down occurred and where in the window
6278 8564              ;
6279 8564 48                    pha                            ; space for location
6280 8565 A5 20 48 A5           pushlong theDialogPtr 
6281 856B A0 0C 00 B7           pushlong [<theEvent],where 
6282 8577 A2 0E 17 22           _FindWindow 
6283 857E 68                    pla   
6284 857F 29 FF 7F              and   #$7FFF                   ; get rid of InSysWindow bit
6285 8582 AA                    tax                            ; location in X
6286 8583
6287 8583              ;
6288 8583              ; If not in front dialog, exit
6289 8583              ;
6290 8583 A7 1E                 lda   [<theDialogPtr]
6291 8585 C5 00                 cmp   <Dialog
6292 8587 D0 AE                 bne   exit
6293 8589 A0 02 00              ldy   #2
6294 858C B7 1E                 lda   [<theDialogPtr],y
6295 858E C5 02                 cmp   <Dialog+2
6296 8590 D0 A5                 bne   exit
6297 8592
6298 8592              ;
6299 8592              ; If not in the content region, no item hit -> exit
6300 8592              ;
6301 8592 E0 13 00              cpx   #winContent
6302 8595 F0 03                 beq   FindWhere
6303 8597 82 9D FF              brl   exit
6304 859A
6305 859A              ;
6306 859A              ; Find which item has been clicked in
6307 859A              ;
6308 859A              FindWhere                               ; 
6309 859A 48                    pha                            ; space for partcode
6310 859B F4 00 00 7B           pushzptr Control 
6311 85A4 A0 0C 00 B7           pushlong [<theEvent],where 
6312 85B0 A5 02 48 A5           pushlong Dialog 
6313 85B6 A2 10 13 22           _FindControl 
6314 85BD 68 85 0E              pullword <PartCode             ; if partcode=0, no item hit
6315 85C0 D0 03                 bne   CheckID
6316 85C2 82 72 FF              brl   exit
6317 85C5
6318 85C5              ;
6319 85C5              ; If ID is 0, does not handle item (non item controls)
6320 85C5              ;
6321 85C5              CheckID   
6322 85C5 A7 06 85 0A           movelong [<Control],0,<ControlPtr 
6323 85D0 A0 20 00              ldy   #iitemid
6324 85D3 B7 0A                 lda   [<ControlPtr],y
6325 85D5 D0 03                 bne   CheckEditLine
6326 85D7 82 5D FF              brl   exit
6327 85DA
6328 85DA              ;
6329 85DA              ; If PartCode is in EditLine, call LEClick on the EditLine record
6330 85DA              ;
6331 85DA              CheckEditLine  
6332 85DA A5 0E                 lda   <PartCode
6333 85DC C9 0B 00              cmp   #inEditLine
6334 85DF D0 1C                 bne   CheckNoTrack
6335 85E1
6336 85E1 A5 24 48 A5           pushlong theEvent 
6337 85E7 A0 1E 00 B7           pushlong [<ControlPtr],CtrlData  ; hLE is in CtrlData field
6338 85F3 A2 14 0D 22           _LEClick 
6339 85FA
6340 85FA 82 FA 01              brl   EnableTest
6341 85FD
6342 85FD              ;
6343 85FD              ; If PartCode is inStatText, inUserItem, inLongStatText,
6344 85FD              ; or inIconItem, does not TrackControl
6345 85FD              ;
6346 85FD              CheckNoTrack  
6347 85FD A5 0E                 lda   <PartCode
6348 85FF C9 09 00              cmp   #inStatText
6349 8602 F0 14                 beq   NoTrack
6350 8604 C9 0C 00              cmp   #inUserItem
6351 8607 F0 0F                 beq   NoTrack
6352 8609 C9 0D 00              cmp   #inLongStatText
6353 860C F0 0A                 beq   NoTrack
6354 860E C9 0F 00              cmp   #inLongStatText2         ; DAN H. (added for LongStatText2)
6355 8611 F0 05                 beq   NoTrack                  ; DAN H.
6356 8613 C9 0E 00              cmp   #inIconItem
6357 8616 D0 03                 bne   CheckScroll
6358 8618
6359 8618 82 DC 01     NoTrack  brl   EnableTest
6360 861B
6361 861B              ;
6362 861B              ; If PartCode is in up/down arrow or page up/down or thumb, special track
6363 861B              ;
6364 861B              CheckScroll  
6365 861B A5 0E                 lda   <PartCode
6366 861D C9 05 00              cmp   #UP_PART
6367 8620 F0 3B                 beq   ScrollTrack
6368 8622 C9 06 00              cmp   #DOWN_PART
6369 8625 F0 36                 beq   ScrollTrack
6370 8627 C9 07 00              cmp   #UPP_PART
6371 862A F0 31                 beq   ScrollTrack
6372 862C C9 08 00              cmp   #DOWNP_PART
6373 862F F0 2C                 beq   ScrollTrack
6374 8631 C9 81 00              cmp   #THUMB_PART
6375 8634 F0 27                 beq   ScrollTrack
6376 8636
6377 8636              ;
6378 8636              ; Call TrackControl
6379 8636              ;
6380 8636              StdTrack                                ; 
6381 8636 48                    pha                            ; space for partcode
6382 8637 A0 0C 00 B7           pushlong [<theEvent],where 
6383 8643 A9 FF FF              lda   #-1                      ; use control action procedure
6384 8646 48                    pha   
6385 8647 48                    pha   
6386 8648 A5 08 48 A5           pushlong Control 
6387 864E A2 10 15 22           _TrackControl 
6388 8655 68 85 0E              pullword <PartCode             ; if PartCode=0, mouse released outside
6389 8658 F0 2B                 beq   MDnoitem                 ; of item, so no item hit.
6390 865A
6391 865A              ;
6392 865A              ; If an item has been hit, call EnableTest to see if should return or not.
6393 865A              ;
6394 865A 82 9A 01              brl   EnableTest
6395 865D
6396 865D              ;
6397 865D              ; Call a special action procedure for scroll bar items
6398 865D              ;
6399 865D
6400 865D              ScrollTrack                             ; 
6401 865D 48                    pha                            ; space for partcode
6402 865E A0 0C 00 B7           pushlong [<theEvent],where 
6403 866A F4 FC 00 F4           pushlong #scroll_action 
6404 8670 A5 08 48 A5           pushlong Control 
6405 8676 A2 10 15 22           _TrackControl 
6406 867D 68 85 0E              pullword <PartCode 
6407 8680 F0 03                 beq   MDnoitem
6408 8682
6409 8682 82 72 01              brl   EnableTest
6410 8685
6411 8685 82 AF FE     MDnoitem brl   exit
6412 8688
6413 8688
6414 8688              ;______________________________________________________________________________
6415 8688              ;
6416 8688              ;        KeyDownEvent
6417 8688              ;______________________________________________________________________________
6418 8688
6419 8688              KeyDownEvent  
6420 8688
6421 8688              ;
6422 8688              ; If front window is not a modeless dialog, exit
6423 8688              ;
6424 8688 A5 04                 lda   <FrontModeless
6425 868A D0 03                 bne   LookForEditLine
6426 868C 82 B1 00              brl   KDnoitem
6427 868F
6428 868F              ;
6429 868F              ; Check if there is an active editLine item
6430 868F              ;
6431 868F              LookForEditLine  
6432 868F A0 14 01              ldy   #edittextID-wport
6433 8692 B7 00                 lda   [<Dialog],y
6434 8694 D0 03                 bne   editok                   ; if current edit item ID = 0, no item
6435 8696 82 A7 00              brl   KDnoitem
6436 8699
6437 8699 AA           editok   tax   
6438 869A
6439 869A              ;
6440 869A              ; If there is one, get the control handle to it.
6441 869A              ;
6442 869A 48                    pha                            ; space for control
6443 869B 48                    pha   
6444 869C A5 02 48 A5           pushlong Dialog 
6445 86A2 DA                    phx   
6446 86A3 A2 15 1E 22           _GetControlDItem 
6447 86AA 68 85 06 68           pulllong <Control 
6448 86B0
6449 86B0              ;
6450 86B0              ; If the item has not been found, exit no item
6451 86B0              ;
6452 86B0 A5 06                 lda   <Control
6453 86B2 D0 07                 bne   CheckTab
6454 86B4 A5 08                 lda   <Control+2
6455 86B6 D0 03                 bne   CheckTab
6456 86B8 82 85 00              brl   KDnoitem
6457 86BB
6458 86BB              ;
6459 86BB              ; If the typed character is a tab character, change the active EditLine item
6460 86BB              ;
6461 86BB              CheckTab  
6462 86BB A0 02 00              ldy   #message
6463 86BE B7 22                 lda   [<theEvent],y            ; char in lo order byte (check doc.)
6464 86C0 29 FF 00              and   #$FF
6465 86C3 C9 09 00              cmp   #9                       ; TAB = ASCII 9
6466 86C6 D0 29                 bne   CheckAppleKey
6467 86C8
6468 86C8              ;
6469 86C8              ; Find next EditLine item in dialog
6470 86C8              ;
6471 86C8 48                    pha                            ; space for result
6472 86C9 A5 02 48 A5           pushlong Dialog 
6473 86CF A5 08 48 A5           pushlong Control 
6474 86D5 22 19 83 FC           jsl   FindNextEditLine
6475 86D9 FA                    plx   
6476 86DA
6477 86DA              ;
6478 86DA              ; Make it the new active EditLine item and select the line
6479 86DA              ;
6480 86DA A5 02 48 A5           pushlong Dialog 
6481 86E0 DA                    phx   
6482 86E1 F4 00 00              pushword #0 
6483 86E4 F4 FF 7F              pushword #32767 
6484 86E7 A2 15 21 22           _SelIText 
6485 86EE
6486 86EE 82 4F 00              brl   KDnoitem
6487 86F1
6488 86F1              ;
6489 86F1              ; If Apple Key is down, does not pass the character to LineEdit
6490 86F1              ;
6491 86F1              CheckAppleKey  
6492 86F1 A0 0E 00              ldy   #modif
6493 86F4 B7 22                 lda   [<theEvent],y
6494 86F6 29 00 01              and   #$0100                   ; Test AppleKey modifier bit
6495 86F9 F0 15                 beq   CallLineEdit
6496 86FB A0 02 00              ldy   #message
6497 86FE A7 22                 lda   [<theEvent]              ; char in lo order byte (check doc.)
6498 8700 29 7F 00              and   #$7F
6499 8703 C9 08 00              cmp   #8                       ; left arrow
6500 8706 F0 08                 beq   CallLineEdit
6501 8708 C9 15 00              cmp   #21                      ; right arrow
6502 870B F0 03                 beq   CallLineEdit
6503 870D 82 30 00              brl   KDnoitem
6504 8710
6505 8710              ;
6506 8710              ; Pass the typed character to Line Edit
6507 8710              ;
6508 8710              CallLineEdit  
6509 8710 A7 06 85 0A           movelong [<Control],0,<ControlPtr 
6510 871B
6511 871B A0 02 00              ldy   #message
6512 871E B7 22                 lda   [<theEvent],y            ; char in lo order byte (check doc.)
6513 8720 29 FF 00              and   #$FF
6514 8723 48                    pha   
6515 8724 A0 0E 00              ldy   #modif
6516 8727 B7 22                 lda   [<theEvent],y
6517 8729 48                    pha   
6518 872A A0 1E 00 B7           pushlong [<ControlPtr],CtrlData   ; LEHandle in CtrlData
6519 8736 A2 14 11 22           _LEKey 
6520 873D
6521 873D              ;
6522 873D              ; Call EnableTest to see if EditLine item is enabled or not.
6523 873D              ;
6524 873D 82 B7 00              brl   EnableTest
6525 8740
6526 8740
6527 8740 82 F4 FD     KDnoitem brl   exit
6528 8743
6529 8743              ;______________________________________________________________________________
6530 8743              ;
6531 8743              ;        UpdateEvent
6532 8743              ;______________________________________________________________________________
6533 8743
6534 8743              UpdateEvent  
6535 8743
6536 8743              ;
6537 8743              ; Get dialog port
6538 8743              ;
6539 8743 20 E4 87              jsr   getdlgport
6540 8746
6541 8746 A7 1E 85 00           movelong [<theDialogPtr],0,<Dialog 
6542 8751
6543 8751              ;
6544 8751              ; Redraws the dialog's content
6545 8751              ;
6546 8751 A5 02 48 A5           pushlong Dialog 
6547 8757 A2 0E 1E 22           _BeginUpdate 
6548 875E
6549 875E A5 02 48 A5           pushlong Dialog 
6550 8764 A2 15 16 22           _DrawDialog 
6551 876B
6552 876B A5 02 48 A5           pushlong Dialog 
6553 8771 A2 0E 1F 22           _EndUpdate 
6554 8778
6555 8778 82 BC FD              brl   exit
6556 877B
6557 877B              ;______________________________________________________________________________
6558 877B              ;
6559 877B              ;        ActivateEvent
6560 877B              ;______________________________________________________________________________
6561 877B
6562 877B              ActivateEvent  
6563 877B
6564 877B              ;
6565 877B              ; Get dialog port
6566 877B              ;
6567 877B 20 E4 87              jsr   getdlgport
6568 877E
6569 877E A7 1E 85 00           movelong [<theDialogPtr],0,<Dialog 
6570 8789
6571 8789              ;
6572 8789              ; Look if there is any EditLine item
6573 8789              ;
6574 8789 A0 14 01              ldy   #edittextID-wport
6575 878C B7 00                 lda   [<Dialog],y
6576 878E D0 03                 bne   ACeditok                 ; if current edit item ID = 0, no item
6577 8790 82 A4 FD              brl   exit
6578 8793
6579 8793              ACeditok  
6580 8793 AA                    tax   
6581 8794
6582 8794              ;
6583 8794              ; If there is one, get the control handle to it.
6584 8794              ;
6585 8794 48                    pha                            ; space for control
6586 8795 48                    pha   
6587 8796 A5 02 48 A5           pushlong Dialog 
6588 879C DA                    phx   
6589 879D A2 15 1E 22           _GetControlDItem 
6590 87A4 B0 3A                 bcs   ActNotFound
6591 87A6 68 85 06 68           pulllong <Control 
6592 87AC
6593 87AC A7 06 85 0A           movelong [<Control],0,<ControlPtr 
6594 87B7
6595 87B7 A0 1E 00 B7           pushlong [<ControlPtr],CtrlData 
6596 87C3
6597 87C3              ;
6598 87C3              ; If dialog is now active, activate EditLine item, otherwise deactivate it
6599 87C3              ;
6600 87C3 A0 0E 00              ldy   #modif
6601 87C6 B7 22                 lda   [<theEvent],y
6602 87C8 29 01 00              and   #$0001                   ; get active flag
6603 87CB D0 09                 bne   ActivateIt
6604 87CD
6605 87CD A2 14 10 22           _LEDeactivate 
6606 87D4
6607 87D4 80 07                 bra   Actexit
6608 87D6
6609 87D6 A2 14 0F 22  ActivateIt _LEActivate 
6610 87DD
6611 87DD 82 57 FD     Actexit  brl   exit
6612 87E0
6613 87E0              ;
6614 87E0              ; Goes here if could not find current EditLine item
6615 87E0              ;
6616 87E0              ActNotFound  
6617 87E0 FA                    plx   
6618 87E1 FA                    plx   
6619 87E2 80 F9                 bra   Actexit
6620 87E4
6621 87E4
6622 87E4              ;++++++++++++++++++++++++++++++++++++++++++++++++++++
6623 87E4              ;
6624 87E4              ;        Get the dialog port from the Event Record
6625 87E4              ;
6626 87E4              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++
6627 87E4
6628 87E4              getdlgport  
6629 87E4 FA                    plx                            ; get rts
6630 87E5 A0 02 00              ldy   #message
6631 87E8 B7 22                 lda   [<theEvent],y
6632 87EA 87 1E                 sta   [<theDialogPtr]
6633 87EC C8                    iny   
6634 87ED C8                    iny   
6635 87EE B7 22                 lda   [<theEvent],y
6636 87F0 A0 02 00              ldy   #2
6637 87F3 97 1E                 sta   [<theDialogPtr],y
6638 87F5 DA                    phx                            ; set rts
6639 87F6 60                    rts   
6640 87F7
6641 87F7
6642 87F7              ;______________________________________________________________________________
6643 87F7              ;
6644 87F7              ;        EnableTest
6645 87F7              ;
6646 87F7              ;       input: control handle to item hit is in the local "Control".
6647 87F7              ;
6648 87F7              ;      function: go there if an item hit. Returns itemHit if item enabled.
6649 87F7              ;                Returns 0 if item disabled.
6650 87F7              ;______________________________________________________________________________
6651 87F7
6652 87F7              EnableTest  
6653 87F7
6654 87F7              ;
6655 87F7              ; If item hit, look if item is enabled or not
6656 87F7              ;
6657 87F7 A7 06 85 0A           movelong [<Control],0,<ControlPtr 
6658 8802 A0 22 00              ldy   #iitemtype
6659 8805 B7 0A                 lda   [<ControlPtr],y
6660 8807 29 00 80              and   #ItemDisable             ; if itemdisable, does not return
6661 880A D0 0C                 bne   ETnoitem
6662 880C
6663 880C              ;
6664 880C              ; If item enabled, returns item ID
6665 880C              ;
6666 880C A0 20 00              ldy   #iitemid
6667 880F B7 0A                 lda   [<ControlPtr],y
6668 8811 87 1A                 sta   [<itemHitPtr]
6669 8813 A9 01 00              lda   #1
6670 8816 85 26                 sta   <result
6671 8818
6672 8818 82 1C FD     ETnoitem brl   exit
6673 881B
6674 881B                       ENDP 
6675 881B
6676 881B              ;            copy  DDraw.asm
6677 881B              ; DDraw.asm                             Jean-Charles Mourey
6678 881B
6679 881B                       TITLE 'DrawDialog Routine'
6680 881B
6681 881B              ;_____________________________________________________________________________
6682 881B              ;
6683 881B              ;        DrawDialog
6684 881B              ;
6685 881B              ;       input: theDialog:LONG - pointer to the dialog.
6686 881B              ;
6687 881B              ;      output: none.
6688 881B              ;
6689 881B              ;    function: draws the contents of the given dialog box.
6690 881B              ;______________________________________________________________________________
6691 881B
6692 881B                       ENTRY DrawDialog
6693 881B              DrawDialog PROC 
6694 881B
6695 881B 3B 38 E9 00           tlink 4 
6696 8824
6697 8824              ;
6698 8824              ; Since all the items in a dialog are controls (standard or custom),
6699 8824              ; just call DrawControls for all controls in the dialog.
6700 8824              ;
6701 8824 A5 08 48 A5           pushlong input 
6702 882A A2 10 10 22           _DrawControls                  ; return DrawControls Error Status
6703 8831
6704 8831 A2 00 00              ldx   #0
6705 8834 4C 75 89              jmp   quit4
6706 8837
6707 8837                       ENDP 
6708 8837
6709 8837
6710 8837              ;____________________________________________________________________________
6711 8837              ;
6712 8837              ;        UpdateDialog
6713 8837              ;
6714 8837              ;       input: theDialog:LONG - pointer to the dialog port
6715 8837              ;              UpdateRgn:LONG - handle to region of dialog to update
6716 8837              ;
6717 8837              ;      output: none
6718 8837              ;_____________________________________________________________________________
6719 8837
6720 8837                       ENTRY UpdateDialog
6721 8837              UpdateDialog PROC 
6722 8837
6723 8837              PortSave equ   0
6724 8837              ClipSave equ   PortSave+4
6725 8837              SizeLocals equ   ClipSave+4
6726 8837
6727 8837 3B 38 E9 08           tlink 8,SizeLocals 
6728 8840
6729 8840              UpdateRgn equ   input
6730 8840              theDialog equ   UpdateRgn+4
6731 8840
6732 8840 48                    pha                            ; save previous port
6733 8841 48                    pha                            ; (space for port pointer)
6734 8842 A2 04 1C 22           _GetPort 
6735 8849 68 85 00 68           pulllong <PortSave 
6736 884F
6737 884F A5 14 48 A5           pushlong theDialog             ; set port = dialog port
6738 8855 A2 04 1B 22           _SetPort 
6739 885C
6740 885C 48                    pha                            ; save previous clip region
6741 885D 48                    pha                            ; (space for clip region)
6742 885E A2 04 67 22           _NewRgn 
6743 8865 68 85 04 68           pulllong <ClipSave 
6744 886B
6745 886B A5 06 48 A5           pushlong ClipSave 
6746 8871 A2 04 25 22           _GetClip 
6747 8878
6748 8878 A5 10 48 A5           pushlong UpdateRgn             ; set clip region = update region
6749 887E A2 04 24 22           _SetClip 
6750 8885
6751 8885 A5 14 48 A5           pushlong theDialog             ; draw dialog
6752 888B A2 15 16 22           _DrawDialog 
6753 8892
6754 8892 90 03                 bcc   noerror
6755 8894
6756 8894 48                    pha                            ; save DrawDialog Error Status
6757 8895 80 04                 bra   RestoreEverything
6758 8897
6759 8897              noerror                                 ;	        ; if no error, error status = 0
6760 8897 A9 00 00              lda   #0
6761 889A 48                    pha   
6762 889B
6763 889B              RestoreEverything                       ; 
6764 889B A5 06 48 A5           pushlong ClipSave              ; restore previous clip region
6765 88A1 A2 04 24 22           _SetClip 
6766 88A8
6767 88A8 A5 06 48 A5           pushlong ClipSave              ; dispose of save region
6768 88AE A2 04 68 22           _DisposeRgn 
6769 88B5
6770 88B5 A5 02 48 A5           pushlong PortSave              ; restore previous port
6771 88BB A2 04 1B 22           _SetPort 
6772 88C2
6773 88C2 68                    pla                            ; restore DrawDialog Error Status
6774 88C3
6775 88C3 A2 08 00              ldx   #SizeLocals
6776 88C6 4C A2 89              jmp   quit8                    ; fixedby SEG on 19 Dec 86
6777 88C9
6778 88C9                       ENDP 
6779 88C9
6780 88C9
6781 88C9              ;            copy  DData.asm
6782 88C9              ; DData.asm                             Jean-Charles Mourey
6783 88C9
6784 88C9                       TITLE 'Dialog Manager Datas'
6785 88C9
6786 88C9
6787 88C9              ;            copy  DScrap.asm
6788 88C9              ; DScrap.asm                            Jean-Charles Mourey
6789 88C9
6790 88C9                       TITLE 'Cut/Copy/Paste Dialog Procedures'
6791 88C9
6792 88C9              ;____________________________________________________________________________
6793 88C9              ;
6794 88C9              ;        DlgCut
6795 88C9              ;
6796 88C9              ;       input: theDialog:LONG - pointer to the dialog port.
6797 88C9              ;
6798 88C9              ;      output: none.
6799 88C9              ;
6800 88C9              ;    function: if there is a current edittext item, apply the cut operation
6801 88C9              ;              to it.
6802 88C9              ;____________________________________________________________________________
6803 88C9
6804 88C9                       ENTRY DlgCut
6805 88C9              DlgCut   PROC 
6806 88C9
6807 88C9 A2 00 00              ldx   #cutcmd
6808 88CC 80 0D                 bra   DlgScrap
6809 88CE
6810 88CE                       ENDP 
6811 88CE
6812 88CE              ;____________________________________________________________________________
6813 88CE              ;
6814 88CE              ;        DlgCopy
6815 88CE              ;
6816 88CE              ;       input: theDialog:LONG - pointer to the dialog port.
6817 88CE              ;
6818 88CE              ;      output: none.
6819 88CE              ;
6820 88CE              ;    function: if there is a current edittext item, apply the copy operation
6821 88CE              ;              to it.
6822 88CE              ;____________________________________________________________________________
6823 88CE
6824 88CE                       ENTRY DlgCopy
6825 88CE              DlgCopy  PROC 
6826 88CE
6827 88CE A2 01 00              ldx   #copycmd
6828 88D1 80 08                 bra   DlgScrap
6829 88D3
6830 88D3                       ENDP 
6831 88D3
6832 88D3              ;____________________________________________________________________________
6833 88D3              ;
6834 88D3              ;        DlgPaste
6835 88D3              ;
6836 88D3              ;       input: theDialog:LONG - pointer to the dialog port.
6837 88D3              ;
6838 88D3              ;      output: none.
6839 88D3              ;
6840 88D3              ;    function: if there is a current edittext item, apply the paste operation
6841 88D3              ;              to it.
6842 88D3              ;____________________________________________________________________________
6843 88D3
6844 88D3                       ENTRY DlgPaste
6845 88D3              DlgPaste PROC 
6846 88D3
6847 88D3 A2 02 00              ldx   #pastecmd
6848 88D6 80 03                 bra   DlgScrap
6849 88D8
6850 88D8                       ENDP 
6851 88D8
6852 88D8              ;____________________________________________________________________________
6853 88D8              ;
6854 88D8              ;        DlgDelete
6855 88D8              ;
6856 88D8              ;       input: theDialog:LONG - pointer to the dialog port.
6857 88D8              ;
6858 88D8              ;      output: none.
6859 88D8              ;
6860 88D8              ;    function: if there is a current edittext item, apply the delete operation
6861 88D8              ;              to it.
6862 88D8              ;____________________________________________________________________________
6863 88D8
6864 88D8                       ENTRY DlgDelete
6865 88D8              DlgDelete PROC 
6866 88D8
6867 88D8 A2 03 00              ldx   #deletecmd
6868 88DB
6869 88DB                       ENDP 
6870 88DB
6871 88DB
6872 88DB              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
6873 88DB              ;
6874 88DB              ;        DlgScrap
6875 88DB              ;
6876 88DB              ;       input: theDialog:LONG - pointer to the dialog port.
6877 88DB              ;              Y register = scrap command (cut,copy,paste or delete)
6878 88DB              ;
6879 88DB              ;      output: none.
6880 88DB              ;
6881 88DB              ;    function: if there is a current edittext item, apply the scap operation
6882 88DB              ;              to it.
6883 88DB              ;
6884 88DB              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
6885 88DB
6886 88DB                       ENTRY DlgScrap
6887 88DB              DlgScrap PROC 
6888 88DB
6889 88DB              Control  equ   0
6890 88DB              ControlPtr equ   Control+4
6891 88DB              SizeLocals equ   ControlPtr+4
6892 88DB
6893 88DB 3B 38 E9 08           tlink 4,SizeLocals 
6894 88E4
6895 88E4              theDialog equ   input
6896 88E4
6897 88E4 DA                    phx                            ; save scrap command
6898 88E5
6899 88E5 A0 14 01              ldy   #edittextID-wport
6900 88E8 B7 0E                 lda   [<theDialog],y
6901 88EA D0 06                 bne   GetIt
6902 88EC
6903 88EC FA                    plx                            ; pull scrap command
6904 88ED
6905 88ED A9 0C 15              lda   #DLGERR+ItemNotFound     ; if no current EditLine item, error
6906 88F0 80 3C                 bra   exit
6907 88F2
6908 88F2 AA           GetIt    tax   
6909 88F3
6910 88F3              ;
6911 88F3              ; Get handle to current edit text's control
6912 88F3              ;
6913 88F3 48                    pha                            ; space for control
6914 88F4 48                    pha   
6915 88F5 A5 10 48 A5           pushlong theDialog 
6916 88FB DA                    phx   
6917 88FC A2 15 1E 22           _GetControlDItem 
6918 8903 B0 2F                 bcs   notFound
6919 8905 68 85 00 68           pulllong <Control 
6920 890B
6921 890B A7 00 85 04           movelong [<Control],0,<ControlPtr 
6922 8916
6923 8916 FA                    plx                            ; get scrap command
6924 8917
6925 8917 A0 1E 00 B7           pushlong [<ControlPtr],CtrlData   ; CtrlData = hLE
6926 8923
6927 8923              ;================================================================
6928 8923              ;
6929 8923              ;  Here, I compute directly the call number with scrapcmd,
6930 8923              ;  assuming the call numbers for LECut, LECopy, LEPaste and
6931 8923              ;  LEDelete won't change.
6932 8923              ;
6933 8923              ;        LECut    = 20+256*18
6934 8923              ;        LECopy   = 20+256*19
6935 8923              ;        LEPaste  = 20+256*20
6936 8923              ;        LEDelete = 20+256*21
6937 8923              ;
6938 8923              ;================================================================
6939 8923
6940 8923 8A                    txa                            ; add base number to scrap command
6941 8924 18                    clc   
6942 8925 69 12 14              adc   #18+20*256               ; (Acc should be switched lo-hi)
6943 8928 EB                    xba                            ; and switch it
6944 8929 AA                    tax   
6945 892A 22 00 00 E1           jsl   $E10000                  ; return LineEdit Error Status
6946 892E
6947 892E A2 08 00     exit     ldx   #SizeLocals
6948 8931 4C 75 89              jmp   quit4
6949 8934
6950 8934              notFound                                ; 
6951 8934 FA                    plx                            ; pull useless control
6952 8935 FA                    plx   
6953 8936 FA                    plx                            ; pull scrap command
6954 8937 80 F5                 bra   exit
6955 8939
6956 8939                       ENDP 
6957 8939
6958 8939              ;            copy  DUtils.asm
6959 8939              ; DUtils.asm                            Jean-Charles Mourey
6960 8939
6961 8939                       TITLE 'Dialog Manager Internal Utilities'
6962 8939
6963 8939              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
6964 8939              ;
6965 8939              ;        dlg2handle
6966 8939              ;
6967 8939              ;       input: theDialog:LONG in AY - pointer to the dialog port.
6968 8939              ;
6969 8939              ;      output: DialogHandle:LONG in AY - handle to the dialog record.
6970 8939              ;
6971 8939              ;    function: given a pointer to the dialog port, retrieves the
6972 8939              ;              handle to the dialog record.
6973 8939              ;
6974 8939              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
6975 8939
6976 8939                       ENTRY dlg2handle
6977 8939              dlg2handle PROC 
6978 8939
6979 8939              ;
6980 8939              ; Find beginning of dialog record
6981 8939              ;
6982 8939 38                    sec   
6983 893A E9 04 00              sbc   #wport
6984 893D B0 01                 bcs   findit
6985 893F 88                    dey   
6986 8940
6987 8940 F4 00 00 F4  findit   pushlong #0 
6988 8946 5A 48                 pushay                         ; Location of Handle
6989 8948 A2 02 1A 22           _FindHandle 
6990 894F 68 7A                 pullay 
6991 8951 60                    rts   
6992 8952
6993 8952                       ENDP 
6994 8952
6995 8952
6996 8952              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
6997 8952              ;
6998 8952              ;        long_call
6999 8952              ;
7000 8952              ;       input: X = bits 8-23 of address of destination routine
7001 8952              ;              A = bits 0-15 of address of destination routine
7002 8952              ;                  (only bits 0-8 are used)
7003 8952              ;
7004 8952              ;      output: calling this routine is the same as:
7005 8952              ;
7006 8952              ;                 jsl (ax)
7007 8952              ;
7008 8952              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7009 8952
7010 8952                       ENTRY long_call
7011 8952              long_call PROC 
7012 8952                                                      ; HY 8/4/88, old code decremented data bank
7013 8952 DA                    phx                            ; push middle+high byte of address
7014 8953 8B                    phb                            ; push extra byte on stack
7015 8954
7016 8954 3A                    dec   a                        ; decrement a so low word looks like a 
7017 8955                                                      ; return address
7018 8955 83 01                 sta   1,s                      ; overstore low word
7019 8957
7020 8957 6B                    rtl                            ; go to routine
7021 8958
7022 8958                       ENDP 
7023 8958
7024 8958
7025 8958              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7026 8958              ;
7027 8958              ;        quit0
7028 8958              ;
7029 8958              ;       input: A=error code
7030 8958              ;
7031 8958              ;      output: none
7032 8958              ;
7033 8958              ;    function: exit from a procedure with no input and adjust carry
7034 8958              ;
7035 8958              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7036 8958
7037 8958                       ENTRY quit0
7038 8958              quit0    PROC 
7039 8958              ;
7040 8958              ; Stack is: output, rtl1, rtl2, local space, previous D register
7041 8958              ;
7042 8958 20 E8 89              jsr   disposelocals
7043 895B
7044 895B              ;
7045 895B              ; Stack is: output, rtl1, rtl2
7046 895B              ;
7047 895B 98                    tya                            ; adjust carry
7048 895C C9 01 00              cmp   #1
7049 895F 6B                    rtl                            ; quit procedure
7050 8960                       ENDP 
7051 8960
7052 8960
7053 8960
7054 8960
7055 8960              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7056 8960              ;
7057 8960              ;        quit2
7058 8960              ;
7059 8960              ;       input: A=error code
7060 8960              ;
7061 8960              ;      output: none
7062 8960              ;
7063 8960              ;    function: exit from a procedure with 2 bytes of input and adjust carry
7064 8960              ;
7065 8960              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7066 8960
7067 8960                       ENTRY quit2
7068 8960              quit2    PROC Export 
7069 8960              ;
7070 8960              ; Stack is: output, input, rtl1, rtl2, local space, previous D register
7071 8960              ;
7072 8960 20 E8 89              jsr   disposelocals
7073 8963
7074 8963              ;
7075 8963              ; Stack is: output, input, rtl1, rtl2
7076 8963              ;
7077 8963
7078 8963              ;
7079 8963              ; Remove input parameters
7080 8963              ;
7081 8963 A3 05                 lda   5,s
7082 8965 83 07                 sta   7,s
7083 8967 A3 03                 lda   3,s
7084 8969 83 05                 sta   5,s
7085 896B A3 01                 lda   1,s
7086 896D 83 03                 sta   3,s
7087 896F 68                    pla                            ; add 2 to stack pointer
7088 8970
7089 8970 98                    tya                            ; adjust carry
7090 8971 C9 01 00              cmp   #1
7091 8974 6B                    rtl                            ; quit procedure
7092 8975                       ENDP 
7093 8975
7094 8975
7095 8975              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7096 8975              ;
7097 8975              ;        quit4
7098 8975              ;
7099 8975              ;       input: A=error code
7100 8975              ;
7101 8975              ;      output: none
7102 8975              ;
7103 8975              ;    function: exit from a procedure with 4 bytes of input and adjust carry
7104 8975              ;
7105 8975              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7106 8975
7107 8975                       ENTRY quit4
7108 8975              quit4    PROC 
7109 8975 20 E8 89              jsr   disposelocals
7110 8978
7111 8978              ;
7112 8978              ; Remove input parameters
7113 8978              ;
7114 8978 A3 05                 lda   5,s
7115 897A 83 09                 sta   9,s
7116 897C A3 03                 lda   3,s
7117 897E 83 07                 sta   7,s
7118 8980 A3 01                 lda   1,s
7119 8982 83 05                 sta   5,s
7120 8984 68                    pla                            ; add 4 to stack pointer
7121 8985 68                    pla   
7122 8986
7123 8986 98                    tya                            ; adjust carry
7124 8987 C9 01 00              cmp   #1
7125 898A 6B                    rtl                            ; quit procedure
7126 898B                       ENDP 
7127 898B
7128 898B
7129 898B              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7130 898B              ;
7131 898B              ;        quit6
7132 898B              ;
7133 898B              ;       input: A=error code
7134 898B              ;
7135 898B              ;      output: none
7136 898B              ;
7137 898B              ;    function: exit from a procedure with 6 bytes of input and adjust carry
7138 898B              ;
7139 898B              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7140 898B
7141 898B                       ENTRY quit6
7142 898B              quit6    PROC 
7143 898B 20 E8 89              jsr   disposelocals
7144 898E
7145 898E              ;
7146 898E              ; Remove input parameters
7147 898E              ;
7148 898E A3 05                 lda   5,s
7149 8990 83 0B                 sta   11,s
7150 8992 A3 03                 lda   3,s
7151 8994 83 09                 sta   9,s
7152 8996 A3 01                 lda   1,s
7153 8998 83 07                 sta   7,s
7154 899A 68                    pla                            ; add 6 to stack pointer
7155 899B 68                    pla   
7156 899C 68                    pla   
7157 899D
7158 899D 98                    tya                            ; adjust carry
7159 899E C9 01 00              cmp   #1
7160 89A1 6B                    rtl                            ; quit procedure
7161 89A2                       ENDP 
7162 89A2
7163 89A2
7164 89A2              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7165 89A2              ;
7166 89A2              ;        quit8
7167 89A2              ;
7168 89A2              ;       input: A=error code
7169 89A2              ;
7170 89A2              ;      output: none
7171 89A2              ;
7172 89A2              ;    function: exit from a procedure with 8 bytes of input and adjust carry
7173 89A2              ;
7174 89A2              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7175 89A2
7176 89A2                       ENTRY quit8
7177 89A2              quit8    PROC 
7178 89A2 20 E8 89              jsr   disposelocals
7179 89A5
7180 89A5              ;
7181 89A5              ; Remove input parameters
7182 89A5              ;
7183 89A5 A3 05                 lda   5,s
7184 89A7 83 0D                 sta   13,s
7185 89A9 A3 03                 lda   3,s
7186 89AB 83 0B                 sta   11,s
7187 89AD A3 01                 lda   1,s
7188 89AF 83 09                 sta   9,s
7189 89B1 68                    pla                            ; add 8 to stack pointer
7190 89B2 68                    pla   
7191 89B3 68                    pla   
7192 89B4 68                    pla   
7193 89B5
7194 89B5 98                    tya                            ; adjust carry
7195 89B6 C9 01 00              cmp   #1
7196 89B9 6B                    rtl                            ; quit procedure
7197 89BA                       ENDP 
7198 89BA
7199 89BA
7200 89BA              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7201 89BA              ;
7202 89BA              ;        quit10
7203 89BA              ;
7204 89BA              ;       input: A=error code
7205 89BA              ;
7206 89BA              ;      output: none
7207 89BA              ;
7208 89BA              ;    function: exit from a procedure with 10 bytes of input and adjust carry
7209 89BA              ;
7210 89BA              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7211 89BA
7212 89BA                       ENTRY quit10
7213 89BA              quit10   PROC 
7214 89BA 20 E8 89              jsr   disposelocals
7215 89BD
7216 89BD              ;
7217 89BD              ; Remove input parameters
7218 89BD              ;
7219 89BD A3 05                 lda   5,s
7220 89BF 83 0F                 sta   15,s
7221 89C1 A3 03                 lda   3,s
7222 89C3 83 0D                 sta   13,s
7223 89C5 A3 01                 lda   1,s
7224 89C7 83 0B                 sta   11,s
7225 89C9 68                    pla                            ; add 10 to stack pointer
7226 89CA 68                    pla   
7227 89CB 68                    pla   
7228 89CC 68                    pla   
7229 89CD 68                    pla   
7230 89CE
7231 89CE 98                    tya                            ; adjust carry
7232 89CF C9 01 00              cmp   #1
7233 89D2 6B                    rtl                            ; quit procedure
7234 89D3                       ENDP 
7235 89D3
7236 89D3
7237 89D3              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7238 89D3              ;
7239 89D3              ;        quitdefproc
7240 89D3              ;
7241 89D3              ;       input: A=error code
7242 89D3              ;
7243 89D3              ;      output: none
7244 89D3              ;
7245 89D3              ;    function: exit from a defproc with 10 bytes of input and adjust carry
7246 89D3              ;
7247 89D3              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7248 89D3
7249 89D3                       ENTRY quitdefproc
7250 89D3              quitdefproc PROC 
7251 89D3 20 E8 89              jsr   disposelocals
7252 89D6
7253 89D6              ;
7254 89D6              ; Remove input parameters
7255 89D6              ;
7256 89D6 A3 02                 lda   2,s
7257 89D8 83 0C                 sta   12,s
7258 89DA A3 01                 lda   1,s
7259 89DC 83 0B                 sta   11,s
7260 89DE 68                    pla                            ; add 10 to stack pointer
7261 89DF 68                    pla   
7262 89E0 68                    pla   
7263 89E1 68                    pla   
7264 89E2 68                    pla   
7265 89E3
7266 89E3 98                    tya                            ; adjust carry
7267 89E4 C9 01 00              cmp   #1
7268 89E7 6B                    rtl                            ; quit procedure
7269 89E8                       ENDP 
7270 89E8
7271 89E8
7272 89E8              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7273 89E8              ;
7274 89E8              ;        disposelocals
7275 89E8              ;
7276 89E8              ;       input: X=size of local space
7277 89E8              ;
7278 89E8              ;      output: none
7279 89E8              ;
7280 89E8              ;    function: restore zero page, save error code, and remove local vars from
7281 89E8              ;              stack.
7282 89E8              ;
7283 89E8              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7284 89E8
7285 89E8                       ENTRY disposelocals
7286 89E8              disposelocals PROC 
7287 89E8 A8                    tay                            ; save error code
7288 89E9 68                    pla                            ; save return address
7289 89EA 2B                    pld                            ; restore zero page
7290 89EB
7291 89EB E0 00 00              cpx   #0
7292 89EE F0 07                 beq   exit
7293 89F0
7294 89F0              ;
7295 89F0              ; Remove local vars from stack
7296 89F0              ;
7297 89F0              nextbyte                                ; 
7298 89F0 83 01                 sta   1,s                      ; store return address on stack
7299 89F2 68                    pla                            ; decrement stack and get return address
7300 89F3 CA                    dex                            ; (that's a huge trick!)
7301 89F4 CA                    dex   
7302 89F5 D0 F9                 bne   nextbyte
7303 89F7
7304 89F7              exit                                    ; 
7305 89F7 48                    pha                            ; restore return address
7306 89F8 60                    rts   
7307 89F9                       ENDP 
7308 89F9
7309 89F9
7310 89F9              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7311 89F9              ;
7312 89F9              ;        storeLONGinZP
7313 89F9              ;
7314 89F9              ;       input: LongValue:LONG - value to store in the zero page
7315 89F9              ;              Y register = offset in zero page where to put the value
7316 89F9              ;              A-reg = value of WAP
7317 89F9              ;
7318 89F9              ;      output: none
7319 89F9              ;
7320 89F9              ;
7321 89F9              ; Change History
7322 89F9              ;
7323 89F9              ; 4 March 88        STEVEN Glass
7324 89F9              ;
7325 89F9              ; Uses the incoming WAP instead of calling the control manager for the 
7326 89F9              ; value of its direct page.
7327 89F9              ;
7328 89F9              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7329 89F9
7330 89F9                       ENTRY storeLONGinZP
7331 89F9              storeLONGinZP PROC 
7332 89F9
7333 89F9              Globals  equ   0
7334 89F9              SizeLocals equ   Globals+4
7335 89F9
7336 89F9
7337 89F9 AA                    tax                            ; save WAP 
7338 89FA 3B 38 E9 04           tlink 4,SizeLocals 
7339 8A03
7340 8A03 5A                    phy                            ; save zero page offset
7341 8A04
7342 8A04 86 00                 stx   <Globals
7343 8A06 64 02                 stz   <Globals+2
7344 8A08
7345 8A08 7A                    ply                            ; restore zero page offset
7346 8A09
7347 8A09              ;
7348 8A09              ; Store the LONG input parameter in the Zero Page at the specified position
7349 8A09              ;
7350 8A09 A5 0A                 lda   <input
7351 8A0B 97 00                 sta   [<Globals],y
7352 8A0D C8                    iny                            ; Added 28 Jan 87
7353 8A0E C8                    iny                            ; oops--forgot the second word of
7354 8A0F A5 0C                 lda   <input+2                 ; the long
7355 8A11 97 00                 sta   [<Globals],y
7356 8A13
7357 8A13 A9 00 00              lda   #0
7358 8A16 A2 04 00              ldx   #SizeLocals
7359 8A19 4C 75 89              jmp   quit4
7360 8A1C
7361 8A1C                       ENDP 
7362 8A1C
7363 8A1C
7364 8A1C              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7365 8A1C              ;
7366 8A1C              ;        getWORDfromZP
7367 8A1C              ;
7368 8A1C              ;       input: Y register = offset in zero page where is the value
7369 8A1C              ;
7370 8A1C              ;      output: WordValue:WORD - value read from zero page
7371 8A1C              ;
7372 8A1C              ; Change History
7373 8A1C              ;
7374 8A1C              ; 4 March 88        STEVEN Glass
7375 8A1C              ;
7376 8A1C              ; Uses the incoming WAP instead of calling the control manager for the 
7377 8A1C              ; value of its direct page.
7378 8A1C              ;
7379 8A1C              ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7380 8A1C
7381 8A1C                       ENTRY getWORDfromZP
7382 8A1C              getWORDfromZP PROC 
7383 8A1C
7384 8A1C              Globals  equ   0
7385 8A1C              SizeLocals equ   Globals+4
7386 8A1C
7387 8A1C AA                    tax                            ; save wap value
7388 8A1D 3B 38 E9 04           tlink 0,SizeLocals 
7389 8A26
7390 8A26 5A                    phy                            ; save zero page offset
7391 8A27
7392 8A27 86 00                 stx   <Globals
7393 8A29 64 02                 stz   <Globals+2
7394 8A2B
7395 8A2B 7A                    ply                            ; restore zero page offset
7396 8A2C
7397 8A2C              ;
7398 8A2C              ; Store the asked value in the output
7399 8A2C              ;
7400 8A2C B7 00                 lda   [<Globals],y
7401 8A2E 85 0A                 sta   <output
7402 8A30
7403 8A30 A9 00 00              lda   #0
7404 8A33 A2 04 00              ldx   #SizeLocals
7405 8A36 4C 58 89              jmp   quit0
7406 8A39
7407 8A39                       ENDP 
7408 8A39
7409 8A39
7410 8A39
7411 8A39                       TITLE 'StatText Items Definition Procedure'
7412 8A39
7413 8A39
7414 8A39              ;___________________________________________________________________________
7415 8A39              ;
7416 8A39              ;       StatTextDefProc
7417 8A39              ;
7418 8A39              ;       input: message:WORD - desired operation
7419 8A39              ;              param:LONG - depends on operation
7420 8A39              ;              theControl:LONG - handle to control
7421 8A39              ;
7422 8A39              ;      output: RetValue:LONG - depends on operation
7423 8A39              ;
7424 8A39              ; Change History
7425 8A39              ;
7426 8A39              ; 07 Oct 88         Steven Glass
7427 8A39              ;
7428 8A39              ; Only deref the control handle if the message is not recsize.
7429 8A39              ;____________________________________________________________________________
7430 8A39
7431 8A39                       ENTRY StatTextDefProc
7432 8A39              StatTextDefProc PROC 
7433 8A39
7434 8A39              ControlPtr equ   0
7435 8A39              Rect     equ   ControlPtr+4
7436 8A39              TextPtr  equ   Rect+8
7437 8A39              TextLen  equ   TextPtr+4
7438 8A39              SizeLocals equ   TextLen+2
7439 8A39
7440 8A39 EA                    nop   
7441 8A3A 3B 38 E9 12           link 10,SizeLocals 
7442 8A43
7443 8A43              theControl equ   input
7444 8A43              param    equ   theControl+4
7445 8A43              CtlMessage equ   param+4
7446 8A43
7447 8A43              RetValue equ   output
7448 8A43
7449 8A43              ;
7450 8A43              ; Zeroes out RetValue
7451 8A43              ;
7452 8A43 64 1F                 stz   <RetValue
7453 8A45 64 21                 stz   <RetValue+2
7454 8A47
7455 8A47 A5 1D                 lda   <ctlMessage
7456 8A49 C9 0C 00              cmp   #recsize
7457 8A4C F0 27                 beq   SkipThisStuff
7458 8A4E              ;
7459 8A4E              ; Get Pointer to control and copy display rectangle
7460 8A4E              ;
7461 8A4E A7 15 85 00           movelong [<theControl],0,<ControlPtr 
7462 8A59
7463 8A59 A0 08 00 B7           movelong [<ControlPtr],CtrlRect,<Rect 
7464 8A67 A0 0C 00 B7           movelong [<ControlPtr],CtrlRect+4,<Rect+4 
7465 8A75
7466 8A75
7467 8A75              SkipThisStuff  
7468 8A75 A5 1D                 lda   <CtlMessage
7469 8A77 0A                    asl   a
7470 8A78 AA                    tax   
7471 8A79 BF 7F 8A FC           lda   >CmdTable,x
7472 8A7D 48                    pha   
7473 8A7E 60                    rts   
7474 8A7F
7475 8A7F 9E 8A        CmdTable DC W:DrawStatText-1
7476 8A81 98 8A                 DC W:StatTextExit-1
7477 8A83 15 8B                 DC W:TestStatText-1
7478 8A85 98 8A                 DC W:StatTextExit-1
7479 8A87 98 8A                 DC W:StatTextExit-1
7480 8A89 98 8A                 DC W:StatTextExit-1
7481 8A8B 98 8A                 DC W:StatTextExit-1
7482 8A8D 98 8A                 DC W:StatTextExit-1
7483 8A8F 98 8A                 DC W:StatTextExit-1
7484 8A91 9E 8A                 DC W:DrawStatText-1            ; new value fall thru draw routine
7485 8A93 98 8A                 DC W:StatTextExit-1
7486 8A95 98 8A                 DC W:StatTextExit-1
7487 8A97 22 8B                 DC W:RecStatText-1
7488 8A99
7489 8A99              StatTextExit  
7490 8A99 A2 12 00              ldx   #SizeLocals
7491 8A9C 4C D3 89              jmp   quitdefproc
7492 8A9F
7493 8A9F
7494 8A9F              *******************
7495 8A9F              *
7496 8A9F              * Draw StatText
7497 8A9F              *
7498 8A9F              ******************
7499 8A9F
7500 8A9F              DrawStatText  
7501 8A9F
7502 8A9F              ;
7503 8A9F              ; Call TextBox to draw the static text
7504 8A9F              ;
7505 8A9F 20 6D 93              jsr   NormalTextColor
7506 8AA2              ;
7507 8AA2              ; Using TextPtr, creates a new string where the ^n are replaced by the ParamStr
7508 8AA2              ;
7509 8AA2 A0 1C 00 B7           movelong [<ControlPtr],CtrlData,<TextPtr 
7510 8AB0
7511 8AB0 A7 0C                 lda   [<TextPtr]               ; get text length
7512 8AB2 29 FF 00              and   #$FF
7513 8AB5 85 10                 sta   <TextLen
7514 8AB7
7515 8AB7              ;
7516 8AB7              ; If string is empty, exit
7517 8AB7              ;
7518 8AB7 F0 5A                 beq   exit
7519 8AB9
7520 8AB9
7521 8AB9 A5 0C 18 69           add4 <TextPtr,#1,<TextPtr      ; get pointer to beginning of text
7522 8AC8
7523 8AC8 48                    pha                            ; space for new text pointer
7524 8AC9 48                    pha   
7525 8ACA 48                    pha                            ; space for new text length
7526 8ACB A5 0E 48 A5           pushlong TextPtr 
7527 8AD1 A5 10 48              pushword TextLen 
7528 8AD4 22 30 8B FC           jsl   InsertParamString
7529 8AD8 68 85 10              pullword <TextLen              ; new text length
7530 8ADB 68 85 0C 68           pulllong <TextPtr              ; new text pointer (dereferenced hdl)
7531 8AE1
7532 8AE1 A5 0E 48 A5           pushlong TextPtr 
7533 8AE7 A5 10 48              pushword TextLen 
7534 8AEA
7535 8AEA F4 00 00 7B           pushzptr <Rect 
7536 8AF3
7537 8AF3 F4 00 00              pushword #0                    ; Left justification
7538 8AF6
7539 8AF6 A2 14 18 22           _LETextBox 
7540 8AFD
7541 8AFD              ;
7542 8AFD              ; Dispose of pointer (actually handle for the created string)
7543 8AFD              ;
7544 8AFD 48                    pha                            ; space for handle
7545 8AFE 48                    pha   
7546 8AFF A5 0E 48 A5           pushlong TextPtr 
7547 8B05 A2 02 1A 22           _FindHandle 
7548 8B0C A2 02 10 22           _DisposeHandle 
7549 8B13
7550 8B13 82 83 FF     exit     brl   StatTextExit
7551 8B16
7552 8B16
7553 8B16              *******************
7554 8B16              *
7555 8B16              * Test StatText
7556 8B16              *
7557 8B16              ******************
7558 8B16
7559 8B16              TestStatText  
7560 8B16
7561 8B16 A9 09 00 85           movelong #inStatText,<RetValue 
7562 8B20
7563 8B20 82 76 FF              brl   StatTextExit
7564 8B23
7565 8B23
7566 8B23              *******************
7567 8B23              *
7568 8B23              * RecSize StatText
7569 8B23              *
7570 8B23              ******************
7571 8B23
7572 8B23              RecStatText  
7573 8B23
7574 8B23              ;
7575 8B23              ; Returns StatTextSIZE
7576 8B23              ;
7577 8B23 A9 2E 00 85           movelong #StatTextSIZE,<RetValue 
7578 8B2D
7579 8B2D 82 69 FF              brl   StatTextExit
7580 8B30
7581 8B30                       ENDP 
7582 8B30
7583 8B30
7584 8B30              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7585 8B30              ;
7586 8B30              ;        InsertParamString
7587 8B30              ;
7588 8B30              ;       input: SourceText:LONG - pointer to text string
7589 8B30              ;              SourceLen:WORD - length of text string
7590 8B30              ;
7591 8B30              ;      output: DestText:LONG - pointer to text with the paramstrings
7592 8B30              ;              DestLen:WORD - length of dest string
7593 8B30              ;
7594 8B30              ;    function: replaces the ^0 to ^3 by the corresponding paramstrings (set by
7595 8B30              ;              ParamText).
7596 8B30              ;
7597 8B30              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
7598 8B30
7599 8B30                       ENTRY InsertParamString
7600 8B30              InsertParamString PROC 
7601 8B30
7602 8B30              Globals  equ   0
7603 8B30              StringHandle equ   Globals+4
7604 8B30              SourceOffset equ   StringHandle+4
7605 8B30              DestOffset equ   SourceOffset+2
7606 8B30              ParmText equ   DestOffset+2
7607 8B30              ParmLen  equ   ParmText+4
7608 8B30              DestLenBase equ   ParmLen+2
7609 8B30              SizeLocals equ   DestLenBase+2
7610 8B30
7611 8B30 3B 38 E9 14           link 6,SizeLocals 
7612 8B39
7613 8B39              SourceLen equ   input
7614 8B39              SourceText equ   SourceLen+2
7615 8B39
7616 8B39              DestLen  equ   output
7617 8B39              DestText equ   DestLen+2
7618 8B39
7619 8B39              ;
7620 8B39              ; Get Dialog Manager Zero Page
7621 8B39              ;
7622 8B39 48                    pha   
7623 8B3A A2 10 1F 22           _GetCtlDPage 
7624 8B41 68                    pla   
7625 8B42 85 00                 sta   <Globals
7626 8B44 64 02                 stz   <Globals+2
7627 8B46
7628 8B46              ;
7629 8B46              ; Create a handle for the new text
7630 8B46              ;
7631 8B46 48                    pha                            ; space for handle
7632 8B47 48                    pha   
7633 8B48 F4 00 00 F4           pushlong #520                  ; 520 characters (limit effects)
7634 8B4E A0 82 00              ldy   #mmgrID                  ; Memory Manager ID
7635 8B51 B7 00                 lda   [<Globals],y
7636 8B53 48                    pha   
7637 8B54 F4 10 00              pushword #Attr_NoCross 
7638 8B57 48                    pha                            ; no location
7639 8B58 48                    pha   
7640 8B59 A2 02 09 22           _NewHandle 
7641 8B60 90 03 82 1E           Check_Error NotAllocated 
7642 8B65
7643 8B65 A3 01                 lda   1,s                      ; get string handle without pulling it
7644 8B67 85 04                 sta   <StringHandle
7645 8B69 A3 03                 lda   3,s
7646 8B6B 85 06                 sta   <StringHandle+2
7647 8B6D
7648 8B6D A2 02 20 22           _HLock                         ; StringHandle is on stack
7649 8B74
7650 8B74 A7 04 85 1F           movelong [<StringHandle],0,<DestText 
7651 8B7F
7652 8B7F 64 08                 stz   <SourceOffset
7653 8B81 64 1D                 stz   <DestLen
7654 8B83 64 12                 stz   <DestLenBase
7655 8B85
7656 8B85              NextSourceChar  
7657 8B85 A4 08                 ldy   <SourceOffset
7658 8B87 B7 19                 lda   [<SourceText],y
7659 8B89 AA                    tax   
7660 8B8A 29 7F 00              and   #$7F
7661 8B8D C9 5E 00              cmp   #'^'
7662 8B90 F0 7A                 beq   CheckNeedParam
7663 8B92
7664 8B92 8A                    txa   
7665 8B93
7666 8B93              DirectCopyChar  
7667 8B93 A4 1D                 ldy   <DestLen
7668 8B95 97 1F                 sta   [<DestText],y
7669 8B97
7670 8B97 E6 08                 inc   <SourceOffset
7671 8B99
7672 8B99 A5 08                 lda   <SourceOffset
7673 8B9B C5 17                 cmp   <SourceLen
7674 8B9D 90 03                 blt   IncDestLen
7675 8B9F 82 CA 00              brl   CopyDestLength
7676 8BA2
7677 8BA2              IncDestLen  
7678 8BA2 E6 1D                 inc   <DestLen
7679 8BA4
7680 8BA4 A5 1D                 lda   <DestLen
7681 8BA6 38                    sec   
7682 8BA7 E5 12                 sbc   <DestLenBase
7683 8BA9 C9 00 01              cmp   #256
7684 8BAC 90 D7                 blt   NextSourceChar
7685 8BAE
7686 8BAE              ;
7687 8BAE              ; If more chars needed, expand string by 256 chars
7688 8BAE              ;
7689 8BAE A5 06 48 A5           pushlong StringHandle 
7690 8BB4 A2 02 22 22           _HUnlock 
7691 8BBB
7692 8BBB A9 00 00              lda   #0
7693 8BBE 48                    pha                            ; space for handle size
7694 8BBF 48                    pha   
7695 8BC0 A5 06 48 A5           pushlong StringHandle 
7696 8BC6 A2 02 18 22           _GetHandleSize 
7697 8BCD
7698 8BCD A3 01                 lda   1,s                      ; HdlSize is on stack
7699 8BCF 18                    clc                            ; Add 256 to it
7700 8BD0 69 00 01              adc   #256                     ; and re-store it on the stack
7701 8BD3 83 01                 sta   1,s
7702 8BD5
7703 8BD5 A3 03                 lda   3,s
7704 8BD7 69 00 00              adc   #0
7705 8BDA 83 03                 sta   3,s
7706 8BDC
7707 8BDC A5 06 48 A5           pushlong StringHandle 
7708 8BE2 A2 02 19 22           _SetHandleSize 
7709 8BE9
7710 8BE9 A5 06 48 A5           pushlong StringHandle 
7711 8BEF A2 02 20 22           _HLock 
7712 8BF6
7713 8BF6 A7 04 85 1F           movelong [<StringHandle],0,<DestText 
7714 8C01
7715 8C01 A5 12                 lda   <DestLenBase
7716 8C03 18                    clc   
7717 8C04 69 00 01              adc   #256
7718 8C07 85 12                 sta   <DestLenBase
7719 8C09
7720 8C09 82 79 FF              brl   NextSourceChar
7721 8C0C
7722 8C0C              CheckNeedParam  
7723 8C0C C8                    iny   
7724 8C0D C4 17                 cpy   <SourceLen
7725 8C0F F0 82                 beq   DirectCopyChar
7726 8C11 B7 19                 lda   [<SourceText],y
7727 8C13 29 7F 00              and   #$7F
7728 8C16 38                    sec   
7729 8C17 E9 30 00              sbc   #'0'
7730 8C1A 30 05                 bmi   NotParamString
7731 8C1C C9 04 00              cmp   #4
7732 8C1F 90 06                 blt   IsParamString
7733 8C21
7734 8C21              NotParamString  
7735 8C21 88                    dey   
7736 8C22 B7 19                 lda   [<SourceText],y
7737 8C24 82 6C FF              brl   DirectCopyChar
7738 8C27
7739 8C27              ;
7740 8C27              ; Insert Param String
7741 8C27              ;
7742 8C27
7743 8C27              IsParamString  
7744 8C27              ;
7745 8C27              ; Get Pointer to ParmString
7746 8C27              ;
7747 8C27 0A                    asl   a                        ; calculate offset to ParamString
7748 8C28 0A                    asl   a                        ; in Dialog Manager zero page
7749 8C29 18                    clc   
7750 8C2A 69 90 00              adc   #ParamString0
7751 8C2D A8                    tay   
7752 8C2E B7 00                 lda   [<Globals],y
7753 8C30 85 0C                 sta   <ParmText
7754 8C32 C8                    iny   
7755 8C33 C8                    iny   
7756 8C34 B7 00                 lda   [<Globals],y
7757 8C36 85 0E                 sta   <ParmText+2
7758 8C38
7759 8C38 A7 0C                 lda   [<ParmText]
7760 8C3A 29 FF 00              and   #$FF
7761 8C3D F0 20                 beq   SkipExpChar              ; if the string is zero then just skip it, HY 7/26/88
7762 8C3F 85 10                 sta   <ParmLen
7763 8C41
7764 8C41 A2 01 00              ldx   #1
7765 8C44
7766 8C44              NextParmChar  
7767 8C44 9B                    txy   
7768 8C45 B7 0C                 lda   [<ParmText],y
7769 8C47 A4 1D                 ldy   <DestLen
7770 8C49 97 1F                 sta   [<DestText],y
7771 8C4B E8                    inx                            ; next 2 char.
7772 8C4C E8                    inx   
7773 8C4D E6 1D                 inc   <DestLen
7774 8C4F E6 1D                 inc   <DestLen
7775 8C51 E4 10                 cpx   <ParmLen
7776 8C53 90 EF                 blt   NextParmChar
7777 8C55 F0 ED                 beq   NextParmChar
7778 8C57
7779 8C57              ;
7780 8C57              ; if previous x was exactly ParmLen, then we copied 1 char more than ParmLen
7781 8C57              ;
7782 8C57 CA                    dex   
7783 8C58 CA                    dex   
7784 8C59 E4 10                 cpx   <ParmLen
7785 8C5B D0 02                 bne   SkipExpChar
7786 8C5D C6 1D                 dec   <DestLen                 ; we incremented too much
7787 8C5F
7788 8C5F              ;
7789 8C5F              ; Skip the two ^n characters, check if end of source text, continue if not
7790 8C5F              ;
7791 8C5F              SkipExpChar                             ; 
7792 8C5F E6 08                 inc   <SourceOffset            ; skip ^
7793 8C61 E6 08                 inc   <SourceOffset            ; next char
7794 8C63 A5 08                 lda   <SourceOffset
7795 8C65 C5 17                 cmp   <SourceLen
7796 8C67 B0 05                 bge   exit                     ; if n is last char, then we're done. 
7797 8C69                                                      ; changed bge CopyDestLength to bge Exit, because if
7798 8C69                                                      ; ^n was at end of line then the DestLen would be
7799 8C69                                                      ; incremented by one too many. HY 5/9/88
7800 8C69 82 19 FF              brl   NextSourceChar
7801 8C6C
7802 8C6C              CopyDestLength                          ; 
7803 8C6C E6 1D                 inc   <DestLen                 ; length is maxoffset+1
7804 8C6E
7805 8C6E              exit                                    ; 
7806 8C6E 2B A8 A3 16           unlink 
7807 8C82 6B                    rtl   
7808 8C83
7809 8C83              NotAllocated                            ; 
7810 8C83 AA                    tax                            ; save MMgr error code
7811 8C84 68                    pla                            ; pull useless result
7812 8C85 68                    pla   
7813 8C86 A5 19 85 1F           movelong <SourceText,<DestText   ; and pass original string as result
7814 8C8E A5 17 85 1D           moveword <SourceLen,<DestLen 
7815 8C92 8A                    txa   
7816 8C93 80 D9                 bra   exit
7817 8C95
7818 8C95                       ENDP 
7819 8C95
7820 8C95
7821 8C95              ;___________________________________________________________________________
7822 8C95              ;
7823 8C95              ;       LongStatTextDefProc
7824 8C95              ;
7825 8C95              ;       input: message:WORD - desired operation
7826 8C95              ;              param:LONG - depends on operation
7827 8C95              ;              theControl:LONG - handle to control
7828 8C95              ;
7829 8C95              ;      output: RetValue:LONG - depends on operation
7830 8C95              ;
7831 8C95              ; Change History
7832 8C95              ;
7833 8C95              ; 07 Oct 88         Steven Glass
7834 8C95              ;
7835 8C95              ; Only deref the control handle if the message is not recsize.
7836 8C95              ;____________________________________________________________________________
7837 8C95
7838 8C95                       ENTRY LongStatTextDefProc
7839 8C95              LongStatTextDefProc PROC 
7840 8C95
7841 8C95              ControlPtr equ   0
7842 8C95              Rect     equ   ControlPtr+4
7843 8C95              TextPtr  equ   Rect+8
7844 8C95              TextLen  equ   TextPtr+4
7845 8C95              SizeLocals equ   TextLen+2
7846 8C95
7847 8C95 EA                    nop   
7848 8C96 3B 38 E9 12           link 10,SizeLocals 
7849 8C9F
7850 8C9F              theControl equ   input
7851 8C9F              param    equ   theControl+4
7852 8C9F              CtlMessage equ   param+4
7853 8C9F
7854 8C9F              RetValue equ   output
7855 8C9F
7856 8C9F              ;
7857 8C9F              ; Zeroes out RetValue
7858 8C9F              ;
7859 8C9F 64 1F                 stz   <RetValue
7860 8CA1 64 21                 stz   <RetValue+2
7861 8CA3
7862 8CA3 A5 1D                 lda   <ctlMessage
7863 8CA5 C9 0C 00              cmp   #recSize
7864 8CA8 F0 27                 beq   SkipThis
7865 8CAA              ;
7866 8CAA              ; Get Pointer to control and copy display rectangle
7867 8CAA              ;
7868 8CAA A7 15 85 00           movelong [<theControl],0,<ControlPtr 
7869 8CB5
7870 8CB5 A0 08 00 B7           movelong [<ControlPtr],CtrlRect,<Rect 
7871 8CC3 A0 0C 00 B7           movelong [<ControlPtr],CtrlRect+4,<Rect+4 
7872 8CD1
7873 8CD1
7874 8CD1              SkipThis  
7875 8CD1 A5 1D                 lda   <CtlMessage
7876 8CD3 0A                    asl   a
7877 8CD4 AA                    tax   
7878 8CD5 BF DB 8C FC           lda   >CmdTable,x
7879 8CD9 48                    pha   
7880 8CDA 60                    rts   
7881 8CDB
7882 8CDB              CmdTable  
7883 8CDB FA 8C                 DC W:DrawLongStatText-1
7884 8CDD F4 8C                 DC W:LongStatTextExit-1
7885 8CDF 7B 8D                 DC W:TestLongStatText-1
7886 8CE1 F4 8C                 DC W:LongStatTextExit-1
7887 8CE3 F4 8C                 DC W:LongStatTextExit-1
7888 8CE5 F4 8C                 DC W:LongStatTextExit-1
7889 8CE7 F4 8C                 DC W:LongStatTextExit-1
7890 8CE9 F4 8C                 DC W:LongStatTextExit-1
7891 8CEB F4 8C                 DC W:LongStatTextExit-1
7892 8CED FA 8C                 DC W:DrawLongStatText-1        ; new value fall thru draw routine
7893 8CEF F4 8C                 DC W:LongStatTextExit-1
7894 8CF1 F4 8C                 DC W:LongStatTextExit-1
7895 8CF3 9F 8D                 DC W:RecLongStatText-1
7896 8CF5
7897 8CF5              LongStatTextExit  
7898 8CF5 A2 12 00              ldx   #SizeLocals
7899 8CF8 4C D3 89              jmp   quitdefproc
7900 8CFB
7901 8CFB
7902 8CFB              *******************
7903 8CFB              *
7904 8CFB              * Draw LongStatText
7905 8CFB              *
7906 8CFB              ******************
7907 8CFB
7908 8CFB              DrawLongStatText  
7909 8CFB
7910 8CFB              ;
7911 8CFB              ; Call TextBox to draw the static text
7912 8CFB              ;
7913 8CFB 20 6D 93              jsr   NormalTextColor
7914 8CFE              ;
7915 8CFE              ; Using TextPtr, creates a new string where the ^n are replaced by the ParamStr
7916 8CFE              ;
7917 8CFE
7918 8CFE A0 12 00              ldy   #CtrlValue
7919 8D01 B7 00                 lda   [<ControlPtr],y
7920 8D03 85 10                 sta   <TextLen
7921 8D05
7922 8D05              ;
7923 8D05              ; If empty string, exit
7924 8D05              ;
7925 8D05 F0 72                 beq   exit
7926 8D07
7927 8D07
7928 8D07 48                    pha                            ; space for new text pointer
7929 8D08 48                    pha   
7930 8D09 48                    pha                            ; space for new text length
7931 8D0A A0 1E 00 B7           pushlong [<ControlPtr],CtrlData 
7932 8D16 A5 10 48              pushword TextLen 
7933 8D19 22 30 8B FC           jsl   InsertParamString
7934 8D1D 68 85 10              pullword <TextLen 
7935 8D20 68 85 0C 68           pulllong <TextPtr 
7936 8D26
7937 8D26 A5 0E 48 A5           pushlong TextPtr 
7938 8D2C A5 10 48              pushword TextLen 
7939 8D2F
7940 8D2F F4 00 00 7B           pushzptr <Rect 
7941 8D38
7942 8D38 F4 00 00              pushword #0                    ; Left justification
7943 8D3B
7944 8D3B
7945 8D3B
7946 8D3B              ;
7947 8D3B              ; Re-deref the handle to the control and see which longstattext type we have
7948 8D3B              ; (Added SEG 16 Aug 88)
7949 8D3B A7 15 85 00           movelong [<theControl],0,<ControlPtr 
7950 8D46
7951 8D46              ;
7952 8D46              ; Check for LongStatText or LongStatText2, DAN H.
7953 8D46              ;
7954 8D46
7955 8D46 A0 22 00              ldy   #CtrlrefCon+2            ; where ItemType was stored, DAN H.
7956 8D49 B7 00                 lda   [<ControlPtr],y          ; get ItemType, DAN H.
7957 8D4B 29 FF 7F              and   #$7fff                   ; DAN H.
7958 8D4E C9 16 00              cmp   #LongStatText2           ; see if LongStatText2, DAN H.
7959 8D51 D0 09                 bne   JustLSText               ; DAN H.
7960 8D53 A2 14 20 22           _LETextBox2                    ; DAN H.
7961 8D5A 80 07                 bra   OverLSText               ; DAN H.
7962 8D5C
7963 8D5C              JustLSText  
7964 8D5C
7965 8D5C A2 14 18 22           _LETextBox 
7966 8D63
7967 8D63              OverLSText  
7968 8D63              ;
7969 8D63              ; Dispose of pointer (actually handle for the created string)
7970 8D63              ;
7971 8D63 48                    pha                            ; space for handle
7972 8D64 48                    pha   
7973 8D65 A5 0E 48 A5           pushlong TextPtr 
7974 8D6B A2 02 1A 22           _FindHandle 
7975 8D72 A2 02 10 22           _DisposeHandle 
7976 8D79
7977 8D79 82 79 FF     exit     brl   LongStatTextExit
7978 8D7C
7979 8D7C
7980 8D7C              *******************
7981 8D7C              *
7982 8D7C              * Test LongStatText
7983 8D7C              *
7984 8D7C              ******************
7985 8D7C
7986 8D7C              TestLongStatText  
7987 8D7C
7988 8D7C A9 0D 00 85           movelong #inLongStatText,<RetValue 
7989 8D86              ;
7990 8D86              ; Check for LongStatText2, DAN H.
7991 8D86              ;
7992 8D86
7993 8D86 A0 22 00              ldy   #CtrlrefCon+2            ; where ItemType was stored, DAN H.
7994 8D89 B7 00                 lda   [<ControlPtr],y          ; get ItemType, DAN H.
7995 8D8B 29 FF 7F              and   #$7fff                   ; DAN H.
7996 8D8E C9 16 00              cmp   #LongStatText2           ; see if LongStatText2, DAN H.
7997 8D91 D0 0A                 bne   TJustLSText              ; DAN H.
7998 8D93 A9 0F 00 85           movelong #inLongStatText2,<RetValue   ; DAN H.
7999 8D9D
8000 8D9D              TJustLSText  
8001 8D9D
8002 8D9D 82 55 FF              brl   LongStatTextExit
8003 8DA0
8004 8DA0
8005 8DA0              *******************
8006 8DA0              *
8007 8DA0              * RecSize LongStatText
8008 8DA0              *
8009 8DA0              ******************
8010 8DA0
8011 8DA0              RecLongStatText  
8012 8DA0
8013 8DA0              ;
8014 8DA0              ; Returns LongStatTextSIZE
8015 8DA0              ;
8016 8DA0 A9 2E 00 85           movelong #LongStatTextSIZE,<RetValue 
8017 8DAA
8018 8DAA 82 48 FF              brl   LongStatTextExit
8019 8DAD
8020 8DAD                       ENDP 
8021 8DAD
8022 8DAD
8023 8DAD              ;            copy  EditLine.asm
8024 8DAD              ; LineEdit.asm                           Jean-Charles Mourey
8025 8DAD
8026 8DAD                       TITLE 'EditLine Item Definition Procedure'
8027 8DAD
8028 8DAD
8029 8DAD              ;___________________________________________________________________________
8030 8DAD              ;
8031 8DAD              ;       EditLineDefProc
8032 8DAD              ;
8033 8DAD              ;       input: message:WORD - desired operation
8034 8DAD              ;              param:LONG - depends on operation
8035 8DAD              ;              theControl:LONG - handle to control
8036 8DAD              ;
8037 8DAD              ;      output: RetValue:LONG - depends on operation
8038 8DAD              ;____________________________________________________________________________
8039 8DAD
8040 8DAD                       ENTRY EditLineDefProc
8041 8DAD              EditLineDefProc PROC 
8042 8DAD
8043 8DAD              ControlPtr equ   0
8044 8DAD              Rect     equ   ControlPtr+4
8045 8DAD              Dialog   equ   Rect+RECTSIZE
8046 8DAD              hLE      equ   Dialog+4
8047 8DAD              TextPtr  equ   hLE+4
8048 8DAD              TextLen  equ   TextPtr+4
8049 8DAD              OldEditControl equ   TextLen+2
8050 8DAD              FontInfo equ   OldEditControl+4
8051 8DAD              FontHeight equ   FontInfo+8
8052 8DAD              DestRect equ   FontHeight+2
8053 8DAD              SizeLocals equ   DestRect+RECTSIZE
8054 8DAD
8055 8DAD EA                    nop   
8056 8DAE 3B 38 E9 30           link 10,SizeLocals 
8057 8DB7
8058 8DB7              theControl equ   input
8059 8DB7              param    equ   theControl+4
8060 8DB7              CtlMessage equ   param+4
8061 8DB7
8062 8DB7              RetValue equ   output
8063 8DB7
8064 8DB7              ;
8065 8DB7              ; Zeroes out RetValue
8066 8DB7              ;
8067 8DB7 64 3D                 stz   <RetValue
8068 8DB9 64 3F                 stz   <RetValue+2
8069 8DBB
8070 8DBB              ;
8071 8DBB              ; Check to see which message.  If it is the RecSize msg then
8072 8DBB              ; skip this part which sets port and origin since pointers
8073 8DBB              ; in control handle are not yet valid.
8074 8DBB              ;
8075 8DBB A5 3B                 lda   <CtlMessage
8076 8DBD C9 0C 00              cmp   #RecSize
8077 8DC0 F0 59                 beq   SkipThisShit
8078 8DC2              ;
8079 8DC2              ; Derefence Control Handle
8080 8DC2              ;
8081 8DC2 A7 33 85 00           movelong [<theControl],0,<ControlPtr 
8082 8DCD
8083 8DCD              ;
8084 8DCD              ; Get a copy of the enclosing rect
8085 8DCD              ;
8086 8DCD A0 08 00 B7           movelong [<ControlPtr],CtrlRect,<Rect 
8087 8DDB A0 0C 00 B7           movelong [<ControlPtr],CtrlRect+4,<Rect+4 
8088 8DE9
8089 8DE9              ;
8090 8DE9              ; Set Port and origin
8091 8DE9              ;
8092 8DE9 A0 04 00 B7           movelong [<ControlPtr],CtrlOwner,<Dialog 
8093 8DF7
8094 8DF7 A5 0E 48 A5           pushlong Dialog 
8095 8DFD A2 04 1B 22           _SetPort 
8096 8E04
8097 8E04 A9 00 00              lda   #0
8098 8E07 48                    pha   
8099 8E08 48                    pha   
8100 8E09 A2 04 23 22           _SetOrigin 
8101 8E10
8102 8E10              ;
8103 8E10              ; Get Control Pointer again
8104 8E10              ;
8105 8E10 A7 33 85 00           movelong [<theControl],0,<ControlPtr 
8106 8E1B
8107 8E1B              SkipThisShit  
8108 8E1B              ;
8109 8E1B              ; Dispatch
8110 8E1B              ;
8111 8E1B A5 3B                 lda   <CtlMessage
8112 8E1D 0A                    asl   a
8113 8E1E AA                    tax   
8114 8E1F BF 25 8E FC           lda   >CmdTable,x
8115 8E23 48                    pha   
8116 8E24 60                    rts   
8117 8E25
8118 8E25              CmdTable  
8119 8E25 44 8E                 DC W:DrawEditLine-1
8120 8E27 3E 8E                 DC W:EditLineExit-1
8121 8E29 C2 8E                 DC W:TestEditLine-1
8122 8E2B 6A 8F                 DC W:InitEditLine-1
8123 8E2D 90 90                 DC W:DispEditLine-1
8124 8E2F 3E 8E                 DC W:EditLineExit-1
8125 8E31 3E 8E                 DC W:EditLineExit-1
8126 8E33 3E 8E                 DC W:EditLineExit-1
8127 8E35 3E 8E                 DC W:EditLineExit-1
8128 8E37 44 8E                 DC W:DrawEditLine-1            ; new value fall thru draw routine
8129 8E39 3E 8E                 DC W:EditLineExit-1
8130 8E3B 3E 8E                 DC W:EditLineExit-1
8131 8E3D CA 90                 DC W:RecEditLine-1
8132 8E3F
8133 8E3F              EditLineExit  
8134 8E3F A2 30 00              ldx   #SizeLocals
8135 8E42 4C D3 89              jmp   quitdefproc
8136 8E45
8137 8E45              *******************
8138 8E45              *
8139 8E45              * Draw EditLine
8140 8E45              *
8141 8E45              ******************
8142 8E45
8143 8E45              DrawEditLine  
8144 8E45 20 6D 93              jsr   NormalTextColor
8145 8E48              ;
8146 8E48              ; Draw EditLine enclosing rect
8147 8E48              ;
8148 8E48 F4 00 00              pushword #BLACK 
8149 8E4B A2 04 37 22           _SetSolidPenPat 
8150 8E52
8151 8E52              ;
8152 8E52              ; Frame the surrounding Rect
8153 8E52              ;
8154 8E52 F4 02 00              pushword #2 
8155 8E55 F4 01 00              pushword #1 
8156 8E58 A2 04 2C 22           _SetPenSize 
8157 8E5F
8158 8E5F F4 00 00 7B           pushzptr <Rect 
8159 8E68 A2 04 53 22           _FrameRect 
8160 8E6F
8161 8E6F F4 01 00              pushword #1 
8162 8E72 F4 01 00              pushword #1 
8163 8E75 A2 04 2C 22           _SetPenSize 
8164 8E7C
8165 8E7C              ;
8166 8E7C              ; Erase the inner Rect
8167 8E7C              ;
8168 8E7C F4 00 00 7B           pushzptr <Rect 
8169 8E85 F4 02 00              pushword #2 
8170 8E88 F4 01 00              pushword #1 
8171 8E8B A2 04 4C 22           _InsetRect 
8172 8E92
8173 8E92 F4 00 00 7B           pushzptr <Rect 
8174 8E9B A2 04 55 22           _EraseRect 
8175 8EA2
8176 8EA2              ;
8177 8EA2              ; ReDraws the Line by calling LineEdit
8178 8EA2              ;
8179 8EA2 A7 33 85 00           movelong [<theControl],0,<ControlPtr 
8180 8EAD A0 1E 00 B7           pushlong [<ControlPtr],CtrlData   ; CtrlData = hLE
8181 8EB9 A2 14 17 22           _LEUpdate 
8182 8EC0
8183 8EC0 82 7C FF              brl   EditLineExit
8184 8EC3
8185 8EC3
8186 8EC3              *******************
8187 8EC3              *
8188 8EC3              * Test EditLine
8189 8EC3              *
8190 8EC3              ******************
8191 8EC3
8192 8EC3              TestEditLine  
8193 8EC3
8194 8EC3              ;
8195 8EC3              ; Else returns the part Code inEditLine
8196 8EC3              ;
8197 8EC3 A9 0B 00 85           movelong #inEditLine,<RetValue 
8198 8ECD
8199 8ECD              ;
8200 8ECD              ; Get ID of previous active EditLine Item
8201 8ECD              ;
8202 8ECD A7 33 85 00           movelong [<theControl],0,<ControlPtr 
8203 8ED8
8204 8ED8 A0 14 01              ldy   #edittextID-wport
8205 8EDB B7 0C                 lda   [<Dialog],y
8206 8EDD
8207 8EDD              ;
8208 8EDD              ; If no previous active item, set the new one active
8209 8EDD              ;
8210 8EDD F0 47                 beq   SetNewEditItem
8211 8EDF
8212 8EDF              ;
8213 8EDF              ; If there was one, compare its ID to the item hit ID
8214 8EDF              ;
8215 8EDF A0 20 00              ldy   #iitemid
8216 8EE2 D7 00                 cmp   [<ControlPtr],y
8217 8EE4
8218 8EE4              ;
8219 8EE4              ; If same ID, exit directly
8220 8EE4              ;
8221 8EE4 D0 03                 bne   GetOldEditLine
8222 8EE6 82 56 FF              brl   EditLineExit
8223 8EE9
8224 8EE9              ;
8225 8EE9              ; if not same, deactivate old Edit Line item
8226 8EE9              ;
8227 8EE9              GetOldEditLine  
8228 8EE9 AA                    tax   
8229 8EEA 48                    pha                            ; space for control
8230 8EEB 48                    pha   
8231 8EEC A5 0E 48 A5           pushlong Dialog 
8232 8EF2 DA                    phx   
8233 8EF3 A2 15 1E 22           _GetControlDItem 
8234 8EFA 68 85 1A 68           pulllong <OldEditControl 
8235 8F00
8236 8F00 A5 1A                 lda   <OldEditControl
8237 8F02 D0 04                 bne   DeactivateOld
8238 8F04 A5 1A                 lda   <OldEditControl          ;BUG in ROM 03
8239 8F06 F0 1E                 beq   SetNewEditItem
8240 8F08
8241 8F08              DeactivateOld  
8242 8F08 A7 1A 85 00           movelong [<OldEditControl],0,<ControlPtr 
8243 8F13 A0 1E 00 B7           pushlong [<ControlPtr],CtrlData 
8244 8F1F A2 14 10 22           _LEDeactivate 
8245 8F26
8246 8F26              ;
8247 8F26              ; Set this EditLine item as the current one being edited
8248 8F26              ;
8249 8F26              SetNewEditItem  
8250 8F26 A7 33 85 00           movelong [<theControl],0,<ControlPtr 
8251 8F31 A0 20 00              ldy   #iitemid
8252 8F34 B7 00                 lda   [<ControlPtr],y
8253 8F36 A0 14 01              ldy   #edittextID-wport
8254 8F39 97 0C                 sta   [<Dialog],y
8255 8F3B
8256 8F3B A0 1C 00 B7           movelong [<ControlPtr],CtrlData,<hLE 
8257 8F49
8258 8F49 A9 00 00              lda   #0
8259 8F4C 48                    pha   
8260 8F4D 48                    pha   
8261 8F4E A5 12 48 A5           pushlong hLE 
8262 8F54 A2 14 0E 22           _LESetSelect 
8263 8F5B
8264 8F5B              ;
8265 8F5B              ; Activate New Edit Item
8266 8F5B              ;
8267 8F5B A5 12 48 A5           pushlong hLE 
8268 8F61 A2 14 0F 22           _LEActivate 
8269 8F68
8270 8F68 82 D4 FE              brl   EditLineExit
8271 8F6B
8272 8F6B
8273 8F6B              *******************
8274 8F6B              *
8275 8F6B              * Init EditLine
8276 8F6B              *
8277 8F6B              ******************
8278 8F6B
8279 8F6B              InitEditLine  
8280 8F6B
8281 8F6B              ;
8282 8F6B              ; Get a pointer to the string
8283 8F6B              ;
8284 8F6B A0 1C 00 B7           movelong [<ControlPtr],CtrlData,<TextPtr  ; points to default string
8285 8F79 A0 12 00 B7           movelong [<ControlPtr],CtrlValue,<TextLen  ; max string length
8286 8F87
8287 8F87              ;
8288 8F87              ; Calculate the view rectangle
8289 8F87              ;
8290 8F87 F4 00 00 7B           pushzptr Rect 
8291 8F90 F4 02 00              pushword #2 
8292 8F93 F4 01 00              pushword #1 
8293 8F96 A2 04 4C 22           _InsetRect 
8294 8F9D
8295 8F9D              ;
8296 8F9D              ; Calculate the font height
8297 8F9D              ;
8298 8F9D F4 00 00 7B           pushzptr FontInfo 
8299 8FA6 A2 04 96 22           _GetFontInfo 
8300 8FAD
8301 8FAD A5 1E                 lda   <FontInfo                ; ascent
8302 8FAF 18                    clc   
8303 8FB0 65 20                 adc   <FontInfo+2              ; descent
8304 8FB2 65 24                 adc   <FontInfo+6              ; leading
8305 8FB4 85 26                 sta   <FontHeight
8306 8FB6
8307 8FB6              ;
8308 8FB6              ; Calculate how much the destRect must be inseted
8309 8FB6              ;
8310 8FB6 A5 04 85 28           movelong <Rect,<DestRect 
8311 8FBE A5 08 85 2C           movelong <Rect+4,<DestRect+4 
8312 8FC6
8313 8FC6 A5 08                 lda   <Rect+y2                 ; inset = (viewRect.y2 - viewRect.y1
8314 8FC8 38                    sec                            ;         - FontHeight)/2
8315 8FC9 E5 04                 sbc   <Rect+y1
8316 8FCB E5 26                 sbc   <FontHeight
8317 8FCD 4A                    lsr   a
8318 8FCE AA                    tax   
8319 8FCF
8320 8FCF F4 00 00 7B           pushzptr DestRect 
8321 8FD8 F4 04 00              pushword #4                    ; horizontal inset = 4
8322 8FDB DA                    phx                            ; vertical inset computed to center text
8323 8FDC A2 04 4C 22           _InsetRect 
8324 8FE3
8325 8FE3              ;
8326 8FE3              ; Create the LineEdit Record
8327 8FE3              ;
8328 8FE3 48                    pha                            ; space for Line Edit Handle
8329 8FE4 48                    pha   
8330 8FE5 F4 00 00 7B           pushzptr <DestRect 
8331 8FEE F4 00 00 7B           pushzptr <Rect 
8332 8FF7 A5 18 48              pushword TextLen 
8333 8FFA A2 14 09 22           _LENew 
8334 9001 68 85 10 68           pulllong <hLE 
8335 9007
8336 9007              ;
8337 9007              ; Deactivate it (so it is created deactivated)
8338 9007              ;
8339 9007 A5 12 48 A5           pushlong hLE 
8340 900D A2 14 10 22           _LEDeactivate 
8341 9014
8342 9014              ;
8343 9014              ; Test if TextPtr is Nil or not
8344 9014              ;
8345 9014 A5 14                 lda   <TextPtr
8346 9016 D0 04                 bne   DefaultText
8347 9018 A5 16                 lda   <TextPtr+2
8348 901A F0 2C                 beq   StorehLE
8349 901C
8350 901C              ;
8351 901C              ; Set the edit text to the string passed as parameter
8352 901C              ;
8353 901C              DefaultText                             ; 
8354 901C A7 14                 lda   [<TextPtr]               ; Get Length byte in TextLen
8355 901E 29 FF 00              and   #$FF
8356 9021 85 18                 sta   <TextLen
8357 9023
8358 9023 A5 14 18 69           add4 <TextPtr,#1,<TextPtr      ; Get pointer to beginning of text
8359 9032
8360 9032 A5 16 48 A5           pushlong TextPtr 
8361 9038 A5 18 48              pushword TextLen 
8362 903B A5 12 48 A5           pushlong hLE 
8363 9041 A2 14 0B 22           _LESetText 
8364 9048
8365 9048              ;
8366 9048              ; Store hLE in CtrlData field of item
8367 9048              ;
8368 9048              StorehLE  
8369 9048 A7 33 85 00           movelong [<theControl],0,<ControlPtr 
8370 9053
8371 9053 A0 1C 00              ldy   #CtrlData
8372 9056 A5 10                 lda   <hLE
8373 9058 97 00                 sta   [<ControlPtr],y
8374 905A C8                    iny   
8375 905B C8                    iny   
8376 905C A5 12                 lda   <hLE+2
8377 905E 97 00                 sta   [<ControlPtr],y
8378 9060
8379 9060              ;
8380 9060              ; If there is yet no current edit line item (ie there is yet NO edit line item),
8381 9060              ; set this one to the current one
8382 9060              ;
8383 9060 A0 04 00 B7           movelong [<ControlPtr],CtrlOwner,<Dialog 
8384 906E A0 14 01              ldy   #edittextID-wport
8385 9071 B7 0C                 lda   [<Dialog],y
8386 9073 D0 19                 bne   InitExit
8387 9075
8388 9075 A5 0E 48 A5           pushlong Dialog 
8389 907B A0 20 00              ldy   #iitemid
8390 907E B7 00                 lda   [<ControlPtr],y
8391 9080 48                    pha   
8392 9081 F4 00 00              pushword #0 
8393 9084 F4 FF 7F              pushword #32767 
8394 9087 A2 15 21 22           _SelIText 
8395 908E
8396 908E 82 AE FD     InitExit brl   EditLineExit
8397 9091
8398 9091
8399 9091
8400 9091              *******************
8401 9091              *
8402 9091              * Disp EditLine
8403 9091              *
8404 9091              ******************
8405 9091
8406 9091              DispEditLine  
8407 9091
8408 9091              ;
8409 9091              ; Test if disposed item is the active one
8410 9091              ;
8411 9091 A0 04 00 B7           movelong [<ControlPtr],CtrlOwner,<Dialog 
8412 909F
8413 909F A0 14 01              ldy   #edittextID-wport
8414 90A2 B7 0C                 lda   [<Dialog],y
8415 90A4
8416 90A4              ;
8417 90A4              ; If no active item, nothing to worry about
8418 90A4              ;
8419 90A4 F0 0F                 beq   DisposeIt
8420 90A6
8421 90A6              ;
8422 90A6              ; If there is one, compare its ID to the disposed item ID
8423 90A6              ;
8424 90A6 A0 20 00              ldy   #iitemid
8425 90A9 D7 00                 cmp   [<ControlPtr],y
8426 90AB
8427 90AB              ;
8428 90AB              ; If different ID, nothing to worry about
8429 90AB              ;
8430 90AB D0 08                 bne   DisposeIt
8431 90AD
8432 90AD              ;
8433 90AD              ; If same ID, clear the edittextID field
8434 90AD              ;
8435 90AD A9 00 00              lda   #0
8436 90B0 A0 14 01              ldy   #edittextID-wport
8437 90B3 97 0C                 sta   [<Dialog],y
8438 90B5
8439 90B5              ;
8440 90B5              ; Dispose of hLE
8441 90B5              ;
8442 90B5              DisposeIt  
8443 90B5 A0 1E 00 B7           pushlong [<ControlPtr],CtrlData 
8444 90C1 A2 14 0A 22           _LEDispose 
8445 90C8
8446 90C8              ;
8447 90C8              ; Allows the Control Manager to continue disposal
8448 90C8              ;
8449 90C8
8450 90C8 82 74 FD              brl   EditLineExit
8451 90CB
8452 90CB
8453 90CB              *******************
8454 90CB              *
8455 90CB              * RecSize EditLine
8456 90CB              *
8457 90CB              ******************
8458 90CB
8459 90CB              RecEditLine  
8460 90CB
8461 90CB              ;
8462 90CB              ; Returns EditLineSIZE
8463 90CB              ;
8464 90CB A9 28 00 85           movelong #EditLineSIZE,<RetValue 
8465 90D5
8466 90D5 82 67 FD              brl   EditLineExit
8467 90D8
8468 90D8                       ENDP 
8469 90D8
8470 90D8
8471 90D8              ;            copy  DScroll.asm
8472 90D8              ; DScroll.asm                           Jean-Charles Mourey
8473 90D8
8474 90D8                       TITLE 'Dialog Scroll Bars action procedure'
8475 90D8
8476 90D8              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
8477 90D8              ;
8478 90D8              ;       scroll_action
8479 90D8              ;
8480 90D8              ;      input: partCode:WORD - Selected part.
8481 90D8              ;             theControl:LONG - Handle to control.
8482 90D8              ;
8483 90D8              ;     output: none.
8484 90D8              ;
8485 90D8              ;     function: track the scroll bar and call the dialog scroll bar def proc.
8486 90D8              ;
8487 90D8              ;       MyDialogScrollBar:
8488 90D8              ;
8489 90D8              ;           input: command:WORD
8490 90D8              ;                  dialog:LONG - dialog the scroll bar is in.
8491 90D8              ;                  ScrollBarID:WORD - item ID of scroll bar.
8492 90D8              ;
8493 90D8              ;          output: result:WORD
8494 90D8              ;
8495 90D8              ;      command: getinitview    = 1      output = init view
8496 90D8              ;               getinittotal   = 2      output = init total
8497 90D8              ;               getinitvalue   = 3      output = init value
8498 90D8              ;               scrolllineup   = 4      output = new value
8499 90D8              ;               scrolllinedown = 5      output = new value
8500 90D8              ;               scrollpageup   = 6      output = new value
8501 90D8              ;               scrollpagedown = 7      output = new value
8502 90D8              ;               scrollthumb    = 8      output = new value
8503 90D8              ;
8504 90D8              ;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
8505 90D8
8506 90D8                       ENTRY scroll_action
8507 90D8              scroll_action PROC 
8508 90D8
8509 90D8              ControlPtr equ   0
8510 90D8              DlgScrollAction equ   ControlPtr+4
8511 90D8              SizeLocals equ   DlgScrollAction+4
8512 90D8
8513 90D8 EA                    nop   
8514 90D9 3B 38 E9 08           link 6,SizeLocals 
8515 90E2
8516 90E2              theControl equ   input
8517 90E2              partCode equ   theControl+4
8518 90E2
8519 90E2              ;
8520 90E2              ; Get address of Dialog Scroll Bar Action
8521 90E2              ;
8522 90E2 A7 0B 85 00           movelong [<theControl],0,<ControlPtr 
8523 90ED A0 38 00 B7           movelong [<ControlPtr],iScrollBarDef,<DlgScrollAction 
8524 90FB
8525 90FB              ;
8526 90FB              ; if no action, exit
8527 90FB              ;
8528 90FB A5 04                 lda   <DlgScrollAction
8529 90FD D0 04                 bne   LetScroll
8530 90FF A5 06                 lda   <DlgScrollAction+2
8531 9101 F0 60                 beq   exit
8532 9103
8533 9103              ;
8534 9103              ; Call the Dialog Scroll Bar Action Procedure
8535 9103              ;
8536 9103              LetScroll                               ; 
8537 9103 48                    pha                            ; space for result
8538 9104
8539 9104 A5 0F                 lda   <PartCode                ; command number
8540 9106 C9 05 00              cmp   #UP_PART
8541 9109 D0 05                 bne   isDown
8542 910B A9 04 00              lda   #scrolllineup
8543 910E 80 2B                 bra   CallIt
8544 9110
8545 9110 C9 06 00     isDown   cmp   #DOWN_PART
8546 9113 D0 05                 bne   isPageUp
8547 9115 A9 05 00              lda   #scrolllinedown
8548 9118 80 21                 bra   CallIt
8549 911A
8550 911A C9 07 00     isPageUp cmp   #UPP_PART
8551 911D D0 05                 bne   isPageDown
8552 911F A9 06 00              lda   #scrollpageup
8553 9122 80 17                 bra   CallIt
8554 9124
8555 9124 C9 08 00     isPageDown cmp   #DOWNP_PART
8556 9127 D0 05                 bne   isThumb
8557 9129 A9 07 00              lda   #scrollpagedown
8558 912C 80 0D                 bra   CallIt
8559 912E
8560 912E C9 81 00     isThumb  cmp   #THUMB_PART
8561 9131 D0 05                 bne   isNothin
8562 9133 A9 08 00              lda   #scrollthumb
8563 9136 80 03                 bra   CallIt
8564 9138
8565 9138 68           isNothin pla   
8566 9139 80 28                 bra   exit
8567 913B
8568 913B              CallIt    
8569 913B 48                    pha                            ; push command number
8570 913C A0 06 00 B7           pushlong [<ControlPtr],CtrlOwner  ; push dialog
8571 9148
8572 9148 A0 20 00              ldy   #iitemid                 ; push Scroll Bar ID
8573 914B B7 00                 lda   [<ControlPtr],y
8574 914D 48                    pha   
8575 914E A5 04                 lda   <DlgScrollAction
8576 9150 A6 05                 ldx   <DlgScrollAction+1
8577 9152 22 52 89 FC           jsl   long_call                ; new value is on stack
8578 9156
8579 9156              ;
8580 9156              ; Set new value for control using result of scroll bar dialog action proc.
8581 9156              ;
8582 9156 A5 0D 48 A5           pushlong theControl 
8583 915C A2 10 19 22           _SetCtlValue 
8584 9163
8585 9163              exit      
8586 9163 2B A8 A3 0A           unlink 
8587 9177 6B                    rtl   
8588 9178                       ENDP 
8589 9178
8590 9178
8591 9178              ;            copy  UserItem.asm
8592 9178              ; UserItem.asm                           Jean-Charles Mourey
8593 9178
8594 9178                       TITLE 'UserItem Definition Procedure'
8595 9178
8596 9178
8597 9178              ;___________________________________________________________________________
8598 9178              ;
8599 9178              ;       UserItemDefProc
8600 9178              ;
8601 9178              ;       input: message:WORD - desired operation
8602 9178              ;              param:LONG - depends on operation
8603 9178              ;              theControl:LONG - handle to control
8604 9178              ;
8605 9178              ;      output: RetValue:LONG - depends on operation
8606 9178              ;
8607 9178              ;    function: Implements the user item as a custom control. Calls the user
8608 9178              ;              item definition procedure to draw the item.
8609 9178              ;
8610 9178              ;        MyItem:
8611 9178              ;              input: theDialog:LONG - pointer to the dialog's grafport
8612 9178              ;                     itemID:WORD - ID of item to draw
8613 9178              ;
8614 9178              ;             output: none
8615 9178              ;____________________________________________________________________________
8616 9178
8617 9178                       ENTRY UserItemDefProc
8618 9178              UserItemDefProc PROC 
8619 9178
8620 9178              ControlPtr equ   0
8621 9178              Rect     equ   ControlPtr+4
8622 9178              Dialog   equ   Rect+RECTSIZE
8623 9178              UserItemProc equ   Dialog+4
8624 9178              SizeLocals equ   UserItemProc+4
8625 9178
8626 9178 EA                    nop   
8627 9179 3B 38 E9 14           link 10,SizeLocals 
8628 9182
8629 9182              theControl equ   input
8630 9182              param    equ   theControl+4
8631 9182              CtlMessage equ   param+4
8632 9182
8633 9182              RetValue equ   output
8634 9182
8635 9182              ;
8636 9182              ; Zeroes out RetValue
8637 9182              ;
8638 9182 64 21                 stz   <RetValue
8639 9184 64 23                 stz   <RetValue+2
8640 9186
8641 9186              ;
8642 9186              ; Check to see which message.  If it is the RecSize msg then
8643 9186              ; skip this part which sets port and origin since pointers
8644 9186              ; in control handle are not yet valid.
8645 9186              ;
8646 9186 A5 1F                 lda   <CtlMessage
8647 9188 C9 0C 00              cmp   #RecSize
8648 918B F0 3D                 beq   SkipThisShit
8649 918D              ;
8650 918D              ; Dereference Control Handle
8651 918D              ;
8652 918D A7 17 85 00           movelong [<theControl],0,<ControlPtr 
8653 9198
8654 9198              ;
8655 9198              ; Get pointer to the dialog
8656 9198              ;
8657 9198 A0 04 00 B7           movelong [<ControlPtr],CtrlOwner,<Dialog 
8658 91A6
8659 91A6 A5 0E 48 A5           pushlong Dialog 
8660 91AC A2 04 1B 22           _SetPort 
8661 91B3
8662 91B3 A9 00 00              lda   #0
8663 91B6 48                    pha   
8664 91B7 48                    pha   
8665 91B8 A2 04 23 22           _SetOrigin 
8666 91BF
8667 91BF              ;
8668 91BF              ; Dereference Control Handle again
8669 91BF              ;
8670 91BF A7 17 85 00           movelong [<theControl],0,<ControlPtr 
8671 91CA
8672 91CA
8673 91CA              ;
8674 91CA              ; Dispatch message
8675 91CA              ;
8676 91CA              SkipThisShit  
8677 91CA A5 1F                 lda   <CtlMessage
8678 91CC 0A                    asl   a
8679 91CD AA                    tax   
8680 91CE BF D4 91 FC           lda   >CmdTable,x
8681 91D2 48                    pha   
8682 91D3 60                    rts   
8683 91D4
8684 91D4              CmdTable  
8685 91D4 F3 91                 DC W:DrawUserItem-1
8686 91D6 ED 91                 DC W:UserItemExit-1
8687 91D8 20 92                 DC W:TestUserItem-1
8688 91DA ED 91                 DC W:UserItemExit-1
8689 91DC ED 91                 DC W:UserItemExit-1
8690 91DE ED 91                 DC W:UserItemExit-1
8691 91E0 ED 91                 DC W:UserItemExit-1
8692 91E2 ED 91                 DC W:UserItemExit-1
8693 91E4 ED 91                 DC W:UserItemExit-1
8694 91E6 F3 91                 DC W:DrawUserItem-1            ; new value fall thru draw routine
8695 91E8 ED 91                 DC W:UserItemExit-1
8696 91EA ED 91                 DC W:UserItemExit-1
8697 91EC 2D 92                 DC W:RecUserItem-1
8698 91EE
8699 91EE              UserItemExit  
8700 91EE A2 14 00              ldx   #SizeLocals
8701 91F1 4C D3 89              jmp   quitdefproc
8702 91F4
8703 91F4
8704 91F4              *******************
8705 91F4              *
8706 91F4              * Draw UserItem
8707 91F4              *
8708 91F4              ******************
8709 91F4
8710 91F4              DrawUserItem  
8711 91F4
8712 91F4              ;
8713 91F4              ; Call the User Item definition procedure to draw it
8714 91F4              ;
8715 91F4 A0 1C 00 B7           movelong [<ControlPtr],CtrlData,<UserItemProc 
8716 9202
8717 9202 A5 10                 lda   <UserItemProc
8718 9204 D0 04                 bne   CallIt
8719 9206 A5 12                 lda   <UserItemProc+2
8720 9208 F0 14                 beq   DrawExit
8721 920A
8722 920A              CallIt                                  ; 
8723 920A A5 0E 48 A5           pushlong Dialog                ; pass dialog pointer
8724 9210 A0 20 00              ldy   #iitemid                 ;  and item ID
8725 9213 B7 00                 lda   [<ControlPtr],y
8726 9215 48                    pha   
8727 9216 A5 10                 lda   <UserItemProc
8728 9218 A6 11                 ldx   <UserItemProc+1
8729 921A 22 52 89 FC           jsl   long_call
8730 921E
8731 921E 82 CD FF     DrawExit brl   UserItemExit
8732 9221
8733 9221
8734 9221              *******************
8735 9221              *
8736 9221              * Test UserItem
8737 9221              *
8738 9221              ******************
8739 9221
8740 9221              TestUserItem  
8741 9221
8742 9221 A9 0C 00 85           movelong #inUserItem,<RetValue 
8743 922B
8744 922B 82 C0 FF              brl   UserItemExit
8745 922E
8746 922E
8747 922E              *******************
8748 922E              *
8749 922E              * RecSize UserItem
8750 922E              *
8751 922E              ******************
8752 922E
8753 922E              RecUserItem  
8754 922E
8755 922E              ;
8756 922E              ; Returns UserItemSIZE
8757 922E              ;
8758 922E A9 28 00 85           movelong #UserItemSIZE,<RetValue 
8759 9238
8760 9238 82 B3 FF              brl   UserItemExit
8761 923B
8762 923B                       ENDP 
8763 923B
8764 923B
8765 923B              ;            copy  IconItem.asm
8766 923B              ; IconItem.asm                           Jean-Charles Mourey
8767 923B
8768 923B                       TITLE 'IconItem Definition Procedure'
8769 923B
8770 923B
8771 923B              ;___________________________________________________________________________
8772 923B              ;
8773 923B              ;       IconItemDefProc
8774 923B              ;
8775 923B              ;       input: message:WORD - desired operation
8776 923B              ;              param:LONG - depends on operation
8777 923B              ;              theControl:LONG - handle to control
8778 923B              ;
8779 923B              ;      output: RetValue:LONG - depends on operation
8780 923B              ;
8781 923B              ;    function: Define an item of type icon and implements it as a
8782 923B              ;              custom control.
8783 923B              ;
8784 923B              ; ======================================================
8785 923B              ;
8786 923B              ;  IconHandle: Handle to an IconRecord
8787 923B              ;
8788 923B              ;  IconRecord: BoundsRect:RECT - icon rectangle (width must be multiple of 8)
8789 923B              ;              PixelImage: BYTES - icon bitmap
8790 923B              ;
8791 923B              ; Change History
8792 923B              ;
8793 923B              ; 07 Oct 88         Steven Glass
8794 923B              ;
8795 923B              ; Only deref the control handle if the message is not recsize.
8796 923B              ; ======================================================
8797 923B              ;____________________________________________________________________________
8798 923B
8799 923B                       ENTRY IconItemDefProc
8800 923B              IconItemDefProc PROC 
8801 923B
8802 923B              ControlPtr equ   0
8803 923B              Rect     equ   ControlPtr+4
8804 923B              Dialog   equ   Rect+RECTSIZE
8805 923B              IconHandle equ   Dialog+4
8806 923B              IconPtr  equ   IconHandle+4
8807 923B              SizeLocals equ   IconPtr+4
8808 923B
8809 923B EA                    nop   
8810 923C 3B 38 E9 18           link 10,SizeLocals 
8811 9245
8812 9245              theControl equ   input
8813 9245              param    equ   theControl+4
8814 9245              CtlMessage equ   param+4
8815 9245
8816 9245              RetValue equ   output
8817 9245
8818 9245              ;
8819 9245              ; Zeroes out RetValue
8820 9245              ;
8821 9245 64 25                 stz   <RetValue
8822 9247 64 27                 stz   <RetValue+2
8823 9249
8824 9249 A5 23                 lda   <CtlMessage
8825 924B C9 0C 00              cmp   #RecSize
8826 924E F0 35                 beq   SkipThis
8827 9250              ;
8828 9250              ; Dereference Control Handle
8829 9250              ;
8830 9250 A7 1B 85 00           movelong [<theControl],0,<ControlPtr 
8831 925B
8832 925B              ;
8833 925B              ; Get Enclosing Rect
8834 925B              ;
8835 925B A0 08 00 B7           movelong [<ControlPtr],CtrlRect,<Rect 
8836 9269 A0 0C 00 B7           movelong [<ControlPtr],CtrlRect+4,<Rect+4 
8837 9277
8838 9277              ;
8839 9277              ; Get Dialog Pointer
8840 9277              ;
8841 9277 A0 04 00 B7           movelong [<ControlPtr],CtrlOwner,<Dialog 
8842 9285
8843 9285
8844 9285              SkipThis  
8845 9285              ;
8846 9285              ; Dispatch message
8847 9285              ;
8848 9285 A5 23                 lda   <CtlMessage
8849 9287 0A                    asl   a
8850 9288 AA                    tax   
8851 9289 BF 8F 92 FC           lda   >CmdTable,x
8852 928D 48                    pha   
8853 928E 60                    rts   
8854 928F
8855 928F              CmdTable  
8856 928F AE 92                 DC W:DrawIconItem-1
8857 9291 A8 92                 DC W:IconItemExit-1
8858 9293 50 93                 DC W:TestIconItem-1
8859 9295 A8 92                 DC W:IconItemExit-1
8860 9297 A8 92                 DC W:IconItemExit-1
8861 9299 A8 92                 DC W:IconItemExit-1
8862 929B A8 92                 DC W:IconItemExit-1
8863 929D A8 92                 DC W:IconItemExit-1
8864 929F A8 92                 DC W:IconItemExit-1
8865 92A1 AE 92                 DC W:DrawIconItem-1            ; new value fall thru draw routine
8866 92A3 A8 92                 DC W:IconItemExit-1
8867 92A5 A8 92                 DC W:IconItemExit-1
8868 92A7 5D 93                 DC W:RecIconItem-1
8869 92A9
8870 92A9              IconItemExit  
8871 92A9 A2 18 00              ldx   #SizeLocals
8872 92AC 4C D3 89              jmp   quitdefproc
8873 92AF
8874 92AF
8875 92AF
8876 92AF              **************************
8877 92AF              *
8878 92AF              * Draw IconItem
8879 92AF              *
8880 92AF              **************************
8881 92AF
8882 92AF              DrawIconItem  
8883 92AF
8884 92AF              ;
8885 92AF              ; Get icon handle, lock it and dereference it
8886 92AF              ;
8887 92AF A0 1C 00 B7           movelong [<ControlPtr],CtrlData,<IconHandle 
8888 92BD
8889 92BD A5 12 48 A5           pushlong IconHandle 
8890 92C3 A2 02 20 22           _HLock 
8891 92CA
8892 92CA A7 10 85 14           movelong [<IconHandle],0,<IconPtr 
8893 92D5
8894 92D5 3B                    tsc                            ; make room on the stack for a loc info record
8895 92D6 38                    sec                            ; (16 bytes)
8896 92D7 E9 10 00              sbc   #16
8897 92DA 1B                    tcs   
8898 92DB
8899 92DB F4 00 00              pea   0000                     ; Push pointer to src loc info record
8900 92DE 1A                    inc   a
8901 92DF 48                    pha   
8902 92E0
8903 92E0 D4 16                 pei   IconPtr+2                ; Push pointer to src rect
8904 92E2 D4 14                 pei   IconPtr
8905 92E4
8906 92E4 D4 06                 pei   Rect+2                   ; Push dest loc
8907 92E6 D4 04                 pei   Rect
8908 92E8
8909 92E8 F4 00 00              PushWord #0                    ; Push xfer mode
8910 92EB
8911 92EB                       DefineStack                    ; define the current stack offsets
8912 92EB              sXferMode           word  
8913 92EB              sYLoc               word  
8914 92EB              sXLoc               word  
8915 92EB              sSrcRectPtr         LONG  
8916 92EB              sSrcLIPtr           LONG  
8917 92EB              LIOffset            block 16  
8918 92EB
8919 92EB 48                    pha                            ; get current mode from quickdraw.
8920 92EC A2 04 17 22           _GetMasterSCB 
8921 92F3 68                    pla   
8922 92F4 29 80 00              and   #$0080                   ; mask off all but mode byte
8923 92F7 AA                    tax                            ; save copy in x for later and 
8924 92F8 83 0F                 sta   LIOffset,s               ; put mode into LocInfo
8925 92FA
8926 92FA A5 14                 lda   IconPtr                  ; Fill in ImagePtr field of loc info record
8927 92FC 18                    clc                            ; (Image starts 8 bytes from start of icon)
8928 92FD 69 08 00              adc   #8
8929 9300 83 11                 sta   LIOffset+2,s
8930 9302 A5 16                 lda   IconPtr+2
8931 9304 69 00 00              adc   #0
8932 9307 83 13                 sta   LIOffset+4,s
8933 9309
8934 9309 A0 06 00              ldy   #6                       ; to fill in the width field we calculate width from
8935 930C B7 14                 lda   [IconPtr],y              ; src rect
8936 930E 38                    sec   
8937 930F A0 02 00              ldy   #2
8938 9312 F7 14                 sbc   [IconPtr],y              ; this is width of src rect
8939 9314 4A                    lsr   a                        ; divide by 2 for 320 mode (turns pixels to bytes)
8940 9315 9B                    txy                            ; check mode (saved in x earlier)
8941 9316 F0 01                 beq   ModeIs320                ; zero means 320 mode
8942 9318 4A                    lsr   a                        ; non-zero means 640 mode so we must divide again
8943 9319              ModeIs320  
8944 9319 83 15                 sta   LIOffset+6,s             ; store result in loc info record
8945 931B
8946 931B A7 14                 lda   [IconPtr]                ; Finally, we use the rect from the icon as the
8947 931D 83 17                 sta   LIOffset+8,s             ; bounds rect in the locinfo record.
8948 931F A0 02 00              ldy   #2
8949 9322 B7 14                 lda   [IconPtr],y
8950 9324 83 19                 sta   LIOffset+8+2,s
8951 9326 A0 04 00              ldy   #4
8952 9329 B7 14                 lda   [IconPtr],y
8953 932B 83 1B                 sta   LIOffset+8+4,s
8954 932D A0 06 00              ldy   #6
8955 9330 B7 14                 lda   [IconPtr],y
8956 9332 83 1D                 sta   LIOffset+8+6,s
8957 9334
8958 9334 A2 04 D6 22           _PPToPort                      ; make the call
8959 933B
8960 933B 3B                    tsc                            ; take the 16 bytes for the loc info record back off
8961 933C 18                    clc                            ; the stack
8962 933D 69 10 00              adc   #16
8963 9340 1B                    tcs   
8964 9341
8965 9341
8966 9341              ;
8967 9341              ; Unlock icon handle
8968 9341              ;
8969 9341 A5 12 48 A5           pushlong IconHandle 
8970 9347 A2 02 22 22           _HUnlock 
8971 934E
8972 934E 82 58 FF              brl   IconItemExit
8973 9351
8974 9351
8975 9351              *******************
8976 9351              *
8977 9351              * Test IconItem
8978 9351              *
8979 9351              ******************
8980 9351
8981 9351              TestIconItem  
8982 9351
8983 9351 A9 0E 00 85           movelong #inIconItem,<RetValue 
8984 935B
8985 935B 82 4B FF              brl   IconItemExit
8986 935E
8987 935E
8988 935E              *******************
8989 935E              *
8990 935E              * RecSize IconItem
8991 935E              *
8992 935E              ******************
8993 935E
8994 935E              RecIconItem  
8995 935E
8996 935E              ;
8997 935E              ; Returns IconItemSIZE
8998 935E              ;
8999 935E A9 28 00 85           movelong #IconItemSIZE,<RetValue 
9000 9368
9001 9368 82 3E FF              brl   IconItemExit
9002 936B
9003 936B                       ENDP 
9004 936B
9005 936B
9006 936B              ;            copy  DUndef.asm
9007 936B              ; DUndef.asm                            Jean-Charles Mourey
9008 936B
9009 936B                       TITLE 'Currently unimplemented Calls & Procedures'
9010 936B
9011 936B                       ENTRY RESERVED
9012 936B              RESERVED PROC 
9013 936B 6B                    rtl   
9014 936C                       ENDP 
9015 936C
9016 936C              ;
9017 936C              ; Custom Controls Def Proc
9018 936C              ;
9019 936C                       ENTRY PicItemDefProc
9020 936C              PicItemDefProc PROC 
9021 936C 6B                    rtl   
9022 936D                       ENDP 
9023 936D
9024 936D
9025 936D
9026 936D              **********************************************************************
9027 936D              *
9028 936D              * NormalTextColor
9029 936D              *
9030 936D              * Sets the foreground color to black and the background color to
9031 936D              * white.
9032 936D              *
9033 936D              * Change History
9034 936D              *
9035 936D              * 07 Jun 88         Steve and Harry
9036 936D              *
9037 936D              * Added today.
9038 936D              *
9039 936D              **********************************************************************
9040 936D              NormalTextColor Proc 
9041 936D
9042 936D F4 00 00              pea   $0000
9043 9370 A2 04 A0 22           _SetForeColor 
9044 9377 F4 FF FF              pea   $FFFF
9045 937A A2 04 A2 22           _SetBackColor 
9046 9381
9047 9381 60                    rts   
9048 9382
9049 9382                       ENDP 
9050 9382
9051 9382                       END   
9052 9382
